/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import com.enderio.core.api.client.render.IWidgetIcon;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractItemConduit;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.conduit.power.PowerConduitRenderer;
import crazypants.enderio.conduit.registry.ConduitRegistry;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.power.PowerDisplayUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPowerConduit
extends AbstractItemConduit {
    private static String PREFIX;
    private static String POSTFIX;
    static ItemConduitSubtype[] SUBTYPES;
    private final ConduitRegistry.ConduitInfo conduitInfo = new ConduitRegistry.ConduitInfo(this.getBaseConduitType(), Offset.DOWN, Offset.DOWN, Offset.SOUTH, Offset.DOWN);

    public static ItemPowerConduit create() {
        ItemPowerConduit result = new ItemPowerConduit();
        result.init();
        return result;
    }

    protected ItemPowerConduit() {
        super(ModObject.itemPowerConduit, SUBTYPES);
        this.conduitInfo.addMember(PowerConduit.class);
        ConduitRegistry.register(this.conduitInfo);
        ConduitDisplayMode.registerDisplayMode(new ConduitDisplayMode(this.getBaseConduitType(), (IWidgetIcon)IconEIO.WRENCH_OVERLAY_POWER, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_POWER_OFF));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        super.registerRenderers();
        this.conduitInfo.addRenderer(new PowerConduitRenderer());
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public IConduit createConduit(ItemStack stack, EntityPlayer player) {
        return new PowerConduit(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        if (PREFIX == null) {
            POSTFIX = " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
            PREFIX = EnderIO.lang.localize("power.maxOutput") + " ";
        }
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        int cap = PowerConduit.getMaxEnergyIO(itemStack.func_77960_j());
        list.add(PREFIX + PowerDisplayUtil.formatPower(cap) + POSTFIX);
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }

    static {
        SUBTYPES = new ItemConduitSubtype[]{new ItemConduitSubtype(ModObject.itemPowerConduit.name(), "enderio:itemPowerConduit"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Enhanced", "enderio:itemPowerConduitEnhanced"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Ender", "enderio:itemPowerConduitEnder")};
    }
}

