/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.loot.WeightedInteger;
import crazypants.enderio.loot.WeightedUpgrade;
import crazypants.util.NbtValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootSelector
extends LootFunction {
    private static final List<WeightedInteger> weightedCount = new ArrayList<WeightedInteger>();

    public LootSelector(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int n;
        int n2;
        HashMap<Object, Float> keys = new HashMap<Object, Float>();
        float baselevel = this.getRandomBaseLevel(rand);
        int no = this.getRandomCount(rand);
        for (int i = 0; i < no; ++i) {
            WeightedUpgrade randomKey = this.getUpgrade(rand);
            float f = LootSelector.getRandomLevel(baselevel, rand);
            baselevel = Math.max(baselevel - f / 10.0f * rand.nextFloat(), 0.5f);
            if (keys.containsKey((Object)randomKey)) {
                f = Math.max(f, ((Float)keys.get((Object)randomKey)).floatValue());
            }
            keys.put((Object)randomKey, Float.valueOf(f));
        }
        String name = LootSelector.buildBaseName(EnderIO.lang.localize("itemBasicCapacitor.name"), baselevel);
        stack = CapacitorHelper.addCapData(stack, CapacitorHelper.SetType.LEVEL, null, baselevel);
        for (Map.Entry entry : keys.entrySet()) {
            stack = CapacitorHelper.addCapData(stack, ((WeightedUpgrade)((Object)entry.getKey())).setType, ((WeightedUpgrade)((Object)entry.getKey())).capacitorKey, ((Float)entry.getValue()).floatValue());
            name = LootSelector.buildName(EnderIO.lang.localize(((WeightedUpgrade)((Object)entry.getKey())).langKey, new Object[]{name}), ((Float)entry.getValue()).floatValue());
        }
        NbtValue.CAPNAME.setString(stack, name);
        String count_s = EnderIO.lang.localize("loot.capacitor.entry.count");
        int n3 = 8;
        try {
            n2 = Integer.valueOf(count_s);
        }
        catch (NumberFormatException e) {
            Log.warn("The value of the language key 'enderio.loot.capacitor.entry.count' is not a valid number!");
        }
        NbtValue.CAPNO.setInt(stack, rand.nextInt(n2));
        count_s = EnderIO.lang.localize("loot.capacitor.title.count");
        int n4 = 8;
        try {
            n = Integer.valueOf(count_s);
        }
        catch (NumberFormatException e) {
            Log.warn("The value of the language key 'enderio.loot.capacitor.title.count' is not a valid number!");
        }
        stack.func_151001_c(EnderIO.lang.localize("loot.capacitor.title." + rand.nextInt(n)));
        NbtValue.GLINT.setInt(stack, 1);
        return stack;
    }

    private int getRandomCount(Random rand) {
        return ((WeightedInteger)WeightedRandom.func_76271_a((Random)rand, weightedCount)).getInteger();
    }

    public static String buildBaseName(String name, float level) {
        name = level < 1.0f ? EnderIO.lang.localize("loot.capacitor.baselevel.10", new Object[]{name}) : (level < 1.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.15", new Object[]{name}) : (level < 2.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.25", new Object[]{name}) : (level < 3.5f ? EnderIO.lang.localize("loot.capacitor.baselevel.35", new Object[]{name}) : EnderIO.lang.localize("loot.capacitor.baselevel.45", new Object[]{name}))));
        return name;
    }

    public static String buildName(String name, float level) {
        name = level < 1.0f ? EnderIO.lang.localize("loot.capacitor.level.10", new Object[]{name}) : (level < 1.5f ? EnderIO.lang.localize("loot.capacitor.level.15", new Object[]{name}) : (level < 2.5f ? EnderIO.lang.localize("loot.capacitor.level.25", new Object[]{name}) : (level < 3.0f ? EnderIO.lang.localize("loot.capacitor.level.30", new Object[]{name}) : (level < 3.5f ? EnderIO.lang.localize("loot.capacitor.level.35", new Object[]{name}) : (level < 4.0f ? EnderIO.lang.localize("loot.capacitor.level.40", new Object[]{name}) : (level < 4.25f ? EnderIO.lang.localize("loot.capacitor.level.42", new Object[]{name}) : EnderIO.lang.localize("loot.capacitor.level.45", new Object[]{name})))))));
        return name;
    }

    private float getRandomBaseLevel(Random rand) {
        if (rand.nextFloat() < 0.3f) {
            return 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.5f;
        }
        return 1.0f + rand.nextFloat() + rand.nextFloat() + rand.nextFloat() + rand.nextFloat();
    }

    private static float getRandomLevel(float baseLevel, Random rand) {
        return (LootSelector.getRandomLevel2(baseLevel - 0.6f, rand) + LootSelector.getRandomLevel2(baseLevel + 0.5f, rand)) / 2.0f - 0.5f;
    }

    private static float getRandomLevel2(float baseLevel, Random rand) {
        float result = baseLevel + rand.nextFloat() * (4.0f - baseLevel) / 3.0f;
        for (int i = 1; i < 2; ++i) {
            if (!((result += rand.nextFloat() / (float)i * 2.0f) >= baseLevel + 1.0f)) continue;
            result -= rand.nextFloat() / (float)(i + 1);
        }
        return Math.min(result, 4.75f);
    }

    private WeightedUpgrade getUpgrade(Random rand) {
        return ((WeightedUpgrade.WeightedUpgradeImpl)WeightedRandom.func_76271_a((Random)rand, WeightedUpgrade.getWeightedupgrades())).getUpgrade();
    }

    static void test_getRandomLevel(float baselevel) {
        Random rand = new Random();
        int runs = 100000;
        int[] a = new int[50];
        for (int i = 0; i < runs; ++i) {
            int idx;
            float randomLevel = LootSelector.getRandomLevel(baselevel, rand);
            int n = idx = (int)(randomLevel * 10.0f);
            a[n] = a[n] + 1;
        }
        int max = 0;
        for (int j = 0; j < 50; ++j) {
            if (a[j] < max) continue;
            max = a[j];
        }
        for (int i = max; i > 0; i -= max / 20) {
            for (int j = 0; j < 50; ++j) {
                if (a[j] >= i) {
                    System.out.print("#");
                    continue;
                }
                System.out.print(" ");
            }
            System.out.println();
        }
        System.out.println("0....|...1.0...|...2.0...|...3.0...|...4.0...|...5.0");
    }

    static {
        weightedCount.add(new WeightedInteger(1, 5));
        weightedCount.add(new WeightedInteger(3, 4));
        weightedCount.add(new WeightedInteger(6, 3));
        weightedCount.add(new WeightedInteger(6, 2));
        weightedCount.add(new WeightedInteger(24, 1));
    }

    public static class Serializer
    extends LootFunction.Serializer<LootSelector> {
        public Serializer() {
            super(new ResourceLocation(EnderIO.DOMAIN, "set_capacitor"), LootSelector.class);
        }

        public void serialize(JsonObject object, LootSelector functionClazz, JsonSerializationContext serializationContext) {
        }

        public LootSelector deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new LootSelector(conditionsIn);
        }
    }
}

