/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.Prep;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ForestryFarmer
implements IFarmerJoe {
    private ITreeRoot root;
    private Item forestrySapling;

    private ForestryFarmer(ITreeRoot root, Item forestrySapling) {
        this.root = root;
        this.forestrySapling = forestrySapling;
    }

    public static void init() {
        ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        Item forestrySapling = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("forestry", "sapling"));
        if (root != null && forestrySapling != null) {
            FarmersCommune.joinCommune(new ForestryFarmer(root, forestrySapling));
        }
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77973_b() == this.forestrySapling && this.root.getType(stack) == EnumGermlingType.SAPLING;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState state) {
        ITree tree;
        ItemStack sapling = farm.getSeedTypeInSuppliesFor(bc);
        if (Prep.isValid(sapling) && sapling.func_77973_b() == this.forestrySapling && (tree = this.root.getMember(sapling)) != null && tree.canStay((IBlockAccess)farm.func_145831_w(), bc) && Prep.isValid(farm.takeSeedFromSupplies(sapling, bc, false))) {
            this.root.plantSapling(farm.func_145831_w(), tree, farm.getFakePlayer().func_146103_bH(), bc);
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState state) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState state) {
        return null;
    }
}

