/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.chest;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.invpanel.chest.EnumChestSize;
import crazypants.enderio.machine.invpanel.chest.TileInventoryChest;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.property.EnumRenderMode;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryChest
extends AbstractMachineBlock<TileInventoryChest>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockInventoryChest create() {
        TileInventoryChest.create();
        BlockInventoryChest res = new BlockInventoryChest();
        res.init();
        return res;
    }

    protected BlockInventoryChest() {
        super(ModObject.blockInventoryChest, TileInventoryChest.class);
        this.initDefaultState();
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(EnumChestSize.SIZE, (Comparable)((Object)EnumChestSize.TINY)));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, EnumChestSize.SIZE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumChestSize.SIZE, (Comparable)((Object)EnumChestSize.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return EnumChestSize.getMetaFromType((EnumChestSize)((Object)state.func_177229_b(EnumChestSize.SIZE)));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileInventoryChest tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive()).addCacheKey(blockStateWrapper.func_177229_b((IProperty)EnumChestSize.SIZE));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    protected GuiID getGuiId() {
        return null;
    }

    @Override
    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockStateIn, World worldIn, BlockPos pos) {
        TileInventoryChest te = (TileInventoryChest)this.getTileEntitySafe((IBlockAccess)worldIn, pos);
        if (te != null) {
            return te.getComparatorInputOverride();
        }
        return 0;
    }

    @Nonnull
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileInventoryChest te = TileInventoryChest.create((EnumChestSize)((Object)state.func_177229_b(EnumChestSize.SIZE)));
        te.init();
        return te;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected ItemBlock createItemBlock() {
        ItemBlock ib = new ItemBlock((Block)this){

            public String func_77667_c(ItemStack stack) {
                return EnumChestSize.getTypeFromMeta(stack.func_77960_j()).getUnlocalizedName((Item)this);
            }

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        ib.setRegistryName(this.getName());
        ib.func_77627_a(true);
        return ib;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumChestSize size : EnumChestSize.values()) {
            list.add(new ItemStack(itemIn, 1, EnumChestSize.getMetaFromType(size)));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }
}

