/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machine.killera.TileKillerJoe;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiKillerJoe
extends GuiMachineBase<TileKillerJoe> {
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(18, 11, 15, 47);
    private ToggleButton showRangeB;

    public GuiKillerJoe(InventoryPlayer inventory, final TileKillerJoe tileEntity) {
        super(tileEntity, (Container)new ContainerKillerJoe(inventory, tileEntity), "killerJoe");
        this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("killerJoe.fuelTank");
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileKillerJoe)((GuiKillerJoe)GuiKillerJoe.this).getTileEntity()).tank));
                if (tileEntity.tank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(EnderIO.lang.localize("gui.fluid.minReq", new Object[]{tileEntity.getActivationAmount() + Fluids.MB()}));
                }
            }
        });
        int spacing = 5;
        int bw = 16;
        int x = 81;
        int y = 44;
        x += spacing + bw;
        x += spacing + bw;
        x = this.getXSize() - 5 - 16;
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, x, 44, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{EnderIO.lang.localize(GuiKillerJoe.this.showRangeB.isSelected() ? "gui.spawnGurad.hideRange" : "gui.spawnGurad.showRange")});
            }
        });
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileKillerJoe)this.getTileEntity()).tank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TileKillerJoe)this.getTileEntity()).isShowingRange());
        ((ContainerKillerJoe)this.field_147002_h).createGhostSlots(this.getGhostSlots());
    }

    protected void func_146284_a(GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b == this.showRangeB) {
            ((TileKillerJoe)this.getTileEntity()).setShowRange(this.showRangeB.isSelected());
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 16;
            int y = 9;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = this.field_147003_i + 18;
        int y = this.field_147009_r + 11;
        TileKillerJoe joe = (TileKillerJoe)this.getTileEntity();
        if (joe.tank.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidStack)joe.tank.getFluid(), (int)joe.tank.getCapacity(), (int)joe.tank.getFluidAmount(), (double)x, (double)y, (double)this.field_73735_i, (double)16.0, (double)47.0);
        }
        super.func_146976_a(par1, par2, par3);
    }
}

