/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileSoulBinder
extends AbstractPoweredTaskEntity
implements IHaveExperience,
ITankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    private final ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.soulBinderMaxXpLevel)){

        @Override
        public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
            return super.drain(from, Math.min(XpUtil.experienceToLiquid(TileSoulBinder.this.getExcessXP()), maxDrain), doDrain);
        }

        @Override
        public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
            int max = XpUtil.experienceToLiquid(TileSoulBinder.this.getXPRequired());
            if (resource == null || max <= 0) {
                return 0;
            }
            if (max < resource.amount) {
                FluidStack copy = resource.copy();
                copy.amount = max;
                return super.fill(from, copy, doFill);
            }
            return super.fill(from, resource, doFill);
        }
    };
    private boolean wasWorking = false;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileSoulBinder() {
        super(new SlotDefinition(2, 2, 1), CapacitorKey.SOUL_BINDER_POWER_INTAKE, CapacitorKey.SOUL_BINDER_POWER_BUFFER, CapacitorKey.SOUL_BINDER_POWER_USE);
        this.xpCont.setTileEntity((TileEntity)this);
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockSoulBinder.getUnlocalisedName();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        if (this.isActive()) {
            this.sendTaskProgressPacket();
        }
        return super.processTasks(redstoneChecksPassed);
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe recipe = super.canStartNextTask(chance);
        if (recipe == null) {
            return null;
        }
        int xpRequired = ((ISoulBinderRecipe)((Object)recipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() >= xpRequired) {
            return recipe;
        }
        return null;
    }

    public boolean needsXP() {
        return this.getXPRequired() > 0;
    }

    private int getXPRequired() {
        if (this.currentTask != null) {
            return 0;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return 0;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired() - this.getContainer().getExperienceTotal();
    }

    public int getCurrentlyRequiredLevel() {
        if (this.currentTask != null) {
            return -1;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return -1;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceLevelsRequired();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        int xpRequired = ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() < xpRequired) {
            return false;
        }
        if (super.startNextTask(nextRecipe, chance)) {
            this.xpCont.drain(null, XpUtil.experienceToLiquid(xpRequired), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, ItemStack item) {
        int otherSlot;
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        MachineRecipeInput newInput = new MachineRecipeInput(slot, item);
        int n = otherSlot = slot == 0 ? 1 : 0;
        if (this.inventory[otherSlot] == null) {
            List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), newInput);
            if (recipes.isEmpty()) {
                return false;
            }
            for (IMachineRecipe rec : recipes) {
                if (rec == null || !rec.isValidInput(newInput)) continue;
                return true;
            }
        } else {
            MachineRecipeInput[] inputs = new MachineRecipeInput[]{newInput, new MachineRecipeInput(otherSlot, this.inventory[otherSlot])};
            return MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), inputs) != null;
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        int req = this.getXPRequired();
        if (dir != null && req > 0 && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.xpCont, (int)Math.min(XpUtil.experienceToLiquid(req), Config.fluidConduitExtractRate)) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        boolean res = super.doPush(dir);
        int maxAmount = Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), Config.fluidConduitExtractRate);
        if (dir != null && maxAmount > 0 && FluidWrapper.transfer((FluidTank)this.xpCont, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)maxAmount) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    private int getExcessXP() {
        IMachineRecipe nextRecipe;
        if (this.currentTask == null && (nextRecipe = this.getNextRecipe()) instanceof ISoulBinderRecipe) {
            return Math.max(0, this.getContainer().getExperienceTotal() - ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired());
        }
        return this.getContainer().getExperienceTotal();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }

    public boolean isWorking() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f;
    }

    @Override
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.wasWorking != this.isWorking()) {
            this.wasWorking = this.isWorking();
            this.updateBlock();
        }
    }

    @Override
    public String getSoundName() {
        return "machine.soulbinder";
    }

    @Override
    public float getPitch() {
        float pitch;
        switch (this.getCapacitorData().getBaseLevel()) {
            case 1: {
                pitch = 0.8f;
                break;
            }
            case 2: {
                pitch = 0.85f;
                break;
            }
            case 3: {
                pitch = 0.9f;
                break;
            }
            default: {
                pitch = 1.0f;
            }
        }
        return pitch + this.random.nextFloat() * 0.08f - 0.04f;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.xpCont});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

