/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint;

import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.IHideFacades;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.tool.ToolUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class YetaUtil {
    @Nonnull
    private static volatile YetaDisplayMode lastCheckResult = new YetaDisplayMode();
    private static boolean toggled = false;

    public static boolean shouldHeldItemHideFacades(EntityPlayer player) {
        ItemStack held = player.func_184614_ca();
        boolean checkResult = held != null && held.func_77973_b() instanceof IHideFacades ? ((IHideFacades)held.func_77973_b()).shouldHideFacades(held, player) : ToolUtil.isToolEquipped(player, EnumHand.MAIN_HAND);
        return checkResult;
    }

    public static void onClientTick() {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        boolean checkResult = YetaUtil.shouldHeldItemHideFacades(player);
        toggled = lastCheckResult.isHideFacades() != checkResult;
        lastCheckResult.setHideFacades(checkResult);
        lastCheckResult.setDisplayMode(YetaUtil.getDisplayMode(player));
    }

    public static boolean shouldHeldItemHideFacadesClient() {
        return lastCheckResult.isHideFacades();
    }

    public static ConduitDisplayMode getDisplayModeClient() {
        return lastCheckResult.getDisplayMode();
    }

    @Nonnull
    public static YetaDisplayMode getYetaDisplayMode() {
        return new YetaDisplayMode(lastCheckResult);
    }

    public static void refresh(TileEntity te) {
        if (toggled && te instanceof IPaintable.IPaintableTileEntity && ((IPaintable.IPaintableTileEntity)te).getPaintSource() != null) {
            BlockPos pos = te.func_174877_v();
            IBlockState bs = te.func_145831_w().func_180495_p(pos);
            te.func_145831_w().func_184138_a(pos, bs, bs, 3);
        }
    }

    public static ConduitDisplayMode getDisplayMode(EntityPlayer player) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return ConduitDisplayMode.ALL;
        }
        ItemStack equipped = player.func_184614_ca();
        if (equipped == null) {
            return ConduitDisplayMode.ALL;
        }
        ConduitDisplayMode result = ConduitDisplayMode.getDisplayMode(equipped);
        if (result == null) {
            return ConduitDisplayMode.ALL;
        }
        return result;
    }

    public static boolean isFacadeHidden(IPaintable.IPaintableTileEntity bundle, EntityPlayer player) {
        if (bundle.getPaintSource() == null) {
            return false;
        }
        if (player == null || player.field_70170_p.field_72995_K) {
            return YetaUtil.shouldHeldItemHideFacadesClient();
        }
        return YetaUtil.shouldHeldItemHideFacades(player);
    }

    public static boolean isSolidFacadeRendered(IConduitBundle bundle, EntityPlayer player) {
        return bundle.hasFacade() && !YetaUtil.isFacadeHidden(bundle, player);
    }

    public static boolean renderConduit(EntityPlayer player, Class<? extends IConduit> conduitType) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return lastCheckResult.renderConduit(conduitType);
        }
        return YetaUtil.getDisplayMode(player).renderConduit(conduitType);
    }

    public static boolean renderConduit(EntityPlayer player, IConduit con) {
        return YetaUtil.renderConduit(player, con.getBaseConduitType());
    }

    public static class YetaDisplayMode {
        private boolean hideFacades = false;
        private ConduitDisplayMode displayMode = ConduitDisplayMode.ALL;

        private YetaDisplayMode() {
        }

        private YetaDisplayMode(YetaDisplayMode global) {
            this.hideFacades = global.hideFacades;
            this.displayMode = global.displayMode;
        }

        public boolean isHideFacades() {
            return this.hideFacades;
        }

        public ConduitDisplayMode getDisplayMode() {
            return this.displayMode;
        }

        void setHideFacades(boolean hideFacades) {
            this.hideFacades = hideFacades;
        }

        void setDisplayMode(ConduitDisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public boolean renderConduit(Class<? extends IConduit> conduitType) {
            return this.displayMode.renderConduit(conduitType);
        }

        public boolean renderConduit(IConduit con) {
            return this.renderConduit(con.getBaseConduitType());
        }
    }
}

