/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.rf;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.IPowerInterface;
import net.minecraft.util.EnumFacing;

public class PowerInterfaceRF
implements IPowerInterface {
    private final IEnergyConnection con;
    private IEnergyHandler eh;
    private IEnergyReceiver er;
    private final EnumFacing side;

    public PowerInterfaceRF(IEnergyConnection con, EnumFacing side) {
        this.con = con;
        if (con instanceof IEnergyHandler) {
            this.eh = (IEnergyHandler)con;
        }
        if (con instanceof IEnergyReceiver) {
            this.er = (IEnergyReceiver)con;
        }
        this.side = side;
    }

    @Override
    public Object getProvider() {
        return this.con;
    }

    public int getEnergyStored() {
        if (this.eh == null) {
            return 0;
        }
        return this.eh.getEnergyStored(this.side);
    }

    public int getMaxEnergyStored() {
        if (this.eh == null) {
            return 0;
        }
        return this.eh.getMaxEnergyStored(this.side);
    }

    public int receiveEnergy(int canOffer, boolean sim) {
        if (this.er == null) {
            return 0;
        }
        return this.er.receiveEnergy(this.side, canOffer, sim);
    }

    public static int getPowerRequest(EnumFacing north, IInternalPowerReceiver pr) {
        return pr.receiveEnergy(north, 999999, true);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.er != null;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }
}

