/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.ITESRItemBlock;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.model.CollectedItemQuadBakedBlockModel;
import crazypants.enderio.render.model.RelayingBakedModel;
import crazypants.enderio.render.pipeline.CacheKey;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.util.ItemQuadCollector;
import crazypants.util.NullHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class EnderItemOverrideList
extends ItemOverrideList {
    private static final Cache<Pair<Block, Long>, ItemQuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).build();
    public static final EnderItemOverrideList instance = new EnderItemOverrideList();

    public EnderItemOverrideList() {
        super(Collections.emptyList());
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        IRenderMapper.IItemRenderMapper renderMapper;
        IBlockState paintSource;
        if (originalModel == null || stack == null || stack.func_77973_b() == null) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            throw new NullPointerException("Wrong parameter 'ItemStack stack', not an ItemBlock");
        }
        if (block instanceof ITESRItemBlock) {
            return RelayingBakedModel.wrapModelForTESRRendering(originalModel);
        }
        if (!(!(block instanceof IPaintable.IBlockPaintableBlock) || block instanceof IPaintable.IWrenchHideablePaint && YetaUtil.shouldHeldItemHideFacadesClient() || (paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(block, stack)) == null)) {
            Pair cacheKey = NullHelper.notnull(Pair.of((Object)null, (Object)new CacheKey().addCacheKey(paintSource).getCacheKey()), "no way");
            ItemQuadCollector quads = (ItemQuadCollector)cache.getIfPresent((Object)cacheKey);
            if (quads == null) {
                quads = new ItemQuadCollector();
                quads.addItemBlockState(paintSource, null);
                quads.addBlockState(BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY)), null);
                cache.put((Object)cacheKey, (Object)quads);
            }
            return new CollectedItemQuadBakedBlockModel(originalModel, quads);
        }
        if (block instanceof ISmartRenderAwareBlock && (renderMapper = ((ISmartRenderAwareBlock)block).getItemRenderMapper()) != null) {
            ItemQuadCollector quads;
            Pair cacheKey = Pair.of((Object)block, (Object)renderMapper.getCacheKey(block, stack, new CacheKey().addCacheKey(stack.func_77960_j())).getCacheKey());
            ItemQuadCollector itemQuadCollector = quads = cacheKey.getRight() == null ? null : (ItemQuadCollector)cache.getIfPresent((Object)cacheKey);
            if (quads == null) {
                quads = new ItemQuadCollector();
                if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IItemStateMapper) {
                    quads.addBlockStates(((IRenderMapper.IItemRenderMapper.IItemStateMapper)renderMapper).mapItemRender(block, stack, quads), stack, block);
                } else if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IItemModelMapper) {
                    List<IBakedModel> bakedModels = ((IRenderMapper.IItemRenderMapper.IItemModelMapper)renderMapper).mapItemRender(block, stack);
                    if (bakedModels != null) {
                        for (IBakedModel bakedModel : bakedModels) {
                            quads.addItemBakedModel(bakedModel);
                        }
                    }
                } else {
                    return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
                }
                if (cacheKey.getRight() != null) {
                    cache.put((Object)cacheKey, (Object)quads);
                }
            }
            if (renderMapper instanceof IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper) {
                quads = quads.combine(((IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper)renderMapper).mapItemDynamicOverlayRender(block, stack));
            }
            return new CollectedItemQuadBakedBlockModel(originalModel, quads);
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
    }
}

