/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class InventoryScanner {
    public static String getUUID(EntityPlayer player, ItemStack stack) {
        QuantumChestTileEntity.VirtualQuantumChest chest;
        if (stack.func_77973_b() instanceof QuantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(stack))) != null && chest.canStrictlyUse(player.field_70170_p, player.func_70005_c_())) {
            return chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
        }
        return UniqueItem.getIdentifier(stack);
    }

    public static boolean backpackCanAccept(NBTTagCompound tag, ItemStack item) {
        boolean inverse;
        if (tag == null) {
            return false;
        }
        if (item == null) {
            return true;
        }
        if (tag.func_74767_n("collect-paused")) {
            return false;
        }
        if (!tag.func_150297_b("filtered", 99) || !tag.func_74767_n("filtered")) {
            return true;
        }
        if (!tag.func_150297_b("collect", 10)) {
            return false;
        }
        tag = tag.func_74775_l("collect");
        String id = UniqueItem.getDescriptor(item.func_77973_b()).replace(":", "+");
        boolean bl = inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        if (tag.func_74764_b(id) || tag.func_74764_b(id + "@" + item.func_77960_j())) {
            return !inverse;
        }
        return inverse;
    }

    public static int scanInventory(EntityPlayer player, UniqueItemData data, IInventory inventory, ItemStack accepts, int pos, boolean adding, HashSet<String> visited, EnumHand replenishHand) {
        String key = adding ? "collect" : "replenish";
        for (int i = pos; i < inventory.func_70302_i_(); ++i) {
            NBTTagCompound tag;
            ItemStack stack = inventory.func_70301_a(i);
            String uuid = null;
            if (stack == null || !(stack.func_77973_b() instanceof Backpack) && !(stack.func_77973_b() instanceof QuantumBackpack) || (uuid = InventoryScanner.getUUID(player, stack)) == null || uuid.equals("none") || !data.strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), uuid, 2) || visited.contains(uuid)) continue;
            visited.add(uuid);
            UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
            if (inv != null) {
                InventoryScanner.scanInventory(data, player, inv, accepts, adding, visited, replenishHand);
            }
            if ((tag = data.getItemData(uuid, false)) == null || !tag.func_150297_b(key, 10) || !InventoryScanner.backpackAccepts(tag = tag.func_74775_l(key), accepts)) continue;
            if (!adding) {
                boolean inverse;
                if (inv == null) continue;
                boolean bl = inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
                if (!InventoryScanner.canReplenishItem(player, inv, UniqueItem.getDescriptor(accepts.func_77973_b()), accepts.func_77960_j(), replenishHand) && (tag.func_74764_b(UniqueItem.getDescriptor(accepts.func_77973_b()).replace(":", "+")) == inverse || !InventoryScanner.canReplenishItem(player, inv, UniqueItem.getDescriptor(accepts.func_77973_b()), Short.MAX_VALUE, replenishHand))) continue;
                inv.saveInventory();
            }
            return i;
        }
        return -1;
    }

    public static void loadFromInventory(EntityPlayer player, IInventory inventory) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        boolean isFromPlayerInventory = inventory instanceof InventoryPlayer;
        int inventorySize = inventory.func_70302_i_();
        if (isFromPlayerInventory) {
            inventorySize = ((InventoryPlayer)inventory).field_70462_a.length;
        }
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack stack;
            if (inventory instanceof InventoryPlayer) {
                InventoryPlayer cfr_ignored_0 = (InventoryPlayer)inventory;
                if (i < InventoryPlayer.func_70451_h()) continue;
            }
            if ((stack = inventory.func_70301_a(i)) == null || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) continue;
            InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, true, new HashSet<String>(), EnumHand.MAIN_HAND);
            if (stack.field_77994_a != 0) continue;
            inventory.func_70299_a(i, null);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        ItemStack stack = event.getItem().func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (event.getItem().func_174874_s() || stack.field_77994_a < 1) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, true, new HashSet<String>(), EnumHand.MAIN_HAND);
        if (stack.field_77994_a == 0) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(PlayerDestroyItemEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        try {
            ItemStack stack = event.getOriginal();
            EntityPlayer player = event.getEntityPlayer();
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            EnumHand hand = event.getHand();
            if (hand == null) {
                hand = EnumHand.MAIN_HAND;
            }
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (player.func_184586_b(hand) != null && player.func_184586_b((EnumHand)hand).field_77994_a == 0) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, null);
            }
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (player.func_184586_b(EnumHand.MAIN_HAND) != null) {
                return;
            }
            InventoryScanner.scanInventory(data, player, (IInventory)player.field_71071_by, stack, false, new HashSet<String>(), hand);
        }
        catch (Exception ignore) {
            return;
        }
    }

    public static void scanInventory(UniqueItemData data, EntityPlayer player, IInventory inventory, ItemStack stack, boolean adding, HashSet<String> visited, EnumHand replenishHand) {
        int i = 0;
        while (i != -1 && (adding && stack.field_77994_a > 0 || !adding && player.func_184586_b(replenishHand) == null)) {
            if ((i = InventoryScanner.scanInventory(player, data, inventory, stack, i, adding, visited, replenishHand)) == -1) continue;
            String uuid = InventoryScanner.getUUID(player, inventory.func_70301_a(i));
            UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
            if (adding && inv != null && InventoryScanner.addItemStackToInventory(inv, stack, true, true)) {
                inv.saveInventory();
            }
            ++i;
        }
        if (adding && stack.field_77994_a > 0 && inventory instanceof UniqueItemInventory) {
            String desc;
            NBTTagCompound tag = data.getItemData(((UniqueItemInventory)inventory).getIdentifier(), false);
            if (tag == null || !tag.func_74767_n("fillExisting")) {
                return;
            }
            boolean autoCollectAll = tag.func_74767_n("autoCollectAll");
            if (!(tag = tag.func_74775_l("collect")).func_74764_b(desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+")) && !tag.func_74764_b(desc + "@" + stack.func_77960_j()) && InventoryScanner.addItemStackToInventory((UniqueItemInventory)inventory, stack, false, autoCollectAll)) {
                ((UniqueItemInventory)inventory).saveInventory();
            }
        }
    }

    public static boolean addItemStackToInventory(UniqueItemInventory inventory, ItemStack par1ItemStack, boolean fillEmptySlots, boolean autoCollectAll) {
        if (par1ItemStack != null && par1ItemStack.field_77994_a != 0 && par1ItemStack.func_77973_b() != null) {
            int i;
            if (par1ItemStack.func_77951_h()) {
                int i2 = InventoryScanner.getFirstEmptyStack(inventory);
                if (i2 >= 0 && fillEmptySlots) {
                    inventory.func_70299_a(i2, ItemStack.func_77944_b((ItemStack)par1ItemStack));
                    par1ItemStack.field_77994_a = 0;
                    return true;
                }
                return false;
            }
            int originalStackSize = par1ItemStack.field_77994_a;
            do {
                i = par1ItemStack.field_77994_a;
                par1ItemStack.field_77994_a = InventoryScanner.storePartialItemStack(inventory, par1ItemStack, fillEmptySlots, autoCollectAll);
            } while (par1ItemStack.field_77994_a > 0 && par1ItemStack.field_77994_a < i);
            return par1ItemStack.field_77994_a < originalStackSize;
        }
        return false;
    }

    public static boolean canReplenishItem(EntityPlayer player, UniqueItemInventory inventory, String id, int metadata, EnumHand hand) {
        if (player.func_184586_b(hand) != null) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !UniqueItem.getDescriptor(stack.func_77973_b()).equals(id) || metadata != Short.MAX_VALUE && metadata != stack.func_77960_j()) continue;
            player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stack);
            inventory.func_70299_a(i, null);
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean backpackAccepts(NBTTagCompound tag, ItemStack stack) {
        if (tag == null || stack == null) {
            return false;
        }
        if (tag.func_74767_n("collect-paused")) {
            return false;
        }
        boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        if (tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + stack.func_77960_j())) {
            return !inverse;
        }
        return inverse;
    }

    public static int getFirstEmptyStack(UniqueItemInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static int storePartialItemStack(UniqueItemInventory inventory, ItemStack par1ItemStack, boolean fillEmptySlots, boolean autoCollectAll) {
        Item item = par1ItemStack.func_77973_b();
        int i = par1ItemStack.field_77994_a;
        boolean found = false;
        if (par1ItemStack.func_77976_d() == 1) {
            int j = InventoryScanner.getFirstEmptyStack(inventory);
            if (j < 0 || !fillEmptySlots) {
                return i;
            }
            if (inventory.func_70301_a(j) == null) {
                inventory.func_70299_a(j, ItemStack.func_77944_b((ItemStack)par1ItemStack));
            }
            return 0;
        }
        int j = -1;
        for (int t = 0; t < inventory.func_70302_i_(); ++t) {
            ItemStack is = inventory.func_70301_a(t);
            if (is == null || is.func_77973_b() != par1ItemStack.func_77973_b() || !is.func_77985_e() || is.func_77981_g() && is.func_77960_j() != par1ItemStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)par1ItemStack)) continue;
            found = true;
            if (is.field_77994_a >= is.func_77976_d() || is.field_77994_a >= inventory.func_70297_j_()) continue;
            j = t;
            break;
        }
        if (j < 0 && (fillEmptySlots || found && autoCollectAll)) {
            j = InventoryScanner.getFirstEmptyStack(inventory);
        }
        if (j < 0) {
            return i;
        }
        if (inventory.func_70301_a(j) == null) {
            ItemStack stack = ItemStack.func_77944_b((ItemStack)par1ItemStack);
            stack.field_77994_a = 0;
            inventory.func_70299_a(j, stack);
        }
        ItemStack stack = inventory.func_70301_a(j);
        int k = i;
        int stackSize = stack.field_77994_a;
        if (k > stack.func_77976_d() - stackSize) {
            k = stack.func_77976_d() - stackSize;
        }
        if (k > inventory.func_70297_j_() - stackSize) {
            k = inventory.func_70297_j_() - stackSize;
        }
        if (k == 0) {
            return i;
        }
        stack.field_77994_a += k;
        return i -= k;
    }
}

