/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.PacketHandler;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RenameContainer
extends StackableContainer {
    private String uuid;
    private String oldName;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField textField;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/rename.png");

    public RenameContainer(String uuid) {
        super(176, 68);
        this.uuid = uuid;
        this.oldName = "";
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        ItemStack stack = UniqueItem.findItem(player, this.uuid);
        if (stack == null) {
            new Translatable("problem.rename404", new Object[0]).log(player);
            return false;
        }
        this.oldName = stack.func_82833_r();
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            ItemStack stack = UniqueItem.findItem(player, ((RenameContainer)container1).uuid);
            if (stack != null) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveAndClose() {
        final String newName = this.textField.getText();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        UniqueItem.modifyItems((EntityPlayer)player, this.uuid, null, new UniqueItem.ItemStackCallback(){

            @Override
            public void callback(ItemStack stack) {
                stack.func_151001_c(newName);
            }
        });
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission((EntityPlayer)player, this.uuid, 2)) {
            UniqueItemData.permissionError("rename", UniqueItemData.genericItem).log((EntityPlayer)player);
            return;
        }
        NBTTagCompound tag = data.getItemData((EntityPlayer)player, this.uuid);
        if (tag != null) {
            tag.func_74782_a("custom-name", (NBTBase)new NBTTagString(newName));
            data.markItemDirty(this.uuid);
        } else {
            UniqueItemData.permissionError("rename", UniqueItemData.genericItem).log((EntityPlayer)player);
        }
        Common.channel.sendToServer(new PacketHandler.RenameItem(this.uuid, this.textField.getText(), this.stackId));
        this.container.closeContainer((EntityPlayer)player, this.stackId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField = this.gui.addTextField(8, this, 11, 24, 150, 9);
        this.textField.setMaxStringLength(30);
        this.textField.setCanLoseFocus(false);
        this.textField.setFocused(true);
        this.textField.setText(this.oldName);
        this.gui.addButton(new StackableContainer.ContainerButton(0, 7, 41, 80, 20, new Translatable("button.save", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                RenameContainer.this.saveAndClose();
            }
        }));
        this.gui.addButton(new StackableContainer.ContainerButton(1, 90, 41, 80, 20, new Translatable("button.cancel", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                RenameContainer.this.gui.closeContainer(RenameContainer.this.stackId);
            }
        }));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (this.textField.keyPressed(key, keyCode)) {
            return true;
        }
        if (keyCode == 28) {
            this.saveAndClose();
            return true;
        }
        return false;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, new Translatable("gui.title.rename", new Object[0]).translate()).truncateString(160).drawCenteredString(88, 9, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        GL11.glDisable((int)2896);
        this.textField.drawBackground();
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 0;
    }
}

