/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.BackpackContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.ContainerStackGui;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.PlayerContainer;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StandaloneBackpackGui
extends GuiScreen {
    public int backpackY = 2;
    public int inventoryY = 1;
    public static long lastCloseTime = 0L;
    public GuiScreen parentScreen;
    public UniqueItemInventory inventory;
    public ArrayList<StandaloneSlot> slots;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    public int backpackShift;
    public int inventoryShift;
    public String name = "???";
    private int slotClicked = -1;
    public boolean triggerReopen = false;
    private int reopenSlot = -1;
    private boolean reopenInventory = true;

    public static void open(EntityPlayer player, ItemStack stack) {
        String name;
        String uuid;
        if (stack.func_77973_b() instanceof QuantumBackpack) {
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(stack));
            if (chest == null || !chest.canPlayerUse(player)) {
                return;
            }
            uuid = chest.getBackpackId(player);
        } else {
            uuid = UniqueItem.getIdentifier(stack);
        }
        if (uuid == null) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 1)) {
            UniqueItemData.permissionError("use", Backpack.name).log(player);
            return;
        }
        UniqueItemInventory inventory = UniqueItemInventory.getInventory(player, uuid);
        if (inventory == null) {
            return;
        }
        NBTTagCompound tag = data.getItemData(player, uuid);
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b("custom-name")) {
            name = tag.func_74779_i("custom-name");
        } else {
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            name = new ItemStack((Item)Common.backpack, 1, color).func_82833_r();
        }
        StandaloneBackpackGui gui = new StandaloneBackpackGui(player, name, inventory);
    }

    public void changeGuiScreen(EntityPlayer player, GuiScreen screen) {
        ItemStack stack = player.field_71071_by.func_70445_o();
        player.field_71071_by.func_70437_b(null);
        Minecraft.func_71410_x().func_147108_a(screen);
        player.field_71071_by.func_70437_b(stack);
        if (screen instanceof GuiContainer) {
            Common.channel.sendToServer(new PacketHandler.DropItemInBackpack("close", false, 0, false));
        }
    }

    public StandaloneBackpackGui(EntityPlayer player, String name, UniqueItemInventory inventory) {
        int x;
        this.inventory = inventory;
        this.name = name;
        Minecraft mc = Minecraft.func_71410_x();
        this.parentScreen = mc.field_71462_r;
        if (this.parentScreen instanceof StandaloneBackpackGui) {
            ((StandaloneBackpackGui)this.parentScreen).reopenSlot = -1;
        }
        this.xSize = 14 + inventory.width * 18;
        this.ySize = 24 + inventory.height * 18 + 22 + 103;
        this.backpackShift = 0;
        this.inventoryShift = 0;
        if (this.xSize < 176) {
            this.backpackShift = (176 - this.xSize) / 2;
            this.xSize = 176;
        } else if (this.xSize > 176) {
            this.inventoryShift = (this.xSize - 176) / 2;
        }
        this.changeGuiScreen(player, this);
        this.slots = new ArrayList();
        for (x = 0; x < inventory.width; ++x) {
            for (int y = 0; y < inventory.height; ++y) {
                this.slots.add(new StandaloneSlot(inventory, x + y * inventory.width, this.backpackShift + 8 + x * 18, this.backpackY + 18 + y * 18));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.slots.add(new StandaloneSlot((IInventory)player.field_71071_by, x2 + y * 9 + 9, this.inventoryShift + 8 + x2 * 18, this.ySize - 100 - this.inventoryY + 18 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.slots.add(new StandaloneSlot((IInventory)player.field_71071_by, x, this.inventoryShift + 8 + x * 18, this.ySize - 100 - this.inventoryY + 76));
        }
    }

    public void updateBackpack() {
        int x;
        Minecraft mc = Minecraft.func_71410_x();
        if (!this.inventory.refreshInventory()) {
            this.changeGuiScreen((EntityPlayer)mc.field_71439_g, this.parentScreen);
            return;
        }
        this.xSize = 14 + this.inventory.width * 18;
        this.ySize = 24 + this.inventory.height * 18 + 22 + 103;
        this.backpackShift = 0;
        this.inventoryShift = 0;
        if (this.xSize < 176) {
            this.backpackShift = (176 - this.xSize) / 2;
            this.xSize = 176;
        } else if (this.xSize > 176) {
            this.inventoryShift = (this.xSize - 176) / 2;
        }
        this.slots.clear();
        for (x = 0; x < this.inventory.width; ++x) {
            for (int y = 0; y < this.inventory.height; ++y) {
                this.slots.add(new StandaloneSlot(this.inventory, x + y * this.inventory.width, this.backpackShift + 8 + x * 18, this.backpackY + 18 + y * 18));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.slots.add(new StandaloneSlot((IInventory)mc.field_71439_g.field_71071_by, x2 + y * 9 + 9, this.inventoryShift + 8 + x2 * 18, this.ySize - 100 - this.inventoryY + 18 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.slots.add(new StandaloneSlot((IInventory)mc.field_71439_g.field_71071_by, x, this.inventoryShift + 8 + x * 18, this.ySize - 100 - this.inventoryY + 76));
        }
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int n = 1;
        GuiScreen g = this.field_146297_k.field_71462_r;
        while (g instanceof StandaloneBackpackGui) {
            ++n;
            g = ((StandaloneBackpackGui)g).parentScreen;
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new GuiButton(1, this.guiLeft + this.backpackShift + 5, this.guiTop + this.ySize - 122, this.xSize - this.backpackShift * 2 - 10, 20, new Translatable("button.backn", n).translate()){

            public void func_146118_a(int p_146118_1_, int p_146118_2_) {
                StandaloneBackpackGui.this.changeGuiScreen((EntityPlayer)StandaloneBackpackGui.this.field_146297_k.field_71439_g, StandaloneBackpackGui.this.parentScreen);
            }
        });
    }

    public void func_146281_b() {
        this.reopenSlot = -1;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char key, int keyCode) {
        if (keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            long time = Minecraft.func_71386_F();
            if (time - lastCloseTime < 200L) {
                return;
            }
            lastCloseTime = time;
            this.changeGuiScreen((EntityPlayer)this.field_146297_k.field_71439_g, this.parentScreen);
            return;
        }
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        this.reopenSlot = -1;
        x -= this.guiLeft;
        y -= this.guiTop;
        this.slotClicked = -1;
        for (StandaloneSlot slot : this.slots) {
            if (!slot.isMouseOver(x, y)) continue;
            this.slotClicked = slot.slot;
        }
        super.func_73864_a(x + this.guiLeft, y + this.guiTop, button);
    }

    protected void func_146286_b(int x, int y, int button) {
        x -= this.guiLeft;
        y -= this.guiTop;
        boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        for (StandaloneSlot slot : this.slots) {
            if (!slot.isMouseOver(x, y) || slot.slot != this.slotClicked) continue;
            ItemStack stack = slot.inventory.func_70301_a(slot.slot);
            if (button == 1 && stack != null && (stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack)) {
                if (stack.func_77973_b() instanceof Backpack && !UniqueItem.hasIdentifier(stack)) {
                    new Translatable("message.unidentified", new Object[0]).log((EntityPlayer)this.field_146297_k.field_71439_g);
                    return;
                }
                this.triggerReopen = false;
                Backpack.openingStandalone = true;
                ((UniqueItem.OpenableItem)stack.func_77973_b()).open((EntityPlayer)this.field_146297_k.field_71439_g, stack, this.field_146297_k.field_71439_g.field_70170_p);
                if (!this.triggerReopen) continue;
                this.reopenSlot = slot.slot;
                this.reopenInventory = this.inventory == slot.inventory;
                continue;
            }
            if (slot.inventory == this.inventory && button == 1 && stack != null && stack.func_77973_b() instanceof BackpackPouchUpgrade) {
                Common.channel.sendToServer(new PacketHandler.DropItemInBackpack("upgrade_" + this.inventory.getIdentifier(), shift, slot.slot, true));
                return;
            }
            if (slot.inventory == this.inventory && button == 1 && stack != null && stack.func_77973_b() instanceof ItemDye) {
                Common.channel.sendToServer(new PacketHandler.DropItemInBackpack("dye_" + this.inventory.getIdentifier(), shift, slot.slot, true));
                return;
            }
            if (slot.inventory == this.inventory && button == 1 && stack != null && stack.func_77973_b() instanceof ItemSign) {
                new Translatable("message.renamefromhotbar", new Object[0]).log(null);
                return;
            }
            if (slot.inventory != this.inventory) {
                this.simulateClick("inv_" + this.inventory.getIdentifier(), shift, slot.slot, button == 1);
                continue;
            }
            this.simulateClick(this.inventory.getIdentifier(), shift, slot.slot, button == 1);
        }
        if (x < 0 || y < 0 || x > this.xSize | y > this.ySize) {
            this.simulateClick(this.inventory.getIdentifier(), shift, 999, button == 1);
        }
        super.func_146286_b(x + this.guiLeft, y + this.guiTop, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SideOnly(value=Side.CLIENT)
    public void simulateClick(String uuid, boolean shift, int slot, boolean wasRightClick) {
        boolean canStack;
        UniqueItemInventory inventory;
        UniqueItemData data;
        Common.channel.sendToServer(new PacketHandler.DropItemInBackpack(uuid, shift, slot, wasRightClick));
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean clickedInventory = uuid.startsWith("inv_");
        if (clickedInventory) {
            uuid = uuid.substring(4);
        }
        if (!(data = UniqueItemData.get(player.field_70170_p)).strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), uuid, 2)) {
            return;
        }
        UniqueItemInventory inv = this.inventory;
        if (inv == null) {
            return;
        }
        if (slot == 999) {
            if (player.field_71071_by.func_70445_o() == null) {
                return;
            }
            if (!wasRightClick) {
                player.func_71019_a(player.field_71071_by.func_70445_o(), true);
                player.field_71071_by.func_70437_b((ItemStack)null);
                return;
            } else {
                player.func_71019_a(player.field_71071_by.func_70445_o().func_77979_a(1), true);
                if (player.field_71071_by.func_70445_o().field_77994_a != 0) return;
                player.field_71071_by.func_70437_b((ItemStack)null);
            }
            return;
        }
        UniqueItemInventory uniqueItemInventory = inventory = clickedInventory ? player.field_71071_by : inv;
        if (inventory.func_70302_i_() <= slot) {
            return;
        }
        ItemStack place = player.field_71071_by.func_70445_o();
        ItemStack take = inventory.func_70301_a(slot);
        if (inv.getIdentifier().equals(PacketHandler.getBackpackId((EntityPlayer)player, place)) || inv.getIdentifier().equals(PacketHandler.getBackpackId((EntityPlayer)player, take))) {
            return;
        }
        if (!clickedInventory && !InventoryScanner.backpackCanAccept(data.getItemData((EntityPlayer)player, uuid), place)) {
            return;
        }
        boolean bl = canStack = place != null && take != null && take.func_77973_b() == place.func_77973_b() && take.func_77985_e() && take.field_77994_a < take.func_77976_d() && take.field_77994_a < inventory.func_70297_j_() && (!take.func_77981_g() || take.func_77960_j() == place.func_77960_j()) && ItemStack.func_77970_a((ItemStack)take, (ItemStack)place);
        if (shift && take != null) {
            ItemStack t = place;
            if (clickedInventory) {
                int p;
                if (!InventoryScanner.backpackCanAccept(data.getItemData((EntityPlayer)player, uuid), take)) {
                    return;
                }
                do {
                    p = take.field_77994_a;
                    take.field_77994_a = InventoryScanner.storePartialItemStack(inv, take, true, true);
                } while (take.field_77994_a > 0 && take.field_77994_a < p);
                if (take.field_77994_a <= 0) {
                    take = null;
                }
                inv.saveInventory();
            } else {
                player.field_71071_by.func_70441_a(take);
            }
            place = take;
            take = t;
        } else if (wasRightClick) {
            if (place == null) {
                if (take != null) {
                    place = take.func_77979_a(take.field_77994_a / 2);
                }
            } else if (take == null) {
                take = place.func_77979_a(place.field_77994_a - 1);
            } else {
                if (!canStack) return;
                int change = 1;
                if ((change = Math.min(change, Math.min(inventory.func_70297_j_(), take.func_77976_d()) - take.field_77994_a)) < 0) {
                    change = 0;
                }
                int t = place.field_77994_a;
                place.field_77994_a = take.field_77994_a + change;
                take.field_77994_a = t - change;
            }
        } else if (canStack) {
            int change = place.field_77994_a;
            if ((change = Math.min(change, Math.min(inventory.func_70297_j_(), take.func_77976_d()) - take.field_77994_a)) < 0) {
                change = 0;
            }
            int t = place.field_77994_a;
            place.field_77994_a = take.field_77994_a + change;
            take.field_77994_a = t - change;
        }
        if (place != null && place.field_77994_a == 0) {
            place = null;
        }
        if (take != null && take.field_77994_a == 0) {
            take = null;
        }
        inventory.func_70299_a(slot, place);
        player.field_71071_by.func_70437_b(take);
        if (inventory != inv) return;
        inv.saveInventory();
    }

    public void drawTexture(int x, int y, int w, int h, int offsetX, int offsetY) {
        this.func_73729_b(x, y, offsetX, offsetY, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItemStack(ItemStack stack, int x, int y, float zLevel, String overrideCount) {
        float oldLevel = this.field_73735_i;
        this.field_73735_i = zLevel;
        this.field_146296_j.field_77023_b = zLevel;
        FontRenderer font = null;
        try {
            if (stack != null) {
                if (stack.func_77973_b() == null) {
                    stack = new ItemStack((Item)Common.unknownItem);
                }
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.field_146289_q;
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            this.field_146296_j.func_180450_b(stack, x, y);
            this.field_146296_j.func_180453_a(font, stack, x, y, overrideCount);
        }
        catch (Throwable e) {
            GL11.glPopMatrix();
        }
        finally {
            GL11.glPopMatrix();
        }
        this.field_73735_i = oldLevel;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public void func_73863_a(int mx, int my, float t) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(BackpackContainer.texture);
        int xCovered = this.backpackShift + this.guiLeft;
        for (int x = 0; x < this.inventory.width; ++x) {
            int offsetX = x == 0 ? 0 : (x == this.inventory.width - 1 ? 43 : 25);
            int w = x == 0 || x == this.inventory.width - 1 ? 25 : 18;
            int yCovered = this.guiTop + this.backpackY;
            for (int y = 0; y < this.inventory.height; ++y) {
                int offsetY;
                int n = y == 0 ? 0 : (offsetY = y == this.inventory.height - 1 ? 53 : 35);
                int h = y == 0 ? 35 : (y == this.inventory.height - 1 ? 25 : 18);
                this.drawTexture(xCovered, yCovered, w, h, offsetX, offsetY);
                yCovered += h;
            }
            xCovered += w;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(PlayerContainer.texture);
        this.drawTexture(this.guiLeft + this.inventoryShift, this.guiTop + this.ySize - 100 - this.inventoryY, 176, 100, 0, 0);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.func_73863_a(mx, my, t);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        StandaloneSlot hoverSlot = null;
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.slots.size(); ++i) {
            StandaloneSlot slot = this.slots.get(i);
            ItemStack stack = slot.inventory.func_70301_a(slot.slot);
            boolean flag = false;
            ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            if (flag) {
                StandaloneBackpackGui.func_73734_a((int)slot.x, (int)slot.y, (int)(slot.x + 16), (int)(slot.y + 16), (int)-2130706433);
            }
            GL11.glEnable((int)2929);
            this.field_146296_j.func_180450_b(stack, slot.x, slot.y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, slot.x, slot.y, null);
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
            if (!slot.isMouseOver(mx - this.guiLeft, my - this.guiTop)) continue;
            hoverSlot = slot;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(slot.x, slot.y, slot.x + 16, slot.y + 16, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        GL11.glDisable((int)2896);
        String text = this.name;
        int length = this.field_146289_q.func_78256_a(text);
        if (length > this.xSize - this.backpackShift * 2 - 16) {
            text = this.field_146289_q.func_78269_a(text, this.xSize - this.backpackShift * 2 - 16 - this.field_146289_q.func_78256_a(ContainerStackGui.ellipsis)) + ContainerStackGui.ellipsis;
        }
        this.field_146289_q.func_78276_b(text, this.backpackShift + 8, this.backpackY + 6, -12566464);
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        text = player.field_71071_by.func_145818_k_() ? player.field_71071_by.func_70005_c_() : I18n.func_135052_a((String)player.field_71071_by.func_70005_c_(), (Object[])new Object[0]);
        length = this.field_146289_q.func_78256_a(text);
        if (length > this.xSize - this.inventoryShift * 2 - 16) {
            text = this.field_146289_q.func_78269_a(text, this.xSize - this.inventoryShift * 2 - 16 - this.field_146289_q.func_78256_a(ContainerStackGui.ellipsis)) + ContainerStackGui.ellipsis;
        }
        this.field_146289_q.func_78276_b(text, this.inventoryShift + 8, this.ySize - 100 - this.inventoryY + 6, -12566464);
        GL11.glEnable((int)2896);
        InventoryPlayer inventoryplayer = player.field_71071_by;
        ItemStack itemstack = inventoryplayer.func_70445_o();
        if (itemstack != null) {
            this.drawItemStack(itemstack, mx - this.guiLeft - 8, my - this.guiTop - 8, 200.0f, null);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        if (inventoryplayer.func_70445_o() == null && hoverSlot != null && hoverSlot.inventory.func_70301_a(hoverSlot.slot) != null) {
            this.func_146285_a(hoverSlot.inventory.func_70301_a(hoverSlot.slot), mx, my);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        if (this.reopenSlot >= 0) {
            ItemStack stack = (this.reopenInventory ? this.inventory : player.field_71071_by).func_70301_a(this.reopenSlot);
            if (UniqueItemData.get((World)this.field_146297_k.field_71441_e).isSubscribed(UniqueItem.getIdentifier(stack))) {
                this.reopenSlot = -1;
                ((UniqueItem.OpenableItem)stack.func_77973_b()).open((EntityPlayer)this.field_146297_k.field_71439_g, stack, this.field_146297_k.field_71439_g.field_70170_p);
            }
        }
    }

    public boolean func_73868_f() {
        try {
            return this.parentScreen.func_73868_f();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public class StandaloneSlot {
        public int slot;
        public int x;
        public int y;
        public IInventory inventory;

        public StandaloneSlot(IInventory inventory, int slot, int x, int y) {
            this.inventory = inventory;
            this.slot = slot;
            this.x = x;
            this.y = y;
        }

        public boolean isMouseOver(int mx, int my) {
            return mx >= this.x && mx < this.x + 18 && my >= this.y && my < this.y + 18;
        }
    }
}

