/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Common;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.gui.EmptyContainer;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSectionCallback;
import invtweaks.api.container.InventoryContainer;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@InventoryContainer(showOptions=false)
public class ContainerStack
extends Container {
    public ContainerStackListener listener = null;
    public ArrayList<StackableContainer>[] stacks;
    public HashMap<ContainerSection, ArrayList<Slot>> sections;
    public ArrayList<Integer> chainOrder;
    public ContainerLayout layout;
    public boolean reupdateContainers;
    public boolean hasClosed = false;
    public boolean theClientMayBeOutofSync;
    private static boolean wasRenderingCrosshairs;
    public boolean fromChest = false;

    public ContainerStack(EntityPlayer player, StackableContainer[] initialContainers) {
        this(player, initialContainers, null, false);
    }

    public ContainerStack(EntityPlayer player, StackableContainer[] initialContainers, boolean fromChest) {
        this(player, initialContainers, null, fromChest);
    }

    public ContainerStack(EntityPlayer player, StackableContainer[] initialContainers, ContainerLayout layout, boolean fromChest) {
        this.fromChest = fromChest;
        this.stacks = new ArrayList[initialContainers.length];
        this.sections = new HashMap();
        this.chainOrder = new ArrayList();
        if (layout == null) {
            layout = new ContainerLayout();
        }
        this.layout = layout;
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = new ArrayList();
            this.stacks[i].add(initialContainers[i]);
            initialContainers[i].stackId = i;
        }
        if (player.field_70170_p.field_72995_K && GuiIngameForge.renderCrosshairs) {
            wasRenderingCrosshairs = true;
            GuiIngameForge.renderCrosshairs = false;
        }
        this.updateContainers(player);
    }

    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        int min = 0;
        for (int i = 0; i < this.stacks.length; ++i) {
            StackableContainer c = this.stacks[i].get(this.stacks[i].size() - 1);
            if (c == null) continue;
            int m = c.getRowSize();
            if (min != 0 && (m == 0 || m >= min)) continue;
            min = m;
        }
        return min;
    }

    public StackableContainer getContainer(int stackId) {
        int i = this.stacks[stackId].size() - 1;
        if (i < 0) {
            return new EmptyContainer();
        }
        StackableContainer c = this.stacks[stackId].get(i);
        c.container = this;
        c.stackId = stackId;
        return c;
    }

    public void updateContainers(EntityPlayer player) {
        int i;
        if (!this.hasContainers(player)) {
            return;
        }
        this.sections.clear();
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        this.layout.arrangeContainers();
        this.reupdateContainers = false;
        for (i = 0; i < this.stacks.length; ++i) {
            if (!this.getContainer(i).setAndInitContainer(player, this)) {
                this.closeContainer(player, i);
                return;
            }
            if (!this.reupdateContainers) continue;
            this.updateContainers(player);
            return;
        }
        if (this.listener != null) {
            for (i = 0; i < this.field_75151_b.size(); ++i) {
                ((StackableContainer.ContainerSlot)((Object)this.field_75151_b.get((int)i))).field_75223_e -= this.listener.getScrollX();
                ((StackableContainer.ContainerSlot)((Object)this.field_75151_b.get((int)i))).field_75221_f -= this.listener.getScrollY();
            }
            this.listener.updateContainers();
        }
    }

    public int getOffsetX(StackableContainer container) {
        return this.layout.containerOffsetX[container.stackId];
    }

    public int getOffsetY(StackableContainer container) {
        return this.layout.containerOffsetY[container.stackId];
    }

    @ContainerSectionCallback
    HashMap<invtweaks.api.container.ContainerSection, List<Slot>> getSections() {
        HashMap<invtweaks.api.container.ContainerSection, List<Slot>> map = new HashMap<invtweaks.api.container.ContainerSection, List<Slot>>();
        if (this.sections.containsKey((Object)ContainerSection.INVENTORY)) {
            map.put(invtweaks.api.container.ContainerSection.INVENTORY, this.sections.get((Object)ContainerSection.INVENTORY));
        }
        if (this.sections.containsKey((Object)ContainerSection.INVENTORY_HOTBAR)) {
            map.put(invtweaks.api.container.ContainerSection.INVENTORY_HOTBAR, this.sections.get((Object)ContainerSection.INVENTORY_HOTBAR));
        }
        if (this.sections.containsKey((Object)ContainerSection.INVENTORY_NOT_HOTBAR)) {
            map.put(invtweaks.api.container.ContainerSection.INVENTORY_NOT_HOTBAR, this.sections.get((Object)ContainerSection.INVENTORY_NOT_HOTBAR));
        }
        if (this.sections.containsKey((Object)ContainerSection.CHEST)) {
            map.put(invtweaks.api.container.ContainerSection.CHEST, this.sections.get((Object)ContainerSection.CHEST));
        }
        if (this.sections.containsKey((Object)ContainerSection.CRAFTING_IN)) {
            map.put(invtweaks.api.container.ContainerSection.CRAFTING_IN, this.sections.get((Object)ContainerSection.CRAFTING_IN));
        }
        if (this.sections.containsKey((Object)ContainerSection.CRAFTING_IN_PERSISTENT)) {
            map.put(invtweaks.api.container.ContainerSection.CRAFTING_IN_PERSISTENT, this.sections.get((Object)ContainerSection.CRAFTING_IN_PERSISTENT));
        }
        if (this.sections.containsKey((Object)ContainerSection.CRAFTING_OUT)) {
            map.put(invtweaks.api.container.ContainerSection.CRAFTING_OUT, this.sections.get((Object)ContainerSection.CRAFTING_OUT));
        }
        if (this.sections.containsKey((Object)ContainerSection.ARMOR)) {
            map.put(invtweaks.api.container.ContainerSection.ARMOR, this.sections.get((Object)ContainerSection.ARMOR));
        }
        if (this.sections.containsKey((Object)ContainerSection.FURNACE_IN)) {
            map.put(invtweaks.api.container.ContainerSection.FURNACE_IN, this.sections.get((Object)ContainerSection.FURNACE_IN));
        }
        if (this.sections.containsKey((Object)ContainerSection.FURNACE_OUT)) {
            map.put(invtweaks.api.container.ContainerSection.FURNACE_OUT, this.sections.get((Object)ContainerSection.FURNACE_OUT));
        }
        if (this.sections.containsKey((Object)ContainerSection.FURNACE_FUEL)) {
            map.put(invtweaks.api.container.ContainerSection.FURNACE_FUEL, this.sections.get((Object)ContainerSection.FURNACE_FUEL));
        }
        if (this.sections.containsKey((Object)ContainerSection.ENCHANTMENT)) {
            map.put(invtweaks.api.container.ContainerSection.ENCHANTMENT, this.sections.get((Object)ContainerSection.ENCHANTMENT));
        }
        if (this.sections.containsKey((Object)ContainerSection.BREWING_BOTTLES)) {
            map.put(invtweaks.api.container.ContainerSection.BREWING_BOTTLES, this.sections.get((Object)ContainerSection.BREWING_BOTTLES));
        }
        if (this.sections.containsKey((Object)ContainerSection.BREWING_INGREDIENT)) {
            map.put(invtweaks.api.container.ContainerSection.BREWING_INGREDIENT, this.sections.get((Object)ContainerSection.BREWING_INGREDIENT));
        }
        return map;
    }

    public Slot addSlotToContainer(StackableContainer container, ContainerSection section, StackableContainer.ContainerSlot slot) {
        if (!this.sections.containsKey((Object)section)) {
            this.sections.put(section, new ArrayList());
        }
        this.sections.get((Object)section).add(slot);
        slot.field_75223_e += this.getOffsetX(container);
        slot.field_75221_f += this.getOffsetY(container);
        return super.func_75146_a((Slot)slot);
    }

    public boolean mergeItemStack(StackableContainer container, ItemStack itemStack, int startPos, int endPos, boolean inReverse) {
        int originalStackId = container.stackId;
        for (int i = 0; i < originalStackId; ++i) {
            int slotCount = this.getContainer(i).getSlotCount();
            startPos += slotCount;
            endPos += slotCount;
        }
        container.stackId = originalStackId;
        return super.func_75135_a(itemStack, startPos, endPos, inReverse);
    }

    public Slot getLocalSlot(StackableContainer container, int slot) {
        int originalStackId = container.stackId;
        int offset = 0;
        for (int i = 0; i < originalStackId; ++i) {
            if (i == originalStackId) {
                container.stackId = originalStackId;
                return (Slot)this.field_75151_b.get(offset + slot);
            }
            int slotCount = this.getContainer(i).getSlotCount();
            offset += slotCount;
        }
        container.stackId = originalStackId;
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void triggerSlotClick(StackableContainer container, int slot, int button, ClickType type, EntityPlayer player) {
        int originalStackId = container.stackId;
        for (int i = 0; i < originalStackId; ++i) {
            slot += this.getContainer(i).getSlotCount();
        }
        container.stackId = originalStackId;
        Minecraft.func_71410_x().field_71442_b.func_187098_a(this.field_75152_c, slot, button, type, player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (player.field_70170_p.field_72995_K && wasRenderingCrosshairs) {
            GuiIngameForge.renderCrosshairs = true;
            wasRenderingCrosshairs = false;
        }
        if (this.stacks[0].size() < 1) {
            return;
        }
        this.saveInventories(player);
        for (int i = 0; i < this.stacks.length; ++i) {
            this.getContainer(i).onClosed(player);
            int j = this.stacks[i].size() - 1;
            while (j >= 0) {
                StackableContainer c = this.stacks[i].get(j);
                c.stackId = j--;
                c.onUnload(player);
            }
            this.stacks[i].clear();
        }
        this.chainOrder.clear();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.hasContainers(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        if (!this.hasContainers(player) || !(this.field_75151_b.get(slot) instanceof StackableContainer.ContainerSlot)) {
            return null;
        }
        StackableContainer.ContainerSlot containerSlot = (StackableContainer.ContainerSlot)((Object)this.field_75151_b.get(slot));
        int nextStack = containerSlot.stackId + 1;
        if (nextStack >= this.stacks.length) {
            nextStack = 0;
        }
        return this.getContainer(nextStack).transferStackInSlot(player, containerSlot);
    }

    public boolean overrideRightClick(int inventorySlot, int mouseClick, boolean holdingShift, EntityPlayer player) {
        if (mouseClick != 1 || inventorySlot < 0 || inventorySlot >= this.field_75151_b.size() || !(this.field_75151_b.get(inventorySlot) instanceof StackableContainer.ContainerSlot)) {
            return false;
        }
        StackableContainer.ContainerSlot slot = (StackableContainer.ContainerSlot)((Object)this.field_75151_b.get(inventorySlot));
        if (slot.func_75211_c() == null && !this.getContainer(slot.stackId).customRightClickOnEmpty() || !slot.canTakeStack(player, true)) {
            return false;
        }
        return this.getContainer(slot.stackId).customRightClick(player, inventorySlot, holdingShift);
    }

    public boolean overrideRightClickServer(int inventorySlot, int mouseClick, boolean holdingShift, EntityPlayer player) {
        if (mouseClick != 1 || inventorySlot < 0 || inventorySlot >= this.field_75151_b.size() || !(this.field_75151_b.get(inventorySlot) instanceof StackableContainer.ContainerSlot)) {
            return false;
        }
        StackableContainer.ContainerSlot slot = (StackableContainer.ContainerSlot)((Object)this.field_75151_b.get(inventorySlot));
        if (slot.func_75211_c() == null || !slot.canTakeStack(player, true)) {
            return false;
        }
        return this.getContainer(slot.stackId).tryRightClickServer(player, inventorySlot, holdingShift);
    }

    public boolean tryRightClick(int inventorySlot, int mouseClick, boolean holdingShift, EntityPlayer player, short transactionId) {
        if (this.overrideRightClickServer(inventorySlot, mouseClick, holdingShift, player)) {
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            CPacketClickWindow packet = new CPacketClickWindow();
            try {
                PacketBuffer b = new PacketBuffer(Unpooled.buffer());
                b.writeByte(this.field_75152_c);
                b.writeShort(inventorySlot);
                b.writeByte(mouseClick);
                b.writeShort((int)transactionId);
                b.writeByte(holdingShift ? 1 : 0);
                b.func_150788_a(new ItemStack(Blocks.field_150346_d, 72).func_77946_l());
                packet.func_148837_a(b);
            }
            catch (IOException e) {
                return false;
            }
            ((EntityPlayerMP)player).field_71135_a.func_147351_a(packet);
            Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(player.field_71071_by.func_70445_o()));
        }
        return false;
    }

    public ItemStack func_184996_a(int slot, int par2, ClickType type, EntityPlayer player) {
        if (!this.hasContainers(player)) {
            return null;
        }
        ItemStack res = super.func_184996_a(slot, par2, type, player);
        if (player instanceof EntityPlayerMP && this.theClientMayBeOutofSync) {
            this.theClientMayBeOutofSync = false;
            ((EntityPlayerMP)player).func_71120_a((Container)this);
        }
        return res;
    }

    public static void closeScreen(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            ((EntityPlayerSP)player).func_71053_j();
        } else {
            ((EntityPlayerMP)player).func_71053_j();
        }
    }

    public boolean hasContainers(EntityPlayer player) {
        if (this.stacks[0].size() < 1) {
            ContainerStack.closeScreen(player);
            this.hasClosed = true;
            return false;
        }
        return true;
    }

    public boolean refreshInventories(EntityPlayer player) {
        ArrayList<Integer> stacksLeft = new ArrayList<Integer>();
        for (int i = 0; i < this.stacks.length; ++i) {
            stacksLeft.add(i);
        }
        while (stacksLeft.size() > 0) {
            ArrayList<StackableContainer> instances = this.filterNextClass(stacksLeft);
            if (instances.get(0).static_refreshInventories(player, instances)) continue;
            new Translatable("problem.guiinvalidstate", new Object[0]).log(player);
            ContainerStack.closeScreen(player);
            this.hasClosed = true;
            return false;
        }
        return true;
    }

    public void saveInventories(EntityPlayer player) {
        ArrayList<Integer> stacksLeft = new ArrayList<Integer>();
        for (int i = 0; i < this.stacks.length; ++i) {
            stacksLeft.add(i);
        }
        while (stacksLeft.size() > 0) {
            ArrayList<StackableContainer> instances = this.filterNextClass(stacksLeft);
            instances.get(0).static_saveInventories(player, instances);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemStackTooltips(List list, ItemStack itemStack) {
        ArrayList<Integer> stacksLeft = new ArrayList<Integer>();
        for (int i = 0; i < this.stacks.length; ++i) {
            stacksLeft.add(i);
        }
        while (stacksLeft.size() > 0) {
            ArrayList<StackableContainer> instances = this.filterNextClass(stacksLeft);
            instances.get(0).static_addItemStackTooltip(list, itemStack);
        }
    }

    public void addContainer(EntityPlayer player, Integer stackId, StackableContainer container) {
        if (container == null) {
            return;
        }
        if (stackId == null) {
            this.addContainers(player, new StackableContainer[]{container});
            return;
        }
        this.chainOrder.add(stackId);
        container.stackId = stackId;
        this.saveInventories(player);
        this.getContainer(stackId).onClosed(player);
        this.stacks[stackId].add(container);
        this.updateContainers(player);
    }

    public void replaceContainer(EntityPlayer player, int stackId, StackableContainer container) {
        if (container == null || !this.hasContainers(player)) {
            return;
        }
        this.saveInventories(player);
        this.getContainer(stackId).onClosed(player);
        this.getContainer(stackId).onUnload(player);
        this.stacks[stackId].remove(this.stacks[stackId].size() - 1);
        this.stacks[stackId].add(container);
        container.stackId = stackId;
        this.updateContainers(player);
    }

    public void addContainers(EntityPlayer player, StackableContainer[] containers) {
        int i;
        this.saveInventories(player);
        for (i = 0; i < this.stacks.length; ++i) {
            this.getContainer(i).onClosed(player);
        }
        this.chainOrder.add(null);
        for (i = 0; i < this.stacks.length; ++i) {
            if (i < containers.length) {
                this.stacks[i].add(containers[i]);
                containers[i].stackId = i;
                continue;
            }
            this.stacks[i].add(new EmptyContainer());
        }
        this.updateContainers(player);
    }

    public void closeContainer(EntityPlayer player) {
        if (!this.hasContainers(player)) {
            return;
        }
        this.saveInventories(player);
        if (this.chainOrder.size() == 0) {
            for (int i = 0; i < this.stacks.length; ++i) {
                this.getContainer(i).onClosed(player);
                this.getContainer(i).onUnload(player);
                this.stacks[i].remove(this.stacks[i].size() - 1);
            }
        } else {
            Integer i = this.chainOrder.get(this.chainOrder.size() - 1);
            this.chainOrder.remove(this.chainOrder.size() - 1);
            if (i == null) {
                i = 0;
                while (i < this.stacks.length) {
                    this.getContainer(i).onClosed(player);
                    this.getContainer(i).onUnload(player);
                    this.stacks[i].remove(this.stacks[i].size() - 1);
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            } else {
                this.getContainer(i).onClosed(player);
                this.getContainer(i).onUnload(player);
                this.stacks[i].remove(this.stacks[i].size() - 1);
            }
        }
        this.updateContainers(player);
    }

    public void closeContainer(EntityPlayer player, int stackId) {
        if (stackId < 0) {
            this.closeContainer(player);
            return;
        }
        if (!this.hasContainers(player)) {
            return;
        }
        int i = this.chainOrder.lastIndexOf(stackId);
        for (int j = i + 1; j < this.chainOrder.size(); ++j) {
            if (this.chainOrder.get(j) != null) continue;
            this.closeContainer(player);
            return;
        }
        if (i == -1) {
            ContainerStack.closeScreen(player);
            this.hasClosed = true;
        } else {
            this.saveInventories(player);
            this.getContainer(stackId).onClosed(player);
            this.getContainer(stackId).onUnload(player);
            this.chainOrder.remove(i);
            this.stacks[stackId].remove(this.stacks[stackId].size() - 1);
            this.updateContainers(player);
        }
    }

    private ArrayList<StackableContainer> filterNextClass(ArrayList<Integer> stacksLeft) {
        int id = stacksLeft.get(0);
        Class<?> nextClass = this.getContainer(id).getClass();
        ArrayList<StackableContainer> instances = new ArrayList<StackableContainer>();
        int i = 0;
        while (i < stacksLeft.size()) {
            id = stacksLeft.get(i);
            if (this.getContainer(id).getClass().equals(nextClass)) {
                instances.add(this.getContainer(id));
                stacksLeft.remove(i);
                continue;
            }
            ++i;
        }
        return instances;
    }

    public boolean func_94530_a(ItemStack par1ItemStack, Slot par2Slot) {
        try {
            if (par2Slot instanceof CraftingContainer.CraftingContainerSlot) {
                return par2Slot.field_75224_c != ((CraftingContainer.CraftingContainerSlot)par2Slot).getContainer().craftResult && super.func_94530_a(par1ItemStack, par2Slot);
            }
            return super.func_94530_a(par1ItemStack, par2Slot);
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        if (par1IInventory instanceof CraftingContainer.CraftingContainerInventory) {
            ((CraftingContainer.CraftingContainerInventory)par1IInventory).getContainer().callbackContainer.func_75130_a(par1IInventory);
        }
    }

    public void detectAndIgnoreChanges() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack == null ? null : itemstack.func_77946_l();
            this.field_75153_a.set(i, itemstack1);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (this.field_75152_c != 0) {
            listener.func_71110_a((Container)this, this.func_75138_a());
        }
        this.func_75142_b();
    }

    public Slot func_75139_a(int par1) {
        if (par1 >= this.field_75151_b.size()) {
            return new Slot((IInventory)new InvalidInventory(), 0, -1000, -1000);
        }
        return (Slot)this.field_75151_b.get(par1);
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        if (par1 >= this.field_75151_b.size()) {
            return;
        }
        super.func_75141_a(par1, par2ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int i = 0; i < par1ArrayOfItemStack.length; ++i) {
            if (i >= this.field_75151_b.size()) {
                return;
            }
            this.func_75139_a(i).func_75215_d(par1ArrayOfItemStack[i]);
        }
    }

    public static class InvalidInventory
    implements IInventory {
        public void func_70299_a(int i, ItemStack itemstack) {
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_(), new Object[0]) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public ItemStack func_70301_a(int i) {
            return null;
        }

        public int func_70302_i_() {
            return 1;
        }

        public int func_70297_j_() {
            return 64;
        }

        public String func_70005_c_() {
            return "invalidslot";
        }

        public ItemStack func_70298_a(int i, int j) {
            return null;
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public int func_174887_a_(int p_getField_1_) {
            return 0;
        }

        public void func_174885_b(int p_setField_1_, int p_setField_2_) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }
    }

    public static enum ContainerSection {
        INVENTORY,
        INVENTORY_HOTBAR,
        INVENTORY_NOT_HOTBAR,
        CHEST,
        CRAFTING_IN,
        CRAFTING_IN_PERSISTENT,
        CRAFTING_OUT,
        ARMOR,
        FURNACE_IN,
        FURNACE_OUT,
        FURNACE_FUEL,
        ENCHANTMENT,
        BREWING_BOTTLES,
        BREWING_INGREDIENT;

    }

    public static interface ContainerStackListener {
        public void updateContainers();

        public int getScrollX();

        public int getScrollY();
    }

    public class ContainerLayout {
        public int[] containerOffsetX;
        public int[] containerOffsetY;
        public int spacer = 3;

        public ContainerLayout() {
            this.containerOffsetX = new int[ContainerStack.this.stacks.length];
            this.containerOffsetY = new int[ContainerStack.this.stacks.length];
        }

        public void arrangeContainers() {
            int i;
            int largestWidth = ContainerStack.this.getContainer((int)0).guiWidth;
            int offsetY = 0;
            for (i = 0; i < ContainerStack.this.stacks.length; ++i) {
                StackableContainer c = ContainerStack.this.getContainer(i);
                if (c.guiWidth > largestWidth) {
                    largestWidth = c.guiWidth;
                }
                this.containerOffsetY[i] = offsetY;
                offsetY += c.guiHeight + this.spacer;
            }
            for (i = 0; i < ContainerStack.this.stacks.length; ++i) {
                this.containerOffsetX[i] = (largestWidth - ContainerStack.this.getContainer((int)i).guiWidth) / 2;
            }
        }

        public int getTotalWidth() {
            int xSize = 0;
            for (int i = 0; i < ContainerStack.this.stacks.length; ++i) {
                StackableContainer container = ContainerStack.this.getContainer(i);
                if (container.guiWidth <= xSize) continue;
                xSize = container.guiWidth;
            }
            return xSize;
        }

        public int getTotalHeight() {
            int ySize = 0;
            for (int i = 0; i < ContainerStack.this.stacks.length; ++i) {
                ySize += ContainerStack.this.getContainer((int)i).guiHeight + this.spacer;
            }
            return ySize - this.spacer;
        }

        public boolean isTop(int stackId) {
            return stackId <= (ContainerStack.this.stacks.length - 1) / 2;
        }
    }

    public static interface LoadableContainer {
        public String getName();
    }

    public static interface Callback {
        public void call();
    }
}

