/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.BlockPos;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class CustomPacket {
    public ByteBuf buffer = null;

    public CustomPacket(ByteBuf buf) {
        this.buffer = buf;
    }

    public CustomPacket write(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    public CustomPacket write(String value) {
        if (value == null) {
            this.buffer.writeInt(-1);
        } else {
            try {
                byte[] bytes = value.getBytes("UTF-8");
                this.buffer.writeInt(bytes.length);
                this.buffer.writeBytes(bytes);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this;
    }

    public CustomPacket write(BlockPos value) {
        this.write(value.x);
        this.write(value.y);
        this.write(value.z);
        return this;
    }

    public CustomPacket write(Serializable value) {
        if (value == null) {
            this.write(false);
        } else {
            this.write(true);
            value.write(this);
        }
        return this;
    }

    public CustomPacket write(ItemStack value) {
        NBTTagCompound tag = new NBTTagCompound();
        value.func_77955_b(tag);
        this.write(tag);
        return this;
    }

    public CustomPacket write(boolean value) {
        this.buffer.writeBoolean(value);
        return this;
    }

    public CustomPacket write(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    public CustomPacket write(NBTTagCompound value) {
        if (value == null) {
            this.buffer.writeShort(0);
        } else {
            this.buffer.writeByte(1);
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)value, (DataOutput)new ByteBufOutputStream(this.buffer));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this;
    }

    public void writeObject(Object o) {
        if (o instanceof String) {
            this.write((String)o);
        } else if (o instanceof Integer) {
            this.write((Integer)o);
        } else if (o instanceof Double) {
            this.write((Double)o);
        } else if (o instanceof Boolean) {
            this.write((Boolean)o);
        } else if (o instanceof ItemStack) {
            this.write((ItemStack)o);
        } else if (o instanceof BlockPos) {
            this.write((BlockPos)o);
        } else if (o instanceof NBTTagCompound) {
            this.write((NBTTagCompound)o);
        } else if (o instanceof Serializable) {
            this.write((Serializable)o);
        } else if (o instanceof Collection) {
            this.write(((Collection)o).size());
            for (Object i : (Collection)o) {
                this.writeObject(i);
            }
        }
    }

    public void writeAll(Object[] args) {
        for (Object o : args) {
            this.writeObject(o);
        }
    }

    public void writeObject(Object o, Class clazz) {
        if (o instanceof Collection) {
            this.write(((Collection)o).size());
            for (Object i : (Collection)o) {
                this.writeObject(i, clazz);
            }
        } else if (clazz.equals(Object.class)) {
            this.writeObject(o);
        } else if (String.class.isAssignableFrom(clazz)) {
            this.write((String)o);
        } else if (Integer.class.isAssignableFrom(clazz)) {
            this.write((Integer)o);
        } else if (Double.class.isAssignableFrom(clazz)) {
            this.write((Double)o);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            this.write((Boolean)o);
        } else if (ItemStack.class.isAssignableFrom(clazz)) {
            this.write((ItemStack)o);
        } else if (BlockPos.class.isAssignableFrom(clazz)) {
            this.write((BlockPos)o);
        } else if (NBTTagCompound.class.isAssignableFrom(clazz)) {
            this.write((NBTTagCompound)o);
        } else if (Serializable.class.isAssignableFrom(clazz)) {
            this.write((Serializable)o);
        }
    }

    public void writeAll(Object[] args, Class[] classes) {
        int i = 0;
        int j = 0;
        while (i < args.length) {
            Object o = args[i];
            this.writeObject(o, classes[j]);
            ++i;
            ++j;
        }
    }

    public static class CustomPacketReader {
        public ByteBuf buffer = null;

        public CustomPacketReader(ByteBuf buf) {
            this.buffer = buf;
        }

        public int readInt() {
            return this.buffer.readInt();
        }

        public String readString() {
            int length = this.buffer.readInt();
            if (length == -1) {
                return null;
            }
            byte[] bytes = new byte[length];
            this.buffer.readBytes(bytes);
            try {
                return new String(bytes, "UTF-8");
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public boolean readBoolean() {
            return this.buffer.readBoolean();
        }

        public double readDouble() {
            return this.buffer.readDouble();
        }

        public BlockPos readBlockPos() {
            return new BlockPos(this.readInt(), this.readInt(), this.readInt());
        }

        public ItemStack readItemStack() {
            NBTTagCompound tag = this.readNBTTagCompound();
            return ItemStack.func_77949_a((NBTTagCompound)tag);
        }

        public NBTTagCompound readNBTTagCompound() {
            byte short1 = this.buffer.readByte();
            if (short1 == 0) {
                return null;
            }
            try {
                return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(this.buffer), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public <P extends Serializable> P readSerializable(Class<P> clazz) {
            if (!this.readBoolean()) {
                return null;
            }
            try {
                return (P)((Serializable)clazz.getConstructor(CustomPacketReader.class).newInstance(this));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Object readObject(Class clazz) {
            if (String.class.isAssignableFrom(clazz)) {
                return this.readString();
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return this.readInt();
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return this.readDouble();
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return this.readBoolean();
            }
            if (ItemStack.class.isAssignableFrom(clazz)) {
                return this.readItemStack();
            }
            if (BlockPos.class.isAssignableFrom(clazz)) {
                return this.readBlockPos();
            }
            if (NBTTagCompound.class.isAssignableFrom(clazz)) {
                return this.readNBTTagCompound();
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return this.readSerializable(clazz);
            }
            throw new RuntimeException("Attempted to read an unknown class type " + clazz.toString());
        }

        public void readAll(Object[] args, Class[] classes) {
            int i = 0;
            int j = 0;
            while (i < args.length) {
                Object o = args[i];
                if (Collection.class.isAssignableFrom(classes[j])) {
                    ++j;
                    args[i] = new ArrayList();
                    int length = this.readInt();
                    for (int k = 0; k < length; ++k) {
                        ((ArrayList)args[i]).add(this.readObject(classes[j]));
                    }
                } else {
                    args[i] = this.readObject(classes[j]);
                }
                ++i;
                ++j;
            }
        }
    }

    public static interface Serializable {
        public void write(CustomPacket var1);
    }
}

