/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Logger;
import brad16840.common.UniqueItem;
import brad16840.common.UnknownItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class DynamicRecipes {
    public static HashMap<String, Recipe> recipes = new HashMap();
    public static HashSet<String> recipesServerSide = new HashSet();
    public static HashMap<String, IRecipe> disabledRecipes = new HashMap();
    public static HashSet<String> disabledRecipesServerSide = new HashSet();
    public static HashSet<String> overriddenRecipes = new HashSet();
    public static HashSet<String> existingDisabledRecipes = new HashSet();
    public static HashMap<String, Recipe> existingRecipes = new HashMap();
    public static HashMap<IRecipe, String> representationCache = new HashMap();
    public static int lastMetadata = 0;
    public static boolean settingOverriddenValues = false;
    public static boolean _disableRecipeSort = false;
    public static boolean disableRecipeSort;
    public static ArrayList<Object> overrideUndoList;

    public static String representItem(ItemStack stack, boolean ignoreCount) {
        if (stack == null || stack.func_77973_b() == null) {
            return "invaliditem";
        }
        String id = UnknownItem.getItemDescriptor(stack);
        id = id.replace(" ", "%20");
        int metadata = 0;
        try {
            metadata = stack.func_77960_j();
        }
        catch (Throwable e) {
            // empty catch block
        }
        int count = stack.field_77994_a;
        if (ignoreCount) {
            count = 1;
        }
        String repr = id + ":" + (metadata == Short.MAX_VALUE ? "*" : Integer.toString(metadata));
        if (count > 1 || repr.matches("^[0-9]+x.*")) {
            repr = Integer.toString(count) + "x" + repr;
        }
        return repr;
    }

    public static ItemStack processItem(String segment, int defaultMetadata) {
        int i;
        String newSegment;
        int count = 1;
        int metadata = defaultMetadata;
        String[] parts = (segment = segment.replace("%20", " ")).split(":", -1);
        if (parts.length > 1) {
            newSegment = "";
            for (i = 0; i < parts.length - 1; ++i) {
                newSegment = newSegment + (i == 0 ? "" : ":") + parts[i];
            }
            try {
                metadata = parts[i].trim().equals("*") ? Short.MAX_VALUE : Integer.parseInt(parts[i].trim());
            }
            catch (NumberFormatException e) {
                newSegment = newSegment + ":" + parts[i];
            }
            segment = newSegment;
        }
        if ((parts = segment.split("x", -1)).length > 1) {
            newSegment = "";
            i = 0;
            try {
                count = Integer.parseInt(parts[i].trim());
                ++i;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            int first = i;
            while (i < parts.length) {
                newSegment = newSegment + (i == first ? "" : "x") + parts[i];
                ++i;
            }
            segment = newSegment;
        }
        lastMetadata = metadata;
        return UniqueItem.getItemStack(segment.trim(), metadata, count);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Recipe evaluateRecipe(String repr) {
        void var6_12;
        String uniqueRepr;
        ItemStack entry;
        int i;
        ArrayList<ItemStack> inputs;
        String[] parts = (repr = repr.trim()).split(" > ");
        if (parts.length != 2) {
            throw new DynamicRecipeException("Recipe \"" + repr + "\" doesn't have a ' > ' separator between input and output items");
        }
        parts[1] = parts[1].trim();
        int outputEnd = parts[1].indexOf(" ");
        String pattern = null;
        String outputString = outputEnd < 0 ? parts[1] : parts[1].substring(0, outputEnd).trim();
        ItemStack output = DynamicRecipes.processItem(outputString, 0);
        if (output == null) {
            throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid output item \"" + outputString + "\"");
        }
        if (outputEnd >= 0) {
            String string = parts[1].substring(outputEnd).trim();
            int jsonEnd = string.lastIndexOf("}");
            int patternStart = string.lastIndexOf("|");
            if (patternStart > jsonEnd) {
                pattern = string.substring(patternStart + 2);
            }
            if (jsonEnd >= 0) {
                String jsonString = string.substring(0, jsonEnd + 1).trim();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)jsonString);
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid data tag \"" + jsonString + "\"");
                    }
                    output.func_77982_d(nbtbase);
                }
                catch (NBTException nbtexception) {
                    throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid data tag \"" + jsonString + "\"");
                }
            }
        }
        if (pattern != null) {
            inputs = new ArrayList<ItemStack>();
            parts = parts[0].split(" \\+ ");
            for (i = 0; i < parts.length; ++i) {
                entry = DynamicRecipes.processItem(parts[i], Short.MAX_VALUE);
                if (entry == null) {
                    throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid input item \"" + parts[i] + "\"");
                }
                inputs.add(UnknownItem.wrap(UnknownItem.getItemDescriptor(entry), lastMetadata, null));
            }
            if (inputs.size() > 9) {
                throw new DynamicRecipeException("Recipe \"" + repr + "\" has too many input items (over 9)");
            }
            if (inputs.size() < 1) {
                throw new DynamicRecipeException("Recipe \"" + repr + "\" has no input items");
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i2 = 0; i2 < pattern.length(); ++i2) {
                try {
                    int v = Integer.parseInt(pattern.substring(i2, i2 + 1));
                    if (v > inputs.size()) {
                        throw new DynamicRecipeException("Recipe pattern references input #" + v + " but only " + items.size() + " inputs were provided (for recipe \"" + repr + "\")");
                    }
                    if (v == 0) {
                        items.add(null);
                        continue;
                    }
                    items.add(((ItemStack)inputs.get(v - 1)).func_77946_l());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid pattern \"" + pattern + "\"");
                }
            }
            if (pattern.length() == 9) {
                ShapedRecipe shapedRecipe = new ShapedRecipe(3, 3, items.toArray(new ItemStack[items.size()]), output);
            } else if (pattern.length() == 4) {
                ShapedRecipe shapedRecipe = new ShapedRecipe(2, 2, items.toArray(new ItemStack[items.size()]), output);
            } else {
                if (pattern.length() != 1) throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid pattern size \"" + pattern + "\", it must be 9, 4 or 1");
                ShapedRecipe shapedRecipe = new ShapedRecipe(1, 1, items.toArray(new ItemStack[items.size()]), output);
            }
        } else {
            inputs = new ArrayList();
            parts = parts[0].split(" \\+ ");
            for (i = 0; i < parts.length; ++i) {
                entry = DynamicRecipes.processItem(parts[i], Short.MAX_VALUE);
                if (entry == null) {
                    throw new DynamicRecipeException("Recipe \"" + repr + "\" has an invalid input item \"" + parts[i] + "\"");
                }
                for (int j = 0; j < entry.field_77994_a; ++j) {
                    inputs.add(UnknownItem.wrap(UnknownItem.getItemDescriptor(entry), lastMetadata, null));
                }
            }
            if (inputs.size() > 9) {
                throw new DynamicRecipeException("Recipe \"" + repr + "\" has too many input items (over 9)");
            }
            if (inputs.size() < 1) {
                throw new DynamicRecipeException("Recipe \"" + repr + "\" has no input items");
            }
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(output, inputs);
        }
        if (existingRecipes.containsKey(uniqueRepr = var6_12.getRepresentation())) {
            return existingRecipes.get(uniqueRepr);
        }
        existingRecipes.put(uniqueRepr, (Recipe)var6_12);
        return var6_12;
    }

    public static void unoverrideRecipes() {
        for (int i = overrideUndoList.size() - 1; i >= 0; --i) {
            Object o = overrideUndoList.get(i);
            if (o instanceof AddedOverride) {
                ((AddedOverride)o).undo();
                continue;
            }
            if (!(o instanceof DisabledOverride)) continue;
            ((DisabledOverride)o).undo();
        }
        overrideUndoList.clear();
        existingDisabledRecipes.clear();
        overriddenRecipes.clear();
    }

    public static void sortRecipes() {
        if (disableRecipeSort) {
            return;
        }
        Collections.sort(CraftingManager.func_77594_a().func_77592_b(), new Comparator<IRecipe>(){

            @Override
            public int compare(IRecipe o1, IRecipe o2) {
                if (o1 instanceof Recipe) {
                    if (o2 instanceof Recipe) {
                        String b;
                        String a;
                        try {
                            a = DynamicRecipes.getRepresentation(o1).replace("*", "|");
                        }
                        catch (Exception e) {
                            try {
                                DynamicRecipes.getRepresentation(o2).replace("*", "|");
                            }
                            catch (Exception ex) {
                                return 0;
                            }
                            return -1;
                        }
                        try {
                            b = DynamicRecipes.getRepresentation(o2).replace("*", "|");
                        }
                        catch (Exception e) {
                            return 1;
                        }
                        boolean ab = o1 instanceof ShapedOreRecipe || o1 instanceof ShapelessOreRecipe;
                        if (ab != (o2 instanceof ShapedOreRecipe || o2 instanceof ShapelessOreRecipe)) {
                            return ab ? 1 : -1;
                        }
                        return a.compareToIgnoreCase(b);
                    }
                    return -1;
                }
                if (o2 instanceof Recipe) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private static void processFurnaceRecipe(String line, boolean disabling, boolean setServer) {
        String rest;
        int jsonEnd;
        String[] parts = (line = line.trim()).split(" > ");
        if (parts.length != 2) {
            throw new DynamicRecipeException("Smelting recipe \"" + line + "\" doesn't have a ' > ' separator between input and output items");
        }
        parts[1] = parts[1].trim();
        int outputEnd = parts[1].indexOf(" ");
        String outputString = outputEnd < 0 ? parts[1] : parts[1].substring(0, outputEnd).trim();
        ItemStack output = DynamicRecipes.processItem(outputString, 0);
        if (output == null) {
            throw new DynamicRecipeException("Smelting recipe \"" + line + "\" has an invalid output item \"" + outputString + "\"");
        }
        if (outputEnd >= 0 && (jsonEnd = (rest = parts[1].substring(outputEnd).trim()).lastIndexOf("}")) >= 0) {
            String jsonString = rest.substring(0, jsonEnd + 1).trim();
            try {
                NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)jsonString);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    throw new DynamicRecipeException("Smelting recipe \"" + line + "\" has an invalid data tag \"" + jsonString + "\"");
                }
                output.func_77982_d(nbtbase);
            }
            catch (NBTException nbtexception) {
                throw new DynamicRecipeException("Smelting recipe \"" + line + "\" has an invalid data tag \"" + jsonString + "\"");
            }
        }
        if (parts[0].split(" \\+ ").length != 1) {
            throw new DynamicRecipeException("Smelting recipe \"" + line + "\" has an invalid input item");
        }
        ItemStack input = DynamicRecipes.processItem(parts[0], Short.MAX_VALUE);
        if (input == null) {
            throw new DynamicRecipeException("Smelting recipe \"" + line + "\" has an invalid input item \"" + parts[0] + "\"");
        }
        FurnaceRecipe r = FurnaceRecipe.getRecipe(output, input);
        if (disabling) {
            r.disable(setServer);
        } else {
            r.enable(setServer);
        }
    }

    public static void processRecipe(String line, boolean setServer) {
        Recipe recipe;
        boolean disabling = false;
        if ((line = line.trim()).length() > 0 && line.charAt(0) == '!') {
            disabling = true;
            line = line.substring(1);
        }
        if (line.toLowerCase().startsWith("smelt")) {
            DynamicRecipes.processFurnaceRecipe(line.substring(5), disabling, setServer);
            return;
        }
        try {
            recipe = DynamicRecipes.evaluateRecipe(line);
        }
        catch (Exception ignored) {
            Logger.logger.warn("Backpacks! couldn't process dynamic recipe: " + line);
            return;
        }
        String repr = recipe.getRepresentation();
        if (disabling) {
            IRecipe r;
            if (settingOverriddenValues && setServer) {
                overrideUndoList.add(new DisabledOverride(repr, recipe));
                if (overriddenRecipes.contains(repr)) {
                    overriddenRecipes.remove(repr);
                    if (existingDisabledRecipes.contains(repr)) {
                        overriddenRecipes.add("!" + repr);
                    }
                } else {
                    if (recipes.containsKey(repr)) {
                        existingDisabledRecipes.add(repr);
                    } else {
                        r = DynamicRecipes.findRecipe(repr, recipe);
                        if (r != recipe && CraftingManager.func_77594_a().func_77592_b().contains(r)) {
                            existingDisabledRecipes.add(repr);
                        }
                    }
                    overriddenRecipes.add("!" + repr);
                }
            }
            if (setServer && recipesServerSide.contains(repr)) {
                recipesServerSide.remove(repr);
            }
            if (setServer && !disabledRecipesServerSide.contains(repr)) {
                disabledRecipesServerSide.add(repr);
            }
            if (!disabledRecipes.containsKey(repr)) {
                r = DynamicRecipes.findRecipe(repr, recipe);
                if (recipes.containsKey(repr)) {
                    recipes.remove(repr);
                }
                if (CraftingManager.func_77594_a().func_77592_b().contains(r)) {
                    CraftingManager.func_77594_a().func_77592_b().remove(r);
                    disabledRecipes.put(repr, r);
                }
            }
        } else {
            if (settingOverriddenValues && setServer) {
                overrideUndoList.add(new AddedOverride(repr, recipe));
                if (recipes.containsKey(repr)) {
                    existingDisabledRecipes.add(repr);
                }
                if (overriddenRecipes.contains("!" + repr)) {
                    overriddenRecipes.remove("!" + repr);
                }
                overriddenRecipes.add(repr);
            }
            IRecipe r = DynamicRecipes.findRecipe(repr, recipe);
            if (setServer && disabledRecipesServerSide.contains(repr)) {
                disabledRecipesServerSide.remove(repr);
            }
            if (disabledRecipes.containsKey(repr)) {
                disabledRecipes.remove(repr);
                if (r instanceof Recipe) {
                    recipe = (Recipe)r;
                } else {
                    CraftingManager.func_77594_a().func_77592_b().add(r);
                    return;
                }
            }
            if (r != recipe) {
                return;
            }
            if (!recipes.containsKey(repr)) {
                recipes.put(repr, recipe);
            }
            if (setServer && !recipesServerSide.contains(repr)) {
                recipesServerSide.add(repr);
            }
            if (settingOverriddenValues && !CraftingManager.func_77594_a().func_77592_b().contains(recipe)) {
                CraftingManager.func_77594_a().func_77592_b().add(recipe);
            }
        }
    }

    public static IRecipe findRecipe(String repr, Recipe recipe) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < list.size(); ++i) {
            IRecipe r = (IRecipe)list.get(i);
            String s = null;
            if (r instanceof ShapedRecipes) {
                s = ShapedRecipe.calculateRepresentation((ShapedRecipes)r);
            } else if (r instanceof ShapelessRecipes) {
                s = ShapelessRecipe.calculateRepresentation((ShapelessRecipes)r);
            } else if (r instanceof ShapedOreRecipe && recipe instanceof ShapedRecipes ? ShapedRecipe.matchesOreRecipe((ShapedRecipes)recipe, (ShapedOreRecipe)r) : r instanceof ShapelessOreRecipe && recipe instanceof ShapelessRecipes && ShapelessRecipe.matchesOreRecipe((ShapelessRecipes)recipe, (ShapelessOreRecipe)r)) {
                return r;
            }
            if (s == null || !repr.equals(s)) continue;
            return r;
        }
        if (disabledRecipes.containsKey(repr)) {
            return disabledRecipes.get(repr);
        }
        if (recipes.containsKey(repr)) {
            return recipes.get(repr);
        }
        return recipe;
    }

    public static String representItemObject(Object object) {
        if (object instanceof Item) {
            return UniqueItem.getDescriptor((Item)object);
        }
        if (object instanceof Block) {
            return UniqueItem.getDescriptor((Block)object);
        }
        if (object instanceof ItemStack) {
            return DynamicRecipes.representItem((ItemStack)object, false);
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new RuntimeException("Unexpected object type couldn't be represented in item notation: " + object);
    }

    public static void buildRecipe(ArrayList<String> list, Object output, String pattern, Object ... ingredients) {
        String input = "";
        boolean z = false;
        for (Object item : ingredients) {
            input = input + (z ? " + " : "") + DynamicRecipes.representItemObject(item);
            z = true;
        }
        input = input + " > " + DynamicRecipes.representItemObject(output);
        input = input + " | " + pattern;
        DynamicRecipes.processRecipe(input, true);
        if (list != null) {
            if ((input = input.trim()).length() > 0 && input.charAt(0) == '!') {
                input = input.substring(1);
            }
            list.add(DynamicRecipes.evaluateRecipe(input).getRepresentation());
        }
    }

    public static void buildRecipe(ArrayList<String> list, Object output, Object ... ingredients) {
        String input = "";
        boolean z = false;
        for (Object item : ingredients) {
            if (item instanceof Integer) {
                input = input + (z ? " + " : "") + item + "x";
                z = false;
                continue;
            }
            if (item instanceof String) {
                input = input + ":" + (String)item;
                continue;
            }
            input = input + (z ? " + " : "") + DynamicRecipes.representItemObject(item);
            z = true;
        }
        input = input + " > " + DynamicRecipes.representItemObject(output);
        DynamicRecipes.processRecipe(input, true);
        if (list != null) {
            if ((input = input.trim()).length() > 0 && input.charAt(0) == '!') {
                input = input.substring(1);
            }
            list.add(DynamicRecipes.evaluateRecipe(input).getRepresentation());
        }
    }

    public static ItemStack combineDurability(ItemStack stack, InventoryCrafting inventory) {
        NBTTagCompound tag;
        String id = UnknownItem.getItemDescriptor(stack);
        if (UnknownItem.customItems.containsKey(id) && UnknownItem.customItems.get(id).func_150297_b("default", 10)) {
            tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            NBTTagCompound tag2 = UnknownItem.customItems.get(id).func_74775_l("default");
            for (Object key : tag2.func_150296_c()) {
                if (tag.func_74764_b((String)key)) continue;
                tag.func_74782_a((String)key, tag2.func_74781_a((String)key).func_74737_b());
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("combineDurability", 10)) {
            tag = stack.func_77978_p().func_74775_l("combineDurability");
            stack.func_77978_p().func_82580_o("combineDurability");
            boolean exceedMaxDurability = tag.func_74767_n("exceedMaxDurability");
            NBTTagCompound override = tag.func_150297_b("overrideDurabilityFor", 10) ? tag.func_74775_l("overrideDurabilityFor") : new NBTTagCompound();
            int totalDamage = 0;
            int maxDurability = 0;
            float totalDurability = 0.0f;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack s = inventory.func_70301_a(i);
                if (s == null) continue;
                String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", ".");
                if (override.func_150297_b(desc + "@" + stack.func_77960_j(), 99)) {
                    totalDurability += override.func_74760_g(desc + "@" + stack.func_77960_j());
                    continue;
                }
                if (override.func_150297_b(desc, 99)) {
                    totalDurability += override.func_74760_g(desc);
                    continue;
                }
                int damage = 0;
                int durability = 0;
                if (s.func_77984_f()) {
                    damage = s.func_77960_j();
                    durability = s.func_77958_k();
                } else {
                    durability = 1;
                }
                totalDamage += damage;
                totalDurability += (float)durability;
                if (durability <= maxDurability) continue;
                maxDurability = durability;
            }
            totalDamage = (int)Math.ceil((double)totalDamage / (double)stack.field_77994_a);
            int totDurability = (int)Math.floor((double)totalDurability / (double)stack.field_77994_a);
            if (!exceedMaxDurability) {
                maxDurability = stack.func_77958_k();
            }
            if (totDurability - totalDamage > maxDurability) {
                if (exceedMaxDurability) {
                    stack.func_77978_p().func_74768_a("durability", totDurability - totalDamage);
                } else {
                    stack.func_77978_p().func_74768_a("durability", maxDurability);
                }
                stack.func_77964_b(0);
            } else {
                stack.func_77978_p().func_74768_a("durability", maxDurability);
                stack.func_77964_b(totalDamage - (totDurability - maxDurability));
                if (totalDamage - (totDurability - maxDurability) > maxDurability) {
                    return null;
                }
            }
        }
        return stack;
    }

    public static String getRepresentation(IRecipe recipe) {
        try {
            if (recipe instanceof Recipe) {
                return ((Recipe)recipe).getRepresentation();
            }
            if (recipe instanceof ShapelessRecipes) {
                return ShapelessRecipe.calculateRepresentation((ShapelessRecipes)recipe);
            }
            if (recipe instanceof ShapelessOreRecipe) {
                return ShapelessRecipe.calculateRepresentation((ShapelessOreRecipe)recipe);
            }
            if (recipe instanceof ShapedRecipes) {
                return ShapedRecipe.calculateRepresentation((ShapedRecipes)recipe);
            }
            if (recipe instanceof ShapedOreRecipe) {
                return ShapedRecipe.calculateRepresentation((ShapedOreRecipe)recipe);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String tagToString(NBTTagCompound tag) {
        if (tag == null) {
            return "";
        }
        String s = "{";
        Object[] keys = tag.func_150296_c().toArray();
        Arrays.sort(keys);
        for (Object k : keys) {
            String s1 = (String)k;
            NBTBase t = tag.func_74781_a(s1);
            String s2 = t instanceof NBTTagString ? "\"" + ((NBTTagString)t).func_150285_a_().replaceAll("\"", "\\\\\"") + "\"" : (t instanceof NBTTagCompound ? DynamicRecipes.tagToString((NBTTagCompound)t) : (t instanceof NBTTagList ? DynamicRecipes.tagToString((NBTTagList)t) : t.toString()));
            s = s + s1 + ':' + s2 + ", ";
        }
        if (s.endsWith(", ")) {
            return s.substring(0, s.length() - 2) + "}";
        }
        return s + "}";
    }

    public static String tagToString(NBTTagList tag) {
        if (tag == null) {
            return "";
        }
        if (tag.func_150303_d() == 10) {
            String s = "[";
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                s = s + DynamicRecipes.tagToString(tag.func_150305_b(i)) + ", ";
            }
            if (s.endsWith(", ")) {
                return s.substring(0, s.length() - 2) + "]";
            }
            return s + "]";
        }
        if (tag.func_150303_d() == 8) {
            String s = "[";
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                s = s + tag.func_150307_f(i).replaceAll("\"", "\\\"") + ", ";
            }
            if (s.endsWith(", ")) {
                return s.substring(0, s.length() - 2) + "]";
            }
            return s + "]";
        }
        return tag.toString();
    }

    public static ItemStack getSafeRecipeOutput(IRecipe recipe) {
        ItemStack stack = recipe.func_77571_b();
        if (stack == null || stack.func_77973_b() == null) {
            stack = UnknownItem.wrap("invalid recipe output (null)", 0, null);
        }
        return stack;
    }

    static {
        overrideUndoList = new ArrayList();
    }

    public static class FurnaceRecipe
    implements Recipe {
        public ItemStack output;
        public ItemStack input;
        public String representation;
        public boolean enabled;
        public Boolean unoverriddenEnabled = null;
        public static HashMap<FurnaceRecipe, Boolean> clientRecipes = new HashMap();
        public static HashMap<FurnaceRecipe, Boolean> serverRecipes = new HashMap();
        public static HashSet<FurnaceRecipe> overriddenRecipes = new HashSet();
        public static HashMap<String, FurnaceRecipe> existingRecipes = new HashMap();

        private boolean matches(ItemStack i, ItemStack o) {
            return FurnaceRecipe.getRecipe(o, i).getRepresentation().equals(this.representation);
        }

        public static void unoverrideRecipes() {
            for (FurnaceRecipe r : overriddenRecipes) {
                if (r.unoverriddenEnabled.booleanValue()) {
                    r.enable(true);
                    continue;
                }
                if (r.unoverriddenEnabled == null) continue;
                r.disable(true);
            }
            overriddenRecipes.clear();
        }

        public static void resetRecipes() {
            for (FurnaceRecipe r : clientRecipes.keySet()) {
                if (clientRecipes.get(r).booleanValue()) {
                    r.enable(false);
                    continue;
                }
                r.disable(false);
            }
            clientRecipes.clear();
        }

        public boolean enable(boolean setServer) {
            this.disable(setServer);
            this.enabled = true;
            if (!settingOverriddenValues) {
                this.unoverriddenEnabled = true;
            } else {
                overriddenRecipes.add(this);
            }
            if (setServer) {
                serverRecipes.put(this, true);
            }
            FurnaceRecipes.func_77602_a().func_77599_b().put(this.input, this.output);
            return true;
        }

        public boolean disable(boolean setServer) {
            Map.Entry entry;
            this.enabled = false;
            if (!settingOverriddenValues) {
                this.unoverriddenEnabled = false;
            } else {
                overriddenRecipes.add(this);
            }
            if (setServer) {
                serverRecipes.put(this, false);
            }
            Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                if (!clientRecipes.containsKey(this)) {
                    clientRecipes.put(this, false);
                }
                if (this.unoverriddenEnabled == null) {
                    this.unoverriddenEnabled = false;
                }
                return false;
            } while (!this.matches((ItemStack)(entry = iterator.next()).getKey(), (ItemStack)entry.getValue()));
            if (!clientRecipes.containsKey(this)) {
                clientRecipes.put(this, true);
            }
            if (this.unoverriddenEnabled == null) {
                this.unoverriddenEnabled = true;
            }
            iterator.remove();
            return true;
        }

        public static FurnaceRecipe getRecipe(ItemStack output, ItemStack input) {
            FurnaceRecipe f = new FurnaceRecipe(output, input);
            f.enabled = true;
            if (existingRecipes.containsKey(f.representation)) {
                return existingRecipes.get(f.representation);
            }
            existingRecipes.put(f.representation, f);
            return f;
        }

        private FurnaceRecipe(ItemStack output, ItemStack input) {
            this.output = output;
            this.input = input;
            this.representation = this.calculateRepresentation();
        }

        public String calculateRepresentation() {
            String s = FurnaceRecipe.calculateRepresentation(this);
            return s;
        }

        public ItemStack func_77571_b() {
            return this.output.func_77946_l();
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        }

        public boolean func_77569_a(InventoryCrafting var1, World var2) {
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting par1InventoryCrafting) {
            return DynamicRecipes.combineDurability(this.func_77571_b(), par1InventoryCrafting);
        }

        public int func_77570_a() {
            return 1;
        }

        public static String calculateRepresentation(FurnaceRecipe recipe) {
            if (representationCache.containsKey(recipe)) {
                return representationCache.get(recipe);
            }
            String repr = "smelt " + DynamicRecipes.representItem(recipe.input, true) + " > " + DynamicRecipes.representItem(DynamicRecipes.getSafeRecipeOutput(recipe), false);
            if (DynamicRecipes.getSafeRecipeOutput(recipe).func_77942_o()) {
                repr = repr + " " + DynamicRecipes.tagToString(DynamicRecipes.getSafeRecipeOutput(recipe).func_77978_p());
            }
            representationCache.put(recipe, repr);
            return repr;
        }

        @Override
        public String getRepresentation() {
            return this.representation;
        }
    }

    public static class ShapedRecipe
    extends ShapedRecipes
    implements Recipe {
        public String representation = this.calculateRepresentation();

        public ShapedRecipe(int width, int height, ItemStack[] items, ItemStack output) {
            super(width, height, items, output);
        }

        public String calculateRepresentation() {
            String s = ShapedRecipe.calculateRepresentation(this);
            return s;
        }

        public ItemStack func_77571_b() {
            ItemStack stack = super.func_77571_b();
            if (stack == null) {
                stack = UnknownItem.wrap("invalid recipe output (null)", 0, null);
            }
            return stack.func_77946_l();
        }

        public static boolean matchesOreRecipe(ShapedRecipes r, ShapedOreRecipe recipe) {
            if (!DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77969_a(DynamicRecipes.getSafeRecipeOutput((IRecipe)r))) {
                return false;
            }
            RecipeInventory inv = new RecipeInventory(r);
            return recipe.func_77569_a((InventoryCrafting)inv, null);
        }

        public boolean func_77569_a(InventoryCrafting par1InventoryCrafting, World par2World) {
            for (int i = 0; i <= 3 - this.field_77576_b; ++i) {
                for (int j = 0; j <= 3 - this.field_77577_c; ++j) {
                    if (this.checkMatch(par1InventoryCrafting, i, j, true)) {
                        return true;
                    }
                    if (!this.checkMatch(par1InventoryCrafting, i, j, false)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkMatch(InventoryCrafting par1InventoryCrafting, int par2, int par3, boolean par4) {
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 3; ++l) {
                    ItemStack itemstack1;
                    int i1 = k - par2;
                    int j1 = l - par3;
                    ItemStack itemstack = null;
                    if (i1 >= 0 && j1 >= 0 && i1 < this.field_77576_b && j1 < this.field_77577_c) {
                        itemstack = par4 ? this.field_77574_d[this.field_77576_b - i1 - 1 + j1 * this.field_77576_b] : this.field_77574_d[i1 + j1 * this.field_77576_b];
                    }
                    if ((itemstack1 = par1InventoryCrafting.func_70463_b(k, l)) == null && itemstack == null) continue;
                    if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                        return false;
                    }
                    if (itemstack.func_77973_b() != itemstack1.func_77973_b()) {
                        return false;
                    }
                    if (itemstack.func_77960_j() != Short.MAX_VALUE && itemstack.func_77960_j() != itemstack1.func_77960_j()) {
                        return false;
                    }
                    if (!(itemstack.func_77973_b() instanceof UnknownItem) || UnknownItem.getItemDescriptor(itemstack).equals(UnknownItem.getItemDescriptor(itemstack1))) continue;
                    return false;
                }
            }
            return true;
        }

        public static String calculateRepresentation(ShapedRecipes recipe) {
            if (representationCache.containsKey(recipe)) {
                return representationCache.get(recipe);
            }
            String repr = "";
            String pattern = "";
            ArrayList<String> items = new ArrayList<String>();
            int width = recipe.field_77577_c;
            if (recipe.field_77576_b > width) {
                width = recipe.field_77576_b;
            }
            for (int y = 0; y < width; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (y >= recipe.field_77577_c || x >= recipe.field_77576_b) {
                        pattern = pattern + Integer.toString(0);
                        continue;
                    }
                    if (recipe.field_77574_d[y * recipe.field_77576_b + x] != null) {
                        repr = DynamicRecipes.representItem(recipe.field_77574_d[y * recipe.field_77576_b + x], true);
                        if (!items.contains(repr)) {
                            items.add(repr);
                        }
                        int index = items.indexOf(repr);
                        pattern = pattern + Integer.toString(index + 1);
                        continue;
                    }
                    pattern = pattern + Integer.toString(0);
                }
            }
            boolean x = false;
            repr = "";
            for (String item : items) {
                repr = repr + (x ? " + " : "") + item;
                x = true;
            }
            repr = repr + " > " + DynamicRecipes.representItem(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe), false);
            if (DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77942_o()) {
                repr = repr + " " + DynamicRecipes.tagToString(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77978_p());
            }
            representationCache.put((IRecipe)recipe, repr + " | " + pattern);
            return repr + " | " + pattern;
        }

        public static String calculateRepresentation(ShapedOreRecipe recipe) {
            if (representationCache.containsKey(recipe)) {
                return representationCache.get(recipe);
            }
            int length = recipe.func_77570_a();
            String repr = null;
            int possibleA = 0;
            int possibleB = 0;
            if (length < 4) {
                possibleA = 1;
                possibleB = length;
            } else if (length == 4) {
                possibleB = 2;
                possibleA = 2;
            } else if (length == 6) {
                possibleA = 2;
                possibleB = 3;
            } else if (length == 9) {
                possibleB = 3;
                possibleA = 3;
            } else {
                throw new RuntimeException("Invalid ShapedOreRecipe size");
            }
            repr = ShapedRecipe.calculateRepresentation(recipe, possibleA, possibleB);
            if (possibleA != possibleB && !ShapedRecipe.matchesOreRecipe((ShapedRecipes)DynamicRecipes.evaluateRecipe(repr), recipe)) {
                repr = ShapedRecipe.calculateRepresentation(recipe, possibleB, possibleA);
            }
            representationCache.put((IRecipe)recipe, repr);
            return repr;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static String calculateRepresentation(ShapedOreRecipe recipe, int guessedWidth, int guessedHeight) {
            Iterator i$;
            boolean x;
            String repr = "";
            String pattern = "";
            ArrayList<String> items = new ArrayList<String>();
            int width = guessedHeight;
            if (guessedWidth > width) {
                width = guessedWidth;
            }
            Object[] inputs = recipe.getInput();
            int y = 0;
            while (true) {
                if (y < width) {
                } else {
                    x = false;
                    repr = "";
                    i$ = items.iterator();
                    break;
                }
                for (int x2 = 0; x2 < width; ++x2) {
                    if (y >= guessedHeight || x2 >= guessedWidth) {
                        pattern = pattern + Integer.toString(0);
                        continue;
                    }
                    if (inputs[y * guessedWidth + x2] != null) {
                        block16: {
                            Object obj = inputs[y * guessedWidth + x2];
                            if (obj instanceof ItemStack) {
                                repr = DynamicRecipes.representItem((ItemStack)obj, true);
                            } else {
                                if (obj instanceof List) {
                                    ArrayList<String> reprs = new ArrayList<String>();
                                    for (ItemStack i : (List)obj) {
                                        reprs.add(DynamicRecipes.representItem(i, true));
                                    }
                                    Collections.sort(reprs);
                                    if (reprs.size() > 0) {
                                        repr = (String)reprs.get(0);
                                        break block16;
                                    } else {
                                        pattern = pattern + Integer.toString(0);
                                        continue;
                                    }
                                }
                                repr = "NotAnItem";
                            }
                        }
                        if (!items.contains(repr)) {
                            items.add(repr);
                        }
                        int index = items.indexOf(repr);
                        pattern = pattern + Integer.toString(index + 1);
                        continue;
                    }
                    pattern = pattern + Integer.toString(0);
                }
                ++y;
            }
            while (i$.hasNext()) {
                String item = (String)i$.next();
                repr = repr + (x ? " + " : "") + item;
                x = true;
            }
            repr = repr + " > " + DynamicRecipes.representItem(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe), false);
            if (DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77942_o()) {
                repr = repr + " " + DynamicRecipes.tagToString(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77978_p());
            }
            return repr + " | " + pattern;
        }

        @Override
        public String getRepresentation() {
            return this.representation;
        }
    }

    public static class RecipeInventory
    extends InventoryCrafting {
        private ItemStack[] stackList;
        private int inventoryWidth;

        public RecipeInventory(int width, int height) {
            super(null, width, height);
            int k = width * height;
            this.stackList = new ItemStack[k];
            this.inventoryWidth = width;
        }

        public RecipeInventory(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c);
            for (int x = 0; x < recipe.field_77576_b; ++x) {
                for (int y = 0; y < recipe.field_77577_c; ++y) {
                    this.stackList[x + y * recipe.field_77576_b] = recipe.field_77574_d[x + y * recipe.field_77576_b];
                }
            }
        }

        public RecipeInventory(ShapelessRecipes recipe) {
            this(3, 3);
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int i = x + y * 3;
                    this.stackList[i] = i < recipe.field_77579_b.size() ? (ItemStack)recipe.field_77579_b.get(i) : null;
                }
            }
        }

        public int func_70302_i_() {
            return this.stackList.length;
        }

        public ItemStack func_70301_a(int slot) {
            return slot >= this.func_70302_i_() ? null : this.stackList[slot];
        }

        public ItemStack func_70463_b(int x, int y) {
            if (x >= 0 && x < this.inventoryWidth) {
                return this.func_70301_a(x + y * this.inventoryWidth);
            }
            return null;
        }

        public ItemStack getStackInSlotOnClosing(int slot) {
            return null;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }

    public static class ShapelessRecipe
    extends ShapelessRecipes
    implements Recipe {
        public String representation = this.calculateRepresentation();

        public ShapelessRecipe(ItemStack output, List inputs) {
            super(output, inputs);
        }

        public static boolean matchesOreRecipe(ShapelessRecipes r, ShapelessOreRecipe recipe) {
            if (!DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77969_a(DynamicRecipes.getSafeRecipeOutput((IRecipe)r))) {
                return false;
            }
            RecipeInventory inv = new RecipeInventory(r);
            return recipe.func_77569_a((InventoryCrafting)inv, null);
        }

        public String calculateRepresentation() {
            String s = ShapelessRecipe.calculateRepresentation(this);
            return s;
        }

        public boolean func_77569_a(InventoryCrafting par1InventoryCrafting, World par2World) {
            ArrayList arraylist = new ArrayList(this.field_77579_b);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack itemstack = par1InventoryCrafting.func_70463_b(j, i);
                    if (itemstack == null) continue;
                    boolean flag = false;
                    for (ItemStack itemstack1 : arraylist) {
                        boolean bl = flag = itemstack.func_77973_b() == itemstack1.func_77973_b() && (itemstack1.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == itemstack1.func_77960_j());
                        if (flag && itemstack1.func_77973_b() instanceof UnknownItem) {
                            flag = UnknownItem.getItemDescriptor(itemstack).equals(UnknownItem.getItemDescriptor(itemstack1));
                        }
                        if (!flag) continue;
                        arraylist.remove(itemstack1);
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
            }
            return arraylist.isEmpty();
        }

        public ItemStack func_77571_b() {
            ItemStack stack = super.func_77571_b();
            if (stack == null) {
                stack = UnknownItem.wrap("invalid recipe output (null)", 0, null);
            }
            return stack.func_77946_l();
        }

        public ItemStack func_77572_b(InventoryCrafting par1InventoryCrafting) {
            return DynamicRecipes.combineDurability(this.func_77571_b(), par1InventoryCrafting);
        }

        public static String calculateRepresentation(ShapelessRecipes recipe) {
            if (representationCache.containsKey(recipe)) {
                return representationCache.get(recipe);
            }
            String repr = "";
            ArrayList<String> items = new ArrayList<String>();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (Object obj : recipe.field_77579_b) {
                ItemStack itemStack = (ItemStack)obj;
                if (itemStack == null) continue;
                repr = DynamicRecipes.representItem(itemStack, true);
                if (!counts.containsKey(repr)) {
                    counts.put(repr, 0);
                }
                counts.put(repr, (Integer)counts.get(repr) + 1);
            }
            for (String item : counts.keySet()) {
                items.add(Integer.toString((Integer)counts.get(item)) + "x" + item);
            }
            Collections.sort(items);
            boolean x = false;
            repr = "";
            for (String string : items) {
                repr = repr + (x ? " + " : "") + string;
                x = true;
            }
            repr = repr + " > " + DynamicRecipes.representItem(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe), false);
            if (DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77942_o()) {
                repr = repr + " " + DynamicRecipes.tagToString(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77978_p());
            }
            representationCache.put((IRecipe)recipe, repr);
            return repr;
        }

        public static String calculateRepresentation(ShapelessOreRecipe recipe) {
            if (representationCache.containsKey(recipe)) {
                return representationCache.get(recipe);
            }
            String repr = "";
            ArrayList<String> items = new ArrayList<String>();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (Object obj : recipe.getInput()) {
                if (obj instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)obj;
                    if (itemStack == null) continue;
                    repr = DynamicRecipes.representItem(itemStack, true);
                    if (!counts.containsKey(repr)) {
                        counts.put(repr, 0);
                    }
                    counts.put(repr, (Integer)counts.get(repr) + 1);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ItemStack i : (List)obj) {
                    arrayList.add(DynamicRecipes.representItem(i, true));
                }
                Collections.sort(arrayList);
                if (arrayList.size() <= 0) continue;
                repr = (String)arrayList.get(0);
                if (!counts.containsKey(repr)) {
                    counts.put(repr, 0);
                }
                counts.put(repr, (Integer)counts.get(repr) + 1);
            }
            for (String item : counts.keySet()) {
                items.add(Integer.toString((Integer)counts.get(item)) + "x" + item);
            }
            Collections.sort(items);
            boolean x = false;
            repr = "";
            for (String string : items) {
                repr = repr + (x ? " + " : "") + string;
                x = true;
            }
            repr = repr + " > " + DynamicRecipes.representItem(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe), false);
            if (DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77942_o()) {
                repr = repr + " " + DynamicRecipes.tagToString(DynamicRecipes.getSafeRecipeOutput((IRecipe)recipe).func_77978_p());
            }
            representationCache.put((IRecipe)recipe, repr);
            return repr;
        }

        @Override
        public String getRepresentation() {
            return this.representation;
        }
    }

    public static interface Recipe
    extends IRecipe {
        public String getRepresentation();
    }

    private static class DisabledOverride {
        private boolean wasServerSide = false;
        private String repr;
        private boolean wasntDisabledServerSide = false;
        private IRecipe recipeDisabled;
        private boolean removed = false;
        private boolean wasntDisabled = false;

        public DisabledOverride(String repr, Recipe recipe) {
            this.repr = repr;
            if (recipesServerSide.contains(repr)) {
                this.wasServerSide = true;
            }
            if (!disabledRecipesServerSide.contains(repr)) {
                this.wasntDisabledServerSide = true;
            }
            if (!disabledRecipes.containsKey(repr)) {
                this.recipeDisabled = DynamicRecipes.findRecipe(repr, recipe);
                if (recipes.containsKey(repr)) {
                    this.recipeDisabled = recipes.get(repr);
                    this.removed = true;
                    recipes.remove(repr);
                }
                this.wasntDisabled = this.recipeDisabled != recipe;
            }
        }

        public void undo() {
            if (this.wasServerSide) {
                recipesServerSide.add(this.repr);
            }
            if (this.wasntDisabledServerSide) {
                disabledRecipesServerSide.remove(this.repr);
            }
            if (this.removed) {
                recipes.put(this.repr, (Recipe)this.recipeDisabled);
            }
            if (this.wasntDisabled) {
                CraftingManager.func_77594_a().func_77592_b().add(this.recipeDisabled);
                disabledRecipes.remove(this.repr);
            }
        }
    }

    private static class AddedOverride {
        private boolean wasDisabledServerSide = false;
        private String repr;
        private IRecipe recipe;
        private boolean wasDisabled = false;
        private boolean wasAdded = false;
        private boolean wasAddedServerSide = false;
        private boolean wasAddedToList = false;

        public AddedOverride(String repr, Recipe rec) {
            this.repr = repr;
            if (disabledRecipesServerSide.contains(repr)) {
                this.wasDisabledServerSide = true;
            }
            this.recipe = rec;
            IRecipe r = DynamicRecipes.findRecipe(repr, rec);
            if (disabledRecipes.containsKey(repr)) {
                this.wasDisabled = true;
                this.recipe = r;
                if (!(r instanceof Recipe)) {
                    return;
                }
            }
            if (r != this.recipe) {
                return;
            }
            if (!recipes.containsKey(repr)) {
                this.wasAdded = true;
            }
            if (!recipesServerSide.contains(repr)) {
                this.wasAddedServerSide = true;
            }
            if (!CraftingManager.func_77594_a().func_77592_b().contains(this.recipe)) {
                this.wasAddedToList = true;
            }
        }

        public void undo() {
            if (this.wasDisabledServerSide) {
                disabledRecipesServerSide.add(this.repr);
            }
            if (this.wasDisabled) {
                disabledRecipes.put(this.repr, this.recipe);
                if (!(this.recipe instanceof Recipe)) {
                    CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
                    return;
                }
            }
            if (this.wasAdded) {
                recipes.remove(this.repr);
            }
            if (this.wasAddedServerSide) {
                recipesServerSide.remove(this.repr);
            }
            if (this.wasAddedToList) {
                CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
            }
        }
    }

    public static class DynamicRecipeException
    extends RuntimeException {
        public DynamicRecipeException(String string) {
            super(string);
        }
    }
}

