/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import brad16840.common.permissions.PermissionGroup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class UniqueItem
extends Item {
    private static BaseInventoryProvider playerInventoryProvider = new BaseInventoryProvider(){

        @Override
        public IInventory getInventory(EntityPlayer player) {
            return player.field_71071_by;
        }
    };
    private static ArrayList<WeakReference<BaseInventoryProvider>> baseInventories = new ArrayList();
    private static HashMap<String, ContainerItem> registeredContainerTypes = new HashMap();
    private static HashMap<String, ProtectedBlock> registeredProtectedBlockTypes = new HashMap();

    public static void registerContainerItem(ContainerItem template) {
        String id = template.getContainerItemType();
        if (registeredContainerTypes.containsKey(id)) {
            throw new RuntimeException("The container-item type '" + id + "' was registered twice");
        }
        registeredContainerTypes.put(id, template);
    }

    public static ContainerItem getContainerType(String typeId) {
        if (registeredContainerTypes.containsKey(typeId)) {
            return registeredContainerTypes.get(typeId);
        }
        return null;
    }

    public static void registerProtectedBlockType(ProtectedBlock template) {
        String id = template.getProtectedBlockType();
        if (registeredProtectedBlockTypes.containsKey(id)) {
            throw new RuntimeException("The protected block type '" + id + "' was registered twice");
        }
        registeredProtectedBlockTypes.put(id, template);
    }

    public static ProtectedBlock getProtectedBlockType(String typeId) {
        if (registeredProtectedBlockTypes.containsKey(typeId)) {
            return registeredProtectedBlockTypes.get(typeId);
        }
        return null;
    }

    public static void registerBaseInventoryProvider(BaseInventoryProvider handler) {
        baseInventories.add(new WeakReference<BaseInventoryProvider>(handler));
    }

    public static ArrayList<IInventory> getBaseInventories(EntityPlayer player) {
        ArrayList<IInventory> inventories = new ArrayList<IInventory>();
        Iterator<WeakReference<BaseInventoryProvider>> i = baseInventories.iterator();
        while (i.hasNext()) {
            WeakReference<BaseInventoryProvider> w = i.next();
            if (w == null || w.get() == null) {
                i.remove();
                continue;
            }
            IInventory inventory = ((BaseInventoryProvider)w.get()).getInventory(player);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        return inventories;
    }

    public static boolean hasIdentifier(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        if (tag.func_74764_b("stackId")) {
            return true;
        }
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            if (!UniqueItem.isUUID(lore.func_150307_f(i))) continue;
            return true;
        }
        return false;
    }

    public static String getIdentifier(ItemStack stack) {
        if (!UniqueItem.hasIdentifier(stack)) {
            return "none";
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("stackId")) {
            return tag.func_74779_i("stackId");
        }
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            if (!UniqueItem.isUUID(lore.func_150307_f(i))) continue;
            return lore.func_150307_f(i);
        }
        return "none";
    }

    private static boolean isUUID(String s) {
        if (!s.startsWith("BCMod: ")) {
            return false;
        }
        String[] parts = s.substring(7).split("-");
        if (parts.length != 5) {
            return false;
        }
        if (parts[0].length() != 8 || parts[1].length() != 4 || parts[2].length() != 4 || parts[3].length() != 4 || parts[4].length() != 12) {
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].matches("^[\\da-fA-F]+$")) continue;
            return false;
        }
        return true;
    }

    public static void setIdentifier(EntityPlayer player, ItemStack stack, String id) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a("stackId", id);
        if (!tag.func_74764_b("Lore")) {
            NBTTagList lore = new NBTTagList();
        }
        NBTTagList nlore = new NBTTagList();
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String entry = lore.func_150307_f(i);
            if (UniqueItem.isUUID(entry)) continue;
            nlore.func_74742_a((NBTBase)new NBTTagString(entry));
        }
        nlore.func_74742_a((NBTBase)new NBTTagString("BCMod: " + id));
        tag.func_74782_a("Lore", (NBTBase)nlore);
        if (stack.func_77973_b() instanceof UniqueItem) {
            ((UniqueItem)stack.func_77973_b()).onIdentification(player, stack, id);
        }
    }

    public static ItemStack getItem(IInventory inventory, String id) {
        int i = UniqueItem.getItemIndex(inventory, id);
        if (i < 0) {
            if (i == -2 && inventory instanceof InventoryPlayer) {
                return ((InventoryPlayer)inventory).func_70445_o();
            }
            return null;
        }
        return inventory.func_70301_a(i);
    }

    public static int getItemIndex(IInventory inventory, String id) {
        ItemStack stack;
        String guid;
        if (inventory == null) {
            return -1;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack2 = inventory.func_70301_a(i);
            if (!UniqueItem.getIdentifier(stack2).equals(id)) continue;
            return i;
        }
        if (inventory instanceof InventoryPlayer && (guid = UniqueItem.getIdentifier(stack = ((InventoryPlayer)inventory).func_70445_o())).equals(id)) {
            return -2;
        }
        return -1;
    }

    public static boolean scanInventory(IInventory inventory, String id, HashMap<String, String> visited, ArrayList<String> unvisited, String inventoryId) {
        if (inventory == null) {
            return false;
        }
        boolean foundId = false;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            String uuid = UniqueItem.getIdentifier(stack);
            if (uuid.equals(id)) {
                foundId = true;
            }
            if (stack == null || !(stack.func_77973_b() instanceof ContainerItem) || visited.containsKey(uuid)) continue;
            unvisited.add(uuid);
            visited.put(uuid, inventoryId);
        }
        if (inventory instanceof InventoryPlayer) {
            ItemStack stack = ((InventoryPlayer)inventory).func_70445_o();
            String uuid = UniqueItem.getIdentifier(stack);
            if (uuid.equals(id)) {
                foundId = true;
            }
            if (stack != null && stack.func_77973_b() instanceof ContainerItem && !visited.containsKey(uuid)) {
                unvisited.add(uuid);
                visited.put(uuid, inventoryId);
            }
        }
        return foundId;
    }

    private static int modifyItems(IInventory inventory, String id, ItemStackCallback callback) {
        ItemStack stack;
        int items = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack2 = inventory.func_70301_a(i);
            if (!UniqueItem.getIdentifier(stack2).equals(id)) continue;
            ++items;
            callback.callback(stack2);
        }
        if (inventory instanceof InventoryPlayer && UniqueItem.getIdentifier(stack = ((InventoryPlayer)inventory).func_70445_o()).equals(id)) {
            ++items;
            callback.callback(stack);
        }
        if (items > 0 && inventory instanceof UniqueItemInventory) {
            ((UniqueItemInventory)inventory).saveInventory();
        }
        return items;
    }

    public static ItemStack findItem(EntityPlayer player, String id) {
        return UniqueItem.getItem(UniqueItem.getInventoryContaining(player, id, null), id);
    }

    public static int modifyItems(EntityPlayer player, String id, List<IInventory> baseInventories, ItemStackCallback callback) {
        if (id.equals("none")) {
            return 0;
        }
        int items = 0;
        if (baseInventories == null) {
            baseInventories = UniqueItem.getBaseInventories(player);
        }
        Iterator<IInventory> iterator = baseInventories.iterator();
        HashMap<String, String> visited = new HashMap<String, String>();
        ArrayList<String> unvisited = new ArrayList<String>();
        while (iterator.hasNext()) {
            IInventory inventory = iterator.next();
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, "none")) continue;
            items += UniqueItem.modifyItems(inventory, id, callback);
        }
        while (!unvisited.isEmpty()) {
            String uuid = (String)unvisited.remove(0);
            UniqueItemInventory inventory = UniqueItemInventory.getInventory(player, uuid);
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, uuid)) continue;
            items += UniqueItem.modifyItems(inventory, id, callback);
        }
        return items;
    }

    public static IInventory getInventoryContaining(EntityPlayer player, String id, List<IInventory> baseInventories) {
        if (baseInventories == null) {
            baseInventories = UniqueItem.getBaseInventories(player);
        }
        Iterator<IInventory> iterator = baseInventories.iterator();
        HashMap<String, String> visited = new HashMap<String, String>();
        ArrayList<String> unvisited = new ArrayList<String>();
        while (iterator.hasNext()) {
            IInventory inventory = iterator.next();
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, "none")) continue;
            return inventory;
        }
        while (!unvisited.isEmpty()) {
            String uuid = (String)unvisited.remove(0);
            UniqueItemInventory inventory = UniqueItemInventory.getInventory(player, uuid);
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, uuid)) continue;
            return inventory;
        }
        return null;
    }

    public static boolean refreshIdChain(EntityPlayer player, String id, List<IInventory> baseInventories, ArrayList<String> chain) {
        Iterator<IInventory> iterator;
        if (baseInventories == null) {
            baseInventories = UniqueItem.getBaseInventories(player);
        }
        if (chain.size() > 1 && chain.get(chain.size() - 1).equals(id)) {
            iterator = baseInventories.iterator();
            while (iterator.hasNext()) {
                if (!UniqueItem.verifyIdChain(player, iterator.next(), chain, 1)) continue;
                return true;
            }
        }
        chain.clear();
        chain.add("none");
        iterator = baseInventories.iterator();
        HashMap<String, String> visited = new HashMap<String, String>();
        ArrayList<String> unvisited = new ArrayList<String>();
        while (iterator.hasNext()) {
            IInventory inventory = iterator.next();
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, "none")) continue;
            chain.add(1, id);
            return true;
        }
        while (!unvisited.isEmpty()) {
            String uuid = (String)unvisited.remove(0);
            UniqueItemInventory inventory = UniqueItemInventory.getInventory(player, uuid);
            if (!UniqueItem.scanInventory(inventory, id, visited, unvisited, uuid)) continue;
            String t = id;
            while (t != null && !t.equals("none")) {
                chain.add(1, t);
                t = visited.get(t);
            }
            return true;
        }
        return false;
    }

    private static boolean verifyIdChain(EntityPlayer player, IInventory inventory, ArrayList<String> chain, int pos) {
        String id = chain.get(pos);
        if (inventory == null || id.equals("none")) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            String uuid = UniqueItem.getIdentifier(stack);
            if (!uuid.equals(id)) continue;
            if (pos + 1 < chain.size() && stack.func_77973_b() instanceof ContainerItem) {
                return UniqueItem.verifyIdChain(player, UniqueItemInventory.createInventory(stack.func_77973_b(), player, uuid), chain, pos + 1);
            }
            return true;
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, net.minecraft.util.math.BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (Common.disableChestOpening) {
            return EnumActionResult.PASS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150486_ae || block == Blocks.field_150477_bB || block == Blocks.field_150462_ai) {
            Common.ensureInventorySubscribed(player, (IInventory)player.field_71071_by);
            if (!world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            Common.channel.sendToServer(new PacketHandler.OpenChest(new BlockPos(pos)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void onIdentification(EntityPlayer player, ItemStack stack, String uuid) {
        NBTTagCompound tag;
        if (!this.hasUniqueData()) {
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!player.field_70170_p.field_72995_K && !data.items.containsKey(uuid)) {
            tag = new NBTTagCompound();
            if (stack.func_77942_o()) {
                tag = stack.func_77978_p().func_74737_b();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                NBTTagCompound tag2 = new NBTTagCompound();
                tag2.func_74778_a("stackId", uuid);
                NBTTagList lore = new NBTTagList();
                lore.func_74742_a((NBTBase)new NBTTagString("BCMod: " + uuid));
                tag2.func_74782_a("Lore", (NBTBase)lore);
                stack.func_77982_d(tag2);
            }
            tag.func_74778_a("uuid", uuid);
            data.items.put(uuid, tag);
            data.markItemDirty(uuid);
        }
        tag = data.getItemData(uuid, true);
        if (stack.func_77973_b() instanceof ContainerItem) {
            if (!tag.func_74764_b("inventory")) {
                tag.func_74782_a("inventory", (NBTBase)new NBTTagCompound());
            }
            if (!(tag = tag.func_74775_l("inventory")).func_74764_b("container-type")) {
                tag.func_74778_a("container-type", ((ContainerItem)stack.func_77973_b()).getContainerItemType());
            }
        }
        data.markItemDirty(uuid);
        if (!PermissionGroup.hasGroup(player.field_70170_p, "I_" + uuid)) {
            PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, "I_" + uuid);
            group.owner = PermissionGroup.getPlayerPermission(player);
            group.parent = PermissionGroup.getGroup(player.field_70170_p, PermissionGroup.SpecialPermissionGroup.allowId);
            group.markDirty(player.field_70170_p);
        }
    }

    public boolean hasUniqueData() {
        return true;
    }

    public static ItemStack getItemStack(String itemDescriptor, int metadata, int count) {
        return UniqueItem.getItemStack(itemDescriptor, metadata, count, null);
    }

    public static ItemStack getItemStack(String itemDescriptor, int metadata, int count, NBTTagCompound capabilityTag) {
        ItemStack stack = UnknownItem.wrap(itemDescriptor, metadata, capabilityTag);
        stack.field_77994_a = count;
        return stack;
    }

    public static void setNBTId(NBTTagCompound tag, String id) {
        if (tag.func_74764_b("id172")) {
            tag.func_82580_o("id172");
        }
        tag.func_74778_a("id", id);
    }

    public static String getNBTId(NBTTagCompound tag) {
        if (tag.func_74764_b("id172")) {
            return tag.func_74779_i("id172");
        }
        return tag.func_74779_i("id");
    }

    public static String getDescriptor(Item item) {
        String id = "null";
        try {
            id = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item).toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    public static String getDescriptor(Block block) {
        String id = "null";
        try {
            id = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block).toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound tag) {
        ItemStack stack = UniqueItem.getItemStack(UniqueItem.getNBTId(tag), tag.func_74765_d("Damage"), tag.func_74771_c("Count"), tag.func_74764_b("ForgeCaps") ? tag.func_74775_l("ForgeCaps") : null);
        if (tag.func_150297_b("tag", 10)) {
            stack.func_77982_d(tag.func_74775_l("tag"));
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, NBTTagCompound tag) {
        tag = UniqueItem.writeItemStackToNBT(UniqueItem.getDescriptor(stack.func_77973_b()), stack.func_77960_j(), stack.field_77994_a, tag);
        NBTTagCompound forgeCaps = new NBTTagCompound();
        stack.func_77955_b(forgeCaps);
        if (forgeCaps.func_150297_b("ForgeCaps", 10)) {
            tag.func_74782_a("ForgeCaps", (NBTBase)forgeCaps.func_74775_l("ForgeCaps"));
        }
        if (stack.func_77942_o()) {
            tag.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return tag;
    }

    public static NBTTagCompound writeItemStackToNBT(String id, int damage, int count, NBTTagCompound tag) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        UniqueItem.setNBTId(tag, id);
        tag.func_74774_a("Count", (byte)count);
        tag.func_74777_a("Damage", (short)damage);
        return tag;
    }

    static {
        UniqueItem.registerBaseInventoryProvider(playerInventoryProvider);
    }

    public static interface ProtectedBlock {
        public void subscribeToSubItems(EntityPlayer var1, UniqueItemData var2, NBTTagCompound var3, ArrayList<NBTTagCompound> var4);

        public String getProtectedBlockType();
    }

    public static interface BaseInventoryProvider {
        public IInventory getInventory(EntityPlayer var1);
    }

    public static interface ItemRestorer {
        public void restore(EntityPlayer var1, ItemStack var2, World var3);

        public String getType();
    }

    public static interface ContainerItem {
        public int getSlotWidth(World var1, NBTTagCompound var2, String var3);

        public int getSlotHeight(World var1, NBTTagCompound var2, String var3);

        public String getContainerItemType();

        public boolean subscribeToContents();
    }

    public static interface ViewableItem {
        public StackableContainer viewItem(EntityPlayer var1, String var2, int var3);
    }

    public static interface OpenableItem {
        public Integer getPreferreredStack(ContainerStack var1, int var2);

        public boolean open(EntityPlayer var1, ItemStack var2, World var3);

        public boolean ensureInventoryIdentifiers(EntityPlayer var1, ItemStack var2);

        public StackableContainer openContainer(EntityPlayer var1, IInventory var2, int var3, ItemStack var4, int var5);
    }

    public static interface UpdatableItem {
        public void updateItemStack(StackableContainer.ContainerSlot var1, ItemStack var2);
    }

    public static interface ItemStackCallback {
        public void callback(ItemStack var1);
    }
}

