/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.gui.ImageButton;
import brad16840.common.permissions.gui.GroupView;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ContainerList {
    public int xPos;
    public int yPos;
    public int width;
    public int height;
    public StackableContainer container;
    public DataProvider data;
    public int size;
    public int scrollPos;
    public int topItem;
    public ImageButton scrollButtonUp;
    public ImageButton scrollButtonDown;
    public int dataHeight;
    private int pageHeight;
    private int barSize;
    private int barPos;
    public ArrayList<Integer> rowHeights;
    private boolean dragScrolling;
    private int lastClickedRow = -1;
    private long lastClickedTime = 0L;
    private long clickStartTime = 0L;
    public int scrollAmount = 11;
    private int scrollOffset = 0;
    private boolean isClicking = false;
    public int rowClicked = 0;
    public boolean isDragging = false;
    public int topOffset = 0;
    public int bottomOffset = 0;

    public ContainerList(StackableContainer container, int xPos, int yPos, int width, int height, DataProvider data) {
        this.container = container;
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
        this.data = data;
        this.rowHeights = new ArrayList();
        this.size = 0;
        this.pageHeight = height - 4;
    }

    public void addButtons() {
        this.scrollButtonDown = new ImageButton(this.container, -901, this.xPos + this.width - 18, this.yPos + this.height - 17, 19, 18, GroupView.texture, 176, 71);
        this.container.gui.addButton(this.scrollButtonDown);
        this.scrollButtonUp = new ImageButton(this.container, -902, this.xPos + this.width - 18, this.yPos, 19, 18, GroupView.texture, 176, 53);
        this.container.gui.addButton(this.scrollButtonUp);
        this.scrollButtonUp.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                ContainerList.this.scrollPos -= ContainerList.this.scrollAmount;
                ContainerList.this.updateData();
            }
        };
        this.scrollButtonDown.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                ContainerList.this.scrollPos += ContainerList.this.scrollAmount;
                ContainerList.this.updateData();
            }
        };
        this.updateData();
    }

    public void updateData() {
        int total = 0;
        this.topItem = 0;
        this.size = this.data.size();
        this.rowHeights.clear();
        for (int i = 0; i < this.size; ++i) {
            if ((total += this.data.getRowHeight(i)) < this.scrollPos) {
                ++this.topItem;
            }
            this.rowHeights.add(total);
        }
        this.dataHeight = this.size == 0 ? 0 : this.rowHeights.get(this.rowHeights.size() - 1);
        this.pageHeight = this.height - 1 - this.topOffset - this.bottomOffset;
        if (this.scrollPos + this.pageHeight > this.dataHeight) {
            this.scrollPos = this.dataHeight - this.pageHeight;
            while (this.topItem > 0 && this.getRowOffset(this.topItem) > this.scrollPos) {
                --this.topItem;
            }
        }
        if (this.scrollPos < 0) {
            this.scrollPos = 0;
        }
        int scrollbarSize = this.pageHeight - 36 + this.topOffset + this.bottomOffset;
        float percent = 0.0f;
        if (this.dataHeight != this.pageHeight) {
            percent = (float)this.scrollPos / (float)(this.dataHeight - this.pageHeight);
        }
        this.barSize = this.pageHeight * scrollbarSize / (this.dataHeight == 0 ? 1 : this.dataHeight);
        if (this.barSize < 7) {
            this.barSize = 7;
        }
        if (this.barSize > scrollbarSize) {
            this.barSize = scrollbarSize;
        }
        this.barPos = (int)((float)(scrollbarSize - this.barSize) * percent);
        if (this.barPos + this.barSize > scrollbarSize) {
            this.barPos = scrollbarSize - this.barSize;
        }
        if (this.barPos < 0) {
            this.barPos = 0;
        }
        this.barPos += this.yPos + 19;
        this.scrollButtonUp.field_146124_l = this.scrollPos > 0;
        this.scrollButtonDown.field_146124_l = this.scrollPos + this.pageHeight < this.dataHeight;
    }

    public void scrollToVisible(int slot) {
        this.scrollPos = this.getRowOffset(slot) - this.pageHeight / 2;
        this.updateData();
    }

    public void ensureRangeIsVisible(int start, int end) {
        int endScroll = this.getRowOffset(end + 1);
        int startScroll = this.getRowOffset(start);
        int scroll = this.scrollPos;
        if (this.scrollPos + this.pageHeight < endScroll) {
            this.scrollPos = endScroll - this.pageHeight;
        }
        if (this.scrollPos > startScroll) {
            this.scrollPos = startScroll;
        }
        this.updateData();
    }

    public int getRowOffset(int slot) {
        if (slot <= 0) {
            return 0;
        }
        if (slot >= this.rowHeights.size()) {
            return this.dataHeight;
        }
        return this.rowHeights.get(slot - 1);
    }

    public boolean mouseDown(int mx, int my) {
        if ((mx -= this.xPos) > 0 && mx < this.width - 20 && (my -= this.yPos) > this.topOffset && my < this.height - this.bottomOffset) {
            my += this.scrollPos - this.topOffset;
            for (int i = this.topItem; i < this.size; ++i) {
                if (this.rowHeights.get(i) < my) continue;
                this.clickStartTime = Minecraft.func_71386_F();
                this.isClicking = true;
                this.rowClicked = i;
                return true;
            }
            return false;
        }
        if (mx > this.width - 20 && mx < this.width && my > 0 && my < this.height - 2) {
            if (this.dataHeight <= this.pageHeight) {
                return false;
            }
            if (my < 18) {
                return true;
            }
            if (my > this.height - 18) {
                return true;
            }
            if ((my += this.yPos) > this.barPos && my < this.barPos + this.barSize) {
                this.dragScrolling = true;
                this.scrollOffset = my - this.barPos + this.yPos + 18;
                return true;
            }
            if (my < this.barPos) {
                this.scrollPos -= this.pageHeight / this.scrollAmount * this.scrollAmount;
                this.updateData();
            } else {
                this.scrollPos += this.pageHeight / this.scrollAmount * this.scrollAmount;
                this.updateData();
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(int mx, int my) {
        if (this.dragScrolling) {
            int scrollbarSize = this.pageHeight - 36 + this.topOffset + this.bottomOffset;
            this.scrollPos = this.barSize < scrollbarSize ? Math.round((float)((my - this.scrollOffset) * (this.dataHeight - this.pageHeight)) / (float)(scrollbarSize - this.barSize)) : 0;
            this.updateData();
            return true;
        }
        mx -= this.xPos;
        my -= this.yPos;
        if (this.isClicking) {
            if (mx > 0 && mx < this.width - 20 && my > this.topOffset && my < this.height - this.bottomOffset) {
                my += this.scrollPos - this.topOffset;
                for (int i = Math.max(this.topItem - 1, 0); i < this.size; ++i) {
                    if (this.rowHeights.get(i) < my) continue;
                    long thisClickedTime = Minecraft.func_71386_F();
                    if (this.rowClicked == i || thisClickedTime - this.clickStartTime < 1000L) {
                        return true;
                    }
                    this.isDragging = true;
                    my -= this.scrollPos - this.topOffset;
                    break;
                }
            }
            this.isClicking = false;
        }
        if (this.isDragging) {
            this.data.rowDragged(this.rowClicked, mx, my - this.topOffset);
        }
        return false;
    }

    public boolean mouseUp(int mx, int my) {
        this.isDragging = false;
        if (this.dragScrolling) {
            this.dragScrolling = false;
            this.updateData();
            return true;
        }
        if (this.isClicking) {
            this.isClicking = false;
            if ((mx -= this.xPos) > 0 && mx < this.width - 20 && (my -= this.yPos) > this.topOffset && my < this.height - this.bottomOffset) {
                my += this.scrollPos - this.topOffset;
                for (int i = this.topItem; i < this.size; ++i) {
                    if (this.rowHeights.get(i) < my) continue;
                    if (i != this.rowClicked) {
                        return true;
                    }
                    long thisClickedTime = Minecraft.func_71386_F();
                    this.data.rowSelected(i, i == this.lastClickedRow && thisClickedTime - this.lastClickedTime < 600L, mx - 1);
                    this.lastClickedRow = i;
                    this.lastClickedTime = thisClickedTime;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void drawForeground(int mx, int my) {
        this.container.gui.clipScreen(this.container, this.xPos + 1, this.yPos + 1 + this.topOffset, this.width - 21, this.height - 1 - this.topOffset - this.bottomOffset, null);
        int y = this.yPos + 1 - this.scrollPos + this.topOffset;
        int s = this.getRowOffset(this.topItem);
        if (my > this.yPos + this.topOffset + this.pageHeight) {
            my = -200;
        }
        for (int i = this.topItem; i < this.size && y + s <= this.yPos + this.topOffset + this.pageHeight; ++i) {
            this.data.drawRowForeground(i, this.xPos + 1, y + s, this.width - 20, mx, my);
            s = this.rowHeights.get(i);
        }
        this.container.gui.unclipScreen();
    }

    public void drawBackground(int mx, int my) {
        if (!this.dragScrolling && this.isClicking && !this.isDragging) {
            this.mouseDragged(mx, my);
        }
        int state = 1;
        if (this.dragScrolling || mx > this.xPos + this.width - 18 && mx < this.xPos + this.width && my > this.barPos && my < this.barPos + this.barSize) {
            state = 2;
        }
        if (this.pageHeight >= this.dataHeight) {
            state = 0;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.container.gui.bindTexture(GroupView.texture);
        int pos = this.barPos;
        int size = this.barSize;
        this.container.gui.drawTexture(this.container, this.xPos + this.width - 18, pos, 19, Math.min(size, 53) - 3, 176 + 19 * state, 0);
        while (size > 47) {
            this.container.gui.drawTexture(this.container, this.xPos + this.width - 18, pos += 47, 19, Math.min(size -= 47, 50) - 3, 176 + 19 * state, 3);
        }
        this.container.gui.drawTexture(this.container, this.xPos + this.width - 18, pos + size - 3, 19, 3, 176 + 19 * state, 50);
        this.container.gui.clipScreen(this.container, this.xPos + 1, this.yPos + 1 + this.topOffset, this.width - 21, this.height - 1 - this.topOffset - this.bottomOffset, null);
        int y = this.yPos + 1 - this.scrollPos + this.topOffset;
        int s = this.getRowOffset(this.topItem);
        if (my > this.yPos + this.topOffset + this.pageHeight) {
            my = -200;
        }
        for (int i = this.topItem; i < this.size && y + s <= this.yPos + this.topOffset + this.pageHeight; ++i) {
            this.data.drawRowBackground(i, this.xPos + 1, y + s, this.width - 20, mx, my);
            s = this.rowHeights.get(i);
        }
        this.container.gui.unclipScreen();
    }

    public boolean mouseWheel(int x, int y, int wheel) {
        int oldScrollPos = this.scrollPos;
        if (wheel < 0) {
            this.scrollPos += Math.max(this.scrollAmount, 1);
            this.updateData();
        } else if (wheel > 0) {
            this.scrollPos -= Math.max(this.scrollAmount, 1);
            this.updateData();
        }
        return oldScrollPos != this.scrollPos;
    }

    public static abstract class DataProvider {
        public StackableContainer container;

        public DataProvider(StackableContainer container) {
            this.container = container;
        }

        public abstract int size();

        public abstract int getRowHeight(int var1);

        public abstract void drawRowForeground(int var1, int var2, int var3, int var4, int var5, int var6);

        public abstract void drawRowBackground(int var1, int var2, int var3, int var4, int var5, int var6);

        public abstract void rowSelected(int var1, boolean var2, int var3);

        public void rowDragged(int row, int mx, int my) {
        }
    }
}

