/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ContainerList;
import brad16840.common.gui.RecipeEditor;
import java.util.ArrayList;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class NBTEditor
extends StackableContainer {
    private String value;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField textField;
    private RecipeEditor editor;
    private BlockSelector selector;
    private static int browserSize = 160;
    private boolean isRightClick = false;
    private String selectorId;
    @SideOnly(value=Side.CLIENT)
    private ContainerList nbtList;
    private NBTNode baseNode;
    private NBTParser.BaseNode nbtData = null;
    private ItemStack appearance;
    private static ArrayList<NBTValue> values = new ArrayList();
    private NBTTitle attributes = new NBTTitle("Attributes");
    private NBTTitle enchantments = new NBTTitle("Enchantments");
    private NBTTitleItem hideTooltips = new NBTTitleItem(null, "Tooltip Filter", "tooltip-filter", "{}");
    private NBTTitle customData = new NBTTitle("Custom Data");
    private NBTTitleItem combineDurability = new NBTTitleItem(null, "Combine Durability", "combineDurability", "{}");
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/nbt_editor.png");

    public void createNBTValues() {
        NBTTitle category = this.attributes;
        category.add(new NBTAttribute("Attack Damage", "generic.attackDamage", null));
        category.add(new NBTAttribute("Max Health", "generic.maxHealth", null));
        category.add(new NBTAttribute("Movement Speed", "generic.movementSpeed", null));
        category.add(new NBTAttribute("Knockback Resistance", "generic.knockbackResistance", null));
        category.add(new NBTAttribute("Other", "", null));
        category = new NBTTitle("Armor");
        this.enchantments.add(category);
        category.add(new NBTEnchantment("Protection", "0s"));
        category.add(new NBTEnchantment("Fire Protection", "1s"));
        category.add(new NBTEnchantment("Feather Falling", "2s"));
        category.add(new NBTEnchantment("Blast Protection", "3s"));
        category.add(new NBTEnchantment("Projectile Protection", "4s"));
        category.add(new NBTEnchantment("Respiration", "5s"));
        category.add(new NBTEnchantment("Aqua Affinity", "6s"));
        category.add(new NBTEnchantment("Thorns", "7s"));
        category = new NBTTitle("Weapons");
        this.enchantments.add(category);
        category.add(new NBTEnchantment("Sharpness", "16s"));
        category.add(new NBTEnchantment("Smite", "17s"));
        category.add(new NBTEnchantment("Bane of Arthropods", "18s"));
        category.add(new NBTEnchantment("Knockback", "19s"));
        category.add(new NBTEnchantment("Fire Aspect", "20s"));
        category.add(new NBTEnchantment("Looting", "21s"));
        category = new NBTTitle("Tools");
        this.enchantments.add(category);
        category.add(new NBTEnchantment("Efficiency", "32s"));
        category.add(new NBTEnchantment("Silk Touch", "33s"));
        category.add(new NBTEnchantment("Unbreaking", "34s"));
        category.add(new NBTEnchantment("Fortune", "35s"));
        category = new NBTTitle("Bows");
        this.enchantments.add(category);
        category.add(new NBTEnchantment("Power", "48s"));
        category.add(new NBTEnchantment("Punch", "49s"));
        category.add(new NBTEnchantment("Flame", "50s"));
        category.add(new NBTEnchantment("Infinity", "51s"));
        category = new NBTTitle("Fishing Rods");
        this.enchantments.add(category);
        category.add(new NBTEnchantment("Luck of the Sea", "61s"));
        category.add(new NBTEnchantment("Lure", "62s"));
        category = this.customData;
        NBTTitleItem subcategory = new NBTTitleItem(null, "Appearance", "appearance", "{}");
        this.customData.add(subcategory.setTooltip("What the item should look like"));
        subcategory.add("Name", "name", "\"\"").setTooltip("What this item should be called");
        subcategory.add("Tooltip", "tooltip", "\"\"").setTooltip("Use \u00a7e\\\\n\u00a7a to start a new line\\n\u00a7e%%\u00a7a to represent the color/format symbol\\n\u00a7aCan also use \u00a7e%damage%\u00a7a, \u00a7e%durability%\u00a7a, \\n\u00a7e%durabilityLeft%\u00a7a and \u00a7e%durabilityPercent%");
        subcategory.add("Id", "id", "\"minecraft:dirt\"").setTooltip("What item/block this should look like");
        subcategory.add("Damage", "damage", "0").setTooltip("What subtype this should look like");
        subcategory.add("NBT Tag", "tag", "{}").setTooltip("Needed to color leather armor");
        subcategory.add("Color (decimal)", "color", "16777215").setTooltip("Lets you change the color of the item");
        subcategory.add("Color (rgb)", "colorTag", "{r:0, g:0, b:0}").setTooltip("RGB version of the color tag");
        subcategory.add("Enchanted", "enchanted", "0").setTooltip("Whether or not this has an enchanted glow");
        subcategory.add("Render Passes", "renderPasses", "[0, 1]").setTooltip("\u00a7e[0]\u00a7a = solid, \u00a7e[1]\u00a7a = transparent, \u00a7e[0, 1]\u00a7a = both");
        category = (NBTTitle)new NBTTitle("Renderer Settings").setTooltip("Changes how the item gets rendered");
        subcategory.add(category);
        category.add(new NestedNBTValue(subcategory, "Disable ENTITY_ROTATION", "disable_entity_rotation", "1").setTooltip("Stops dropped items from rotating"));
        category.add(new NestedNBTValue(subcategory, "Disable ENTITY_BOBBING", "disable_entity_bobbing", "1").setTooltip("Stops dropped items from bobbing"));
        category.add(new NestedNBTValue(subcategory, "Disable BLOCK_3D]", "disable_block_3d", "1").setTooltip("Disables the 45 degree rotation used to render blocks"));
        category.add(new NestedNBTValue(subcategory, "Disable INVENTORY_BLOCK", "disable_inventory_block", "1").setTooltip("Renders in 2D (flat) in the inventory"));
        category.add(new NestedNBTValue(subcategory, "Disable EQUIPPED_BLOCK", "disable_equipped_block", "1").setTooltip("Renders in 2D (flat) when held"));
        category = this.customData;
        category.add(new NestedNBTValue(null, "Durability", "durability", "0").setTooltip("How much damage the item can take"));
        category.add(new NestedNBTValue(null, "Maximum Stack Size", "stackLimit", "64"));
        subcategory = new NBTTitleItem(null, "Tool Quality", "harvestLevel", "{}");
        category.add(subcategory.setTooltip("What quality of tool this behaves as\\n\u00a7e0\u00a7a = wood/gold, \u00a7e1\u00a7a = stone, \\n\u00a7e2\u00a7a = iron, \u00a7e3\u00a7a = diamond"));
        subcategory.add("Axe", "axe", "0");
        subcategory.add("Pickaxe", "pickaxe", "0");
        subcategory.add("Shovel", "shovel", "0");
        subcategory = new NBTTitleItem(null, "Mining Speed", "miningSpeed", "{}");
        category.add(subcategory.setTooltip("How fast this item can break blocks"));
        subcategory.add("All", "all", "1.0");
        subcategory.add("Effective", "effective", "1.0").setTooltip("Speed for blocks it's effective against");
        subcategory.add("Specific Block", "minecraft.block@meta", "1.0").setTooltip("Replace \u00a7e:\u00a7a in item name with \u00a7e.\u00a7a\\n\u00a7aSeperate name from metadata with \u00a7e@\u00a7a");
        subcategory = new NBTTitleItem(null, "Can Wear", "canWear", "{}");
        category.add(subcategory.setTooltip("What slots can this be worn on"));
        this.addDamageTypes((NBTTitleItem)subcategory.add(new NBTTitleItem(subcategory, "Helmet", "helmet", "{}")), 0);
        this.addDamageTypes((NBTTitleItem)subcategory.add(new NBTTitleItem(subcategory, "Chestplate", "chestplate", "{}")), 0);
        this.addDamageTypes((NBTTitleItem)subcategory.add(new NBTTitleItem(subcategory, "Leggings", "leggings", "{}")), 0);
        this.addDamageTypes((NBTTitleItem)subcategory.add(new NBTTitleItem(subcategory, "Boots", "boots", "{}")), 0);
        this.addDamageTypes((NBTTitleItem)category.add(new NBTTitleItem(null, "Armor Damage Scale", "armorDamageScale", "{}")), 1).setTooltip("Scales how much damage this\\n\u00a7atakes when protecting from damage");
        NBTTitle nBTTitle = category;
        category = new NBTTitle("Actions");
        nBTTitle.add(category.setTooltip("Allows items to actually do things"));
        subcategory = new NBTTitleItem(null, "Armor Effects", "armorEffect", "{}");
        category.add(subcategory.setTooltip("Triggers while the item is worn as armor"));
        this.addActionTypes(subcategory, false, "Frequency", "frequency", "20");
        subcategory = new NBTTitleItem(null, "Passive Effects", "passiveEffect", "{}");
        category.add(subcategory.setTooltip("Trigger while the item is in your inventory"));
        subcategory.add("Maximum Triggers", "maxTriggers", "1").setTooltip("Maximum times this can be triggered per tick");
        this.addActionTypes(subcategory, false, "Frequency", "frequency", "20", "Only trigger while held", "whileHeld", "1", "Only trigger while on hotbar", "onHotbar", "1");
        subcategory = new NBTTitleItem(null, "Use action", "useAction", "{}");
        category.add(subcategory.setTooltip("Triggers when you right-click\\n\u00a7aWill be triggered after block / mob action"));
        subcategory.add("Duration", "duration", "20").setTooltip("How long this can be used for or how long it takes to use");
        subcategory.add("Bypass block action", "bypassBlocks", "0").setTooltip("If this is present it will happen before block action\\n\u00a7aIf this is true it will prevent block action from happening");
        subcategory.add("Action type", "type", "\"none\"").setTooltip("Valid types are eat, drink, block or bow");
        this.addActionTypes(subcategory, false, "Frequency", "frequency", "20", "Triggers when finished", "onFinished", "1");
        this.addAction(new String[]{"Frequency", "frequency", "20", "Triggers when finished", "onFinished", "1"}, subcategory, "Use item", "useItem", "Id", "id", "\"minecraft:dirt\"", "Damage", "damage", "0", "NBT tag", "data", "{}");
        subcategory = new NBTTitleItem(null, "Block action", "blockAction", "{}");
        category.add(subcategory.setTooltip("Triggers when you right-click on a block"));
        this.addAction(null, subcategory, "Use item", "useItem", "Id", "id", "\"minecraft:dirt\"", "Damage", "damage", "0", "NBT tag", "data", "{}");
        this.addAction(null, subcategory, "Break", "break", "Drop Items", "dropItems", "1", "Break indestructible blocks", "creative", "0");
        this.addActionTypes(subcategory, false, new String[0]);
        subcategory = new NBTTitleItem(null, "Block break action", "breakBlock", "{}");
        category.add(subcategory.setTooltip("Triggers when you break a block with the item"));
        this.addActionTypes(subcategory, false, new String[0]);
        subcategory = new NBTTitleItem(null, "Mob Action", "mobAction", "{}");
        category.add(subcategory.setTooltip("Triggers when you use the item on a mob"));
        this.addAction(null, subcategory, "Use item", "useItem", "Id", "id", "\"minecraft:dirt\"", "Damage", "damage", "0", "NBT tag", "data", "{}");
        this.addAction(null, subcategory, "Mount mob", "mount", "Control mob", "controlMob", "{}");
        this.addAction(null, subcategory, "Carry mob", "carry", new String[0]);
        this.addActionTypes(subcategory, true, "Target self", "targetSelf", "true");
        subcategory = new NBTTitleItem(null, "Attack Mob action", "mobAction", "{}");
        category.add(subcategory.setTooltip("Triggers when you attack a mob with the item"));
        this.addAction(null, subcategory, "Mount mob", "mount", "Control mob", "controlMob", "{}");
        this.addAction(null, subcategory, "Carry mob", "carry", new String[0]);
        this.addActionTypes(subcategory, true, "Target self", "targetSelf", "true");
        subcategory = this.hideTooltips;
        subcategory.add("Use display tag", "display-tag", "1");
        subcategory.add("Show item info", "item-info", "1");
        subcategory.add("Show enchantments", "enchantments", "1");
        subcategory.add("Show attributes", "attributes", "1");
        subcategory.add("Show durability", "durability", "1");
        subcategory = this.combineDurability;
        subcategory.add("Can exceed maximum durability", "exceedMaxDurability", "1");
        subcategory.add("Override Durability For", "overrideDurabilityFor", "{minecraft.dirt@0:2}");
    }

    public NBTTitleItem addDamageTypes(NBTTitleItem subcategory, int type) {
        String def = "0";
        if (type == 0) {
            subcategory.add("Armor", "armor", "0");
        } else if (type == 1) {
            subcategory.add("All sources", "all", "1.0");
            def = "1.0";
        }
        NBTTitle category = new NBTTitle("Non-combat damage sources");
        subcategory.add(category);
        category.add(new NestedNBTValue(subcategory, "Generic *", "generic", def));
        category.add(new NestedNBTValue(subcategory, "Lava", "lava", def));
        category.add(new NestedNBTValue(subcategory, "Fire", "inFire", def));
        category.add(new NestedNBTValue(subcategory, "Burn (on fire) *", "onFire", def));
        category.add(new NestedNBTValue(subcategory, "Drown *", "drown", def));
        category.add(new NestedNBTValue(subcategory, "Starve *", "starve", def));
        category.add(new NestedNBTValue(subcategory, "Suffocate *", "inWall", def));
        category.add(new NestedNBTValue(subcategory, "Fall *", "fall", def));
        category.add(new NestedNBTValue(subcategory, "Void *", "outOfWorld", def));
        category.add(new NestedNBTValue(subcategory, "Falling block", "fallingBlock", def));
        category.add(new NestedNBTValue(subcategory, "Falling anvil", "anvil", def));
        category.add(new NestedNBTValue(subcategory, "Cactus", "cactus", def));
        category = new NBTTitle("Combat damage sources");
        subcategory.add(category);
        category.add(new NestedNBTValue(subcategory, "Player attack", "player", def));
        category.add(new NestedNBTValue(subcategory, "Mob attack", "mob", def));
        category.add(new NestedNBTValue(subcategory, "Poison / Damage potion *", "magic", def));
        category.add(new NestedNBTValue(subcategory, "Wither *", "wither", def));
        category.add(new NestedNBTValue(subcategory, "Thrown damage potion *", "indirectMagic", def));
        category.add(new NestedNBTValue(subcategory, "Arrow", "arrow", def));
        category.add(new NestedNBTValue(subcategory, "Snowball / Fishing hook", "thrown", def));
        category.add(new NestedNBTValue(subcategory, "Fireball (Ghast/Blaze/Wither)", "fireball", def));
        category.add(new NestedNBTValue(subcategory, "Thorns *", "thorns", def));
        category.add(new NestedNBTValue(subcategory, "Explosion", "explosion", def));
        category.add(new NestedNBTValue(subcategory, "Player-made explosion", "explosion.player", def));
        return subcategory;
    }

    public NBTTitleItem addAction(String[] extra, NBTTitleItem subcategory, String name, String key, String ... parts) {
        int i;
        NBTTitleItem category = new NBTTitleItem(subcategory, name, key, "{}");
        subcategory.add(category);
        for (i = 0; i < parts.length - 2; i += 3) {
            category.add(parts[i], parts[i + 1], parts[i + 2]);
        }
        if (extra != null) {
            for (i = 0; i < extra.length - 2; i += 3) {
                category.add(extra[i], extra[i + 1], extra[i + 2]);
            }
        }
        return category;
    }

    public NBTTitleItem addActionTypes(NBTTitleItem subcategory, boolean targetMob, String ... parts) {
        String[] mobParts = parts;
        if (targetMob) {
            parts = null;
        }
        this.addAction(parts, subcategory, "Damage durability", "damageDurability", "Amount", "amount", "1");
        this.addAction(parts, subcategory, "Repair durability", "repairDurability", "Amount", "amount", "1");
        NBTTitleItem t = this.addAction(mobParts, subcategory, "Accelerate", "accelerate", "Forward", "x", "0.0", "Up", "y", "0.0", "Sideways", "z", "0.0", "Forward Limit", "xLimit", "1.0", "Up Limit", "yLimit", "1.0", "Sideways Limit", "zLimit", "1.0", "Fall distance", "fallDistance", "0.0", "Target Ridden Mob", "targetRiddenMob", "1", "Fully Directional", "fullyDirectional", "1", "Invert Y when Directional", "invertDirectionalY", "1");
        this.addAction(mobParts, subcategory, "Hurt", "hurt", "Amount", "amount", "1", "Stop at", "min", "-1", "Damage type", "damageType", "generic", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Heal", "heal", "Amount", "amount", "1", "Stop at", "max", "20", "Cost if successful", "durabilityCost", "0");
        this.addAction(parts, subcategory, "Feed", "feed", "Amount", "amount", "1", "Stop at", "max", "20", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Ignite", "ignite", "Duration", "duration", "20", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Extinguish", "extinguish", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Cure status effect", "cure", "Id", "id", "0", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Inflict status effect", "inflict", "Id", "id", "0", "Level", "level", "1", "Duration", "duration", "20", "Combine with existing", "combine", "0", "Cost if successful", "durabilityCost", "0");
        this.addAction(parts, subcategory, "Drop item", "dropItem", "Probability", "chance", "1.0", "Id", "id", "\"minecraft:dirt\"", "Damage", "damage", "0", "Count", "count", "1", "NBT tag", "tag", "{}", "Drop without motion", "motionless", "0", "Cost if successful", "durabilityCost", "0");
        this.addAction(parts, subcategory, "Control ridden mob", "controlMob", "Mob Type", "mobType", "\"\"", "Duration", "duration", "-1");
        this.addAction(mobParts, subcategory, "Recall (teleport)", "recall", "Cost if successful", "durabilityCost", "0");
        this.addAction(mobParts, subcategory, "Mark (teleport)", "mark", "Cost if successful", "durabilityCost", "0");
        this.addAction(parts, subcategory, "Change item", "change", "Id", "id", "\"\"", "Damage", "damage", "0", "Count", "count", "1", "NBT tag", "tag", "{}");
        t = this.addAction(parts, subcategory, "If all", "if", "Then", "then", "{}", "Else", "else", "{}", "Name equals", "nameEquals", "\"\"", "Target ridden mob", "targetRidden", "1");
        NBTTitle category = new NBTTitle("Damage");
        t.add(category);
        category.add(new NestedNBTValue(t, "Damage Equals", "damageEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Damage Above", "damageAbove", "0"));
        category.add(new NestedNBTValue(t, "Damage Below", "damageBelow", "0"));
        category = new NBTTitle("Health");
        t.add(category);
        category.add(new NestedNBTValue(t, "Health Equals", "healthEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Health Above", "healthAbove", "0"));
        category.add(new NestedNBTValue(t, "Health Below", "healthBelow", "0"));
        category = new NBTTitle("State");
        t.add(category);
        category.add(new NestedNBTValue(t, "In Water", "inWater", "1"));
        category.add(new NestedNBTValue(t, "In Lava", "inLava", "1"));
        category.add(new NestedNBTValue(t, "On Ground", "onGround", "1"));
        category.add(new NestedNBTValue(t, "In Air", "inAir", "1"));
        category = new NBTTitle("Block conditions");
        t.add(category);
        category.add(new NestedNBTValue(t, "Block Id", "blockId", "[\"minecraft:dirt\"]"));
        category.add(new NestedNBTValue(t, "Block Metadata", "blockMetadata", "[0]"));
        category = new NBTTitle("Mob conditions");
        t.add(category);
        category.add(new NestedNBTValue(t, "Mob type", "mobType", "[\"Spider\"]"));
        category.add(new NestedNBTValue(t, "Name Equals", "mobNameEquals", "[\"Spider\"]"));
        NBTTitle c = category;
        category = new NBTTitle("Health");
        c.add(category);
        category.add(new NestedNBTValue(t, "Health Equals", "mobHealthEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Health Above", "mobHealthAbove", "0"));
        category.add(new NestedNBTValue(t, "Health Below", "mobHealthBelow", "0"));
        category = new NBTTitle("State");
        c.add(category);
        category.add(new NestedNBTValue(t, "In Water", "mobInWater", "1"));
        category.add(new NestedNBTValue(t, "In Lava", "mobInLava", "1"));
        category.add(new NestedNBTValue(t, "On Ground", "mobOnGround", "1"));
        category.add(new NestedNBTValue(t, "In Air", "mobInAir", "1"));
        t = this.addAction(parts, subcategory, "If any", "ifAny", "Then", "then", "{}", "Else", "else", "{}", "Target ridden mob", "targetRidden", "1", "Name equals", "nameEquals", "\"\"");
        category = new NBTTitle("Damage");
        t.add(category);
        category.add(new NestedNBTValue(t, "Damage Equals", "damageEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Damage Above", "damageAbove", "0"));
        category.add(new NestedNBTValue(t, "Damage Below", "damageBelow", "0"));
        category = new NBTTitle("Health");
        t.add(category);
        category.add(new NestedNBTValue(t, "Health Equals", "healthEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Health Above", "healthAbove", "0"));
        category.add(new NestedNBTValue(t, "Health Below", "healthBelow", "0"));
        category = new NBTTitle("State");
        t.add(category);
        category.add(new NestedNBTValue(t, "In Water", "inWater", "1"));
        category.add(new NestedNBTValue(t, "In Lava", "inLava", "1"));
        category.add(new NestedNBTValue(t, "On Ground", "onGround", "1"));
        category.add(new NestedNBTValue(t, "In Air", "inAir", "1"));
        category = new NBTTitle("Block conditions");
        t.add(category);
        category.add(new NestedNBTValue(t, "Block Id", "blockId", "[\"minecraft:dirt\"]"));
        category.add(new NestedNBTValue(t, "Block Metadata", "blockMetadata", "[0]"));
        category = new NBTTitle("Mob conditions");
        t.add(category);
        category.add(new NestedNBTValue(t, "Mob type", "mobType", "[\"Spider\"]"));
        category.add(new NestedNBTValue(t, "Name Equals", "mobNameEquals", "[\"Spider\"]"));
        category = new NBTTitle("Health");
        c.add(category);
        category.add(new NestedNBTValue(t, "Health Equals", "mobHealthEquals", "[0]"));
        category.add(new NestedNBTValue(t, "Health Above", "mobHealthAbove", "0"));
        category.add(new NestedNBTValue(t, "Health Below", "mobHealthBelow", "0"));
        category = new NBTTitle("State");
        c.add(category);
        category.add(new NestedNBTValue(t, "In Water", "mobInWater", "1"));
        category.add(new NestedNBTValue(t, "In Lava", "mobInLava", "1"));
        category.add(new NestedNBTValue(t, "On Ground", "mobOnGround", "1"));
        category.add(new NestedNBTValue(t, "In Air", "mobInAir", "1"));
        return subcategory;
    }

    public void updateNBTValues() {
        values.clear();
        this.attributes.addToList(values);
        this.enchantments.addToList(values);
        if (this.selectorId != null) {
            this.customData.addToList(values);
        } else {
            this.combineDurability.addToList(values);
        }
        this.hideTooltips.addToList(values);
        this.baseNode.addToList(values);
        for (NBTValue value : values) {
            value.updateColor(this.nbtData);
        }
        if (this.nbtList != null) {
            this.nbtList.updateData();
        }
    }

    public NBTEditor(RecipeEditor editor, String value) {
        super(176, 68 + browserSize);
        this.editor = editor;
        this.selector = null;
        this.value = value.replaceAll("\u00a7", "%%");
        this.createNBTValues();
    }

    public NBTEditor(BlockSelector selector, String value, String selectorId) {
        super(176, 68 + browserSize);
        this.editor = null;
        this.selector = selector;
        this.value = value.replaceAll("\u00a7", "%%");
        this.selectorId = selectorId;
        this.createNBTValues();
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveAndClose() {
        this.value = this.textField.getText();
        try {
            if (this.value.trim().isEmpty()) {
                NBTTagCompound tag;
                if (this.editor != null && this.editor.recipeInventory.items[9] != null) {
                    if (this.editor.recipeInventory.items[9].func_77973_b() instanceof UnknownItem) {
                        tag = new NBTTagCompound();
                        tag.func_74778_a("id", UnknownItem.getItemDescriptor(this.editor.recipeInventory.items[9]));
                        this.editor.recipeInventory.items[9].func_77982_d(tag);
                    } else {
                        this.editor.recipeInventory.items[9].func_77982_d(null);
                    }
                }
                if (this.selector != null) {
                    tag = new NBTTagCompound();
                    tag.func_74778_a("id", this.selectorId);
                    Common.channel.sendToServer(new PacketHandler.OverrideCustomItem(this.selectorId, tag));
                }
                this.gui.closeContainer(this.stackId);
                return;
            }
            this.value = this.value.replaceAll("%%", "\u00a7");
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)this.value);
            if (tag instanceof NBTTagCompound) {
                if (this.editor != null && this.editor.recipeInventory.items[9] != null) {
                    if (this.editor.recipeInventory.items[9].func_77973_b() instanceof UnknownItem) {
                        tag.func_74778_a("id", UnknownItem.getItemDescriptor(this.editor.recipeInventory.items[9]));
                    }
                    this.editor.recipeInventory.items[9].func_77982_d(tag);
                }
                if (this.selector != null) {
                    tag.func_74778_a("id", this.selectorId);
                    Common.channel.sendToServer(new PacketHandler.OverrideCustomItem(this.selectorId, tag));
                }
                this.gui.closeContainer(this.stackId);
            } else {
                new Translatable("problem.invalidnbt", new Object[0]).log((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
        catch (NBTException e) {
            new Translatable("problem.invalidnbt", new Object[0]).log((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    public void updateNBT() {
        this.nbtData = NBTParser.parse(this.textField.getText());
        NBTNode base = this.baseNode;
        this.baseNode = new NBTNode(this.nbtData, 0);
        this.baseNode.updateFrom(base);
        this.baseNode.on = true;
        for (NBTValue value : values) {
            value.updateColor(this.nbtData);
        }
        this.nbtList.updateData();
        this.updateNBTValues();
        this.appearance = new ItemStack((Item)Common.unknownItem);
        try {
            String value = this.textField.getText();
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value.replaceAll("%%", "\u00a7"));
            this.appearance.func_77982_d(tag);
        }
        catch (Exception e) {
            this.appearance.func_77982_d(null);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField = this.gui.addTextField(8, this, 11, 24 + browserSize, 150, 9);
        this.textField.setMaxStringLength(16840);
        this.textField.setCanLoseFocus(false);
        this.textField.setFocused(true);
        this.textField.setText(this.value);
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 7, 41 + browserSize, 80, 20, new Translatable("button.save", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                NBTEditor.this.saveAndClose();
            }
        }));
        this.gui.addButton(new StackableContainer.ContainerButton(this, 1, 90, 41 + browserSize, 80, 20, new Translatable("button.cancel", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                NBTEditor.this.gui.closeContainer(NBTEditor.this.stackId);
            }
        }));
        this.nbtList = new ContainerList(this, 7, 7, 161, browserSize - 15, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                return values.size();
            }

            @Override
            public int getRowHeight(int row) {
                return 9;
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 9;
                x += 4;
                if (row < 0 || row >= values.size()) {
                    return;
                }
                NBTValue value = (NBTValue)values.get(row);
                if (hovered) {
                    String n;
                    NBTParser.BaseNode node;
                    if (value.tooltip != null && value.tooltip.length() > 1) {
                        Translatable.addTo("\u00a7a" + value.tooltip, NBTEditor.this.gui.tooltips);
                    }
                    if (value instanceof NBTNode) {
                        node = ((NBTNode)value).node;
                        if (node != null && node.invalid != null) {
                            n = node.invalid;
                            if (n.length() > 40) {
                                n = n.substring(0, 38) + "...";
                            }
                            NBTEditor.this.gui.tooltips.add(n);
                        } else if (node != null && node.value != null) {
                            n = node.value;
                            if (n.length() > 40) {
                                n = n.substring(0, 38) + "...";
                            }
                            NBTEditor.this.gui.tooltips.add(n);
                        }
                    }
                    if (value instanceof NBTCustomItem && (node = ((NBTCustomItem)value).findNode(NBTEditor.this.nbtData)) != null && node.value != null) {
                        n = node.value;
                        if (n.length() > 40) {
                            n = n.substring(0, 38) + "...";
                        }
                        NBTEditor.this.gui.tooltips.add(n);
                    }
                }
                if (NBTEditor.this.selectorId != null && (value.name.equals("appearance") || value.name.equals("Appearance")) && NBTEditor.this.appearance != null) {
                    try {
                        GL11.glEnable((int)2896);
                        NBTEditor.this.gui.drawItemStack(NBTEditor.this.appearance, x + width - 22, y - 5);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glDisable((int)2896);
                        GL11.glDisable((int)2929);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (mx > x + width - 22 && mx < x + width - 4 && my > y - 5 && my < y + 13) {
                        NBTEditor.this.gui.customTooltipItem = NBTEditor.this.appearance;
                    }
                }
                if (NBTEditor.this.gui.customTooltipItem != null) {
                    NBTEditor.this.gui.tooltips.clear();
                }
                NBTEditor.this.gui.text(NBTEditor.this, value.name).drawString((x += value.xOffset) + 1, y + 1, hovered ? value.hoverColor : value.color);
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                boolean on;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 9;
                int color = hovered ? -12566336 : -8355712;
                x += 4;
                if (row < 0 || row >= values.size()) {
                    return;
                }
                NBTValue value = (NBTValue)values.get(row);
                if (value instanceof NBTNode && ((NBTNode)value).values != null) {
                    on = ((NBTNode)value).on;
                    NBTEditor.this.gui.drawHorizontalLine(NBTEditor.this, (x += value.xOffset) - 3, x - 1, y + 4, color);
                    if (!on) {
                        NBTEditor.this.gui.drawVerticalLine(NBTEditor.this, x - 2, y + 2, y + 6, color);
                    }
                }
                if (value instanceof NBTTitle || value instanceof NBTTitleItem) {
                    on = value instanceof NBTTitle ? ((NBTTitle)value).on : ((NBTTitleItem)value).on;
                    NBTEditor.this.gui.drawHorizontalLine(NBTEditor.this, (x += value.xOffset) - 3, x - 1, y + 4, color);
                    if (!on) {
                        NBTEditor.this.gui.drawVerticalLine(NBTEditor.this, x - 2, y + 2, y + 6, color);
                    }
                }
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (row < 0 || row >= values.size()) {
                    return;
                }
                NBTValue value = (NBTValue)values.get(row);
                value.click(NBTEditor.this.isRightClick, doubleClicked, mx);
            }
        });
        this.nbtList.addButtons();
        this.updateNBT();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (this.textField.keyPressed(key, keyCode)) {
            this.value = this.textField.getText();
            this.updateNBT();
            return true;
        }
        if (keyCode == 28) {
            this.saveAndClose();
            return true;
        }
        return false;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, new Translatable("gui.nbteditor.title", new Object[0]).translate()).truncateString(160).drawCenteredString(88, 9 + browserSize, -12566464);
        this.nbtList.drawForeground(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, browserSize, 0, 70);
        this.gui.drawTexture(this, 0, browserSize, this.guiWidth, this.guiHeight - browserSize, 0, 0);
        GL11.glDisable((int)2896);
        this.textField.drawBackground();
        this.nbtList.drawBackground(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        return this.nbtList.mouseWheel(x, y, wheel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0 || button == 1) {
            boolean bl = this.isRightClick = button == 1;
            if (this.nbtList.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        return this.nbtList.mouseDragged(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return this.nbtList.mouseUp(x, y);
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 0;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    public static class NBTParser {
        public static BaseNode parse(String json) {
            String value;
            int position;
            int offset = position = 0;
            while (position - offset < json.length() && json.charAt(position - offset) <= ' ') {
                ++position;
            }
            if ((json = json.trim()).startsWith("{")) {
                return NBTParser.getElement("Overview", json, position);
            }
            String name = NBTParser.getTagName(json, false, position);
            return NBTParser.getElement(name, value, position + ((value = NBTParser.getTagValue(json, false)) == null ? 0 : json.indexOf(value)));
        }

        static BaseNode getElement(String name, String json, int position) {
            if (name == null) {
                return new BaseNode("[missing name]", position, json).invalidate("This element is missing a name", position);
            }
            if (json == null) {
                return new BaseNode(name, position, json).invalidate("This element is missing a value", position);
            }
            int offset = position;
            while (position - offset < json.length() && json.charAt(position - offset) <= ' ') {
                ++position;
            }
            if ((json = json.trim()).startsWith("{")) {
                CompoundNode node = new CompoundNode(name, position, json);
                if (!json.endsWith("}")) {
                    return node.invalidate("Missing an end bracket", position + json.length() - 1);
                }
                json = json.substring(1, json.length() - 1);
                ++position;
                while (json.length() > 0) {
                    String tagName;
                    String s2;
                    BaseNode element;
                    int i = NBTParser.findToken(json, ':');
                    int j = NBTParser.findToken(json, ',');
                    if (i < 0 || j >= 0 && j < i) {
                        element = new BaseNode("[missing value]", position + (i < 0 ? 0 : j - 1), json);
                        element.invalidate("This element is missing a key-value seperator", position);
                        node.nodes.add(element);
                        return node.invalidate("An element is missing its key or value", position);
                    }
                    try {
                        s2 = NBTParser.getNextElement(json, false);
                    }
                    catch (ParsingException e) {
                        tagName = NBTParser.getTagName(json, false, 0);
                        if (tagName == null) {
                            tagName = "[invalid name]";
                        }
                        BaseNode element2 = new BaseNode(tagName, position, json);
                        element2.invalidate(e.reason, e.position);
                        node.nodes.add(element2);
                        return node.invalidate("An element is invalid", position);
                    }
                    if (s2.length() > 0) {
                        String tagValue;
                        tagName = NBTParser.getTagName(s2, false, 0);
                        element = NBTParser.getElement(tagName, tagValue, position + ((tagValue = NBTParser.getTagValue(s2, false)) == null ? 0 : json.indexOf(tagValue)));
                        if (node.containsKey(tagName)) {
                            element.invalidate(name + " already has a element called " + tagName, position);
                        }
                        node.nodes.add(element);
                        if (json.length() < s2.length() + 1) break;
                        char c0 = json.charAt(s2.length());
                        if (c0 != ',' && c0 != '{' && c0 != '}' && c0 != '[' && c0 != ']') {
                            return node.invalidate("Invalid seperator '" + c0 + "'", position + s2.length());
                        }
                        json = json.substring(s2.length() + 1);
                        position += s2.length() + 1;
                        continue;
                    }
                    return node.invalidate("Infinite loop... wtf", position);
                }
                return node;
            }
            if (json.startsWith("[") && !json.matches("\\[[-\\d|,\\s]+\\]")) {
                CompoundNode node = new CompoundNode(name, position, json);
                if (!json.endsWith("]")) {
                    return node.invalidate("Missing an end bracket", position + json.length() - 1);
                }
                json = json.substring(1, json.length() - 1);
                ++position;
                while (json.length() > 0) {
                    String tagName;
                    String s2;
                    try {
                        s2 = NBTParser.getNextElement(json, true);
                    }
                    catch (ParsingException e) {
                        tagName = NBTParser.getTagName(json, true, node.nodes.size());
                        BaseNode element = new BaseNode(tagName, position, NBTParser.getTagValue(json, true));
                        element.invalidate(e.reason, e.position);
                        node.nodes.add(element);
                        return node.invalidate("An element is invalid", position);
                    }
                    if (s2.length() > 0) {
                        tagName = NBTParser.getTagName(s2, true, node.nodes.size());
                        String tagValue = NBTParser.getTagValue(s2, true);
                        node.nodes.add(NBTParser.getElement(tagName, tagValue, position + (tagValue == null ? 0 : json.indexOf(tagValue))));
                        if (json.length() < s2.length() + 1) break;
                        char c0 = json.charAt(s2.length());
                        if (c0 != ',' && c0 != '{' && c0 != '}' && c0 != '[' && c0 != ']') {
                            return node.invalidate("Invalid seperator '" + c0 + "'", position + s2.length());
                        }
                        json = json.substring(s2.length() + 1);
                        position += s2.length() + 1;
                        continue;
                    }
                    return node.invalidate("Infinite loop... wtf", position);
                }
                return node;
            }
            BaseNode node = new BaseNode(name, position, json);
            if (json.startsWith("[") && json.endsWith("]")) {
                return node;
            }
            boolean flag = false;
            for (int j = 0; j < json.length(); ++j) {
                char c0 = json.charAt(j);
                if (c0 == '\"') {
                    if (j > 0 && json.charAt(j - 1) == '\\') {
                        if (flag) continue;
                        return node.invalidate("Encountered '\\\"' outside of a string", position + j);
                    }
                    flag = !flag;
                    continue;
                }
                if (flag || c0 != '[' && c0 != ']' && c0 != '{' && c0 != '}') continue;
                return node.invalidate("Encountered '" + c0 + "' outside of a " + (c0 == '[' || c0 == ']' ? "list" : "compound tag"), position + j);
            }
            if (flag) {
                node.invalidate("Missing a closing \"", position);
            }
            return node;
        }

        private static String getNextElement(String json, boolean isList) throws ParsingException {
            int k;
            int i = NBTParser.findToken(json, ':');
            int j = NBTParser.findToken(json, ',');
            if (isList && (i < 0 || i > j)) {
                i = -1;
            }
            Stack<Character> stack = new Stack<Character>();
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            int l = 0;
            for (k = i + 1; k < json.length(); ++k) {
                char c0 = json.charAt(k);
                if (c0 == '\"') {
                    if (k > 0 && json.charAt(k - 1) == '\\') {
                        if (!flag1) {
                            throw new ParsingException("Encountered '\\\"' outside of a string", k);
                        }
                    } else {
                        boolean bl = flag1 = !flag1;
                        if (flag1 && !flag3) {
                            flag2 = true;
                        }
                        if (!flag1) {
                            l = k;
                        }
                    }
                } else if (!flag1) {
                    if (c0 == '{' || c0 == '[') {
                        stack.push(Character.valueOf(c0));
                    } else {
                        if (c0 == '}' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '{')) {
                            throw new ParsingException("Encountered '}' outside of a compound tag", k);
                        }
                        if (c0 == ']' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '[')) {
                            throw new ParsingException("Encountered ']' outside of a list", k);
                        }
                        if (c0 == ',' && stack.isEmpty()) {
                            return json.substring(0, k);
                        }
                    }
                }
                if (Character.isWhitespace(c0)) continue;
                if (!flag1 && flag2 && l != k) {
                    return json.substring(0, l + 1);
                }
                flag3 = true;
            }
            return json.substring(0, k);
        }

        private static String getTagName(String element, boolean isList, int elementNumber) {
            if (isList && ((element = element.trim()).startsWith("{") || element.startsWith("["))) {
                return Integer.toString(elementNumber);
            }
            int i = element.indexOf(58);
            if (i < 0) {
                if (isList) {
                    return Integer.toString(elementNumber);
                }
                return null;
            }
            if (isList) {
                return Integer.toString(elementNumber);
            }
            return element.substring(0, i).trim();
        }

        private static String getTagValue(String element, boolean isList) {
            if (isList && ((element = element.trim()).startsWith("{") || element.startsWith("["))) {
                return element;
            }
            int i = element.indexOf(58);
            if (i < 0) {
                if (isList) {
                    return element;
                }
                return null;
            }
            return element.substring(i + 1).trim();
        }

        private static int findToken(String element, char p_150312_1_) {
            boolean insideString = false;
            for (int i = 0; i < element.length(); ++i) {
                char c1 = element.charAt(i);
                if (c1 == '\"') {
                    if (i > 0 && element.charAt(i - 1) == '\\') continue;
                    insideString = !insideString;
                    continue;
                }
                if (insideString) continue;
                if (c1 == p_150312_1_) {
                    return i;
                }
                if (c1 != '{' && c1 != '[') continue;
                return -1;
            }
            return -1;
        }

        public static class ParsingException
        extends Exception {
            public int position;
            public String reason;

            public ParsingException(String reason, int position) {
                super(reason);
                this.reason = reason;
                this.position = position;
            }
        }

        public static class CompoundNode
        extends BaseNode {
            public ArrayList<BaseNode> nodes = new ArrayList();

            public CompoundNode(String name, int position, String value) {
                super(name, position, value);
            }

            public boolean containsKey(String name) {
                for (BaseNode node : this.nodes) {
                    if (!node.name.equals(name)) continue;
                    return true;
                }
                return false;
            }
        }

        public static class BaseNode {
            public String invalid;
            public int position;
            public int invalidPosition;
            public String name;
            public String value;

            public BaseNode(String name, int position, String value) {
                this.name = name;
                this.position = position;
                this.value = value;
                this.invalidPosition = 0;
                this.invalid = null;
            }

            public BaseNode invalidate(String reason, int position) {
                if (reason != null && this.invalid != null) {
                    return this;
                }
                this.invalid = reason;
                this.invalidPosition = position;
                return this;
            }
        }
    }

    private class NestedNBTValue
    extends NBTCustomItem {
        public NBTTitleItem parent;
        public String key;
        public String value;

        public NestedNBTValue(NBTTitleItem parent, String name, String key, String value) {
            super(name);
            this.parent = parent;
            this.key = key;
            this.value = value;
        }

        @Override
        public NBTParser.BaseNode findParentNode(NBTParser.BaseNode node) {
            if (this.parent != null) {
                return this.findCompoundTag(this.parent.findParentNode(node), this.parent.key);
            }
            return node;
        }

        @Override
        public NBTParser.BaseNode createParentNodes(NBTParser.BaseNode node) {
            if (this.parent != null) {
                node = this.parent.createParentNodes(node);
                return this.findOrCreateParentTag(node, this.parent.key, this.parent.value);
            }
            return node;
        }

        @Override
        public String getRepresentation() {
            return this.key + ":" + this.value;
        }

        @Override
        public boolean matches(NBTParser.BaseNode node) {
            return node.name.equals(this.key);
        }
    }

    private class NBTEnchantment
    extends NBTCustomItem {
        public String enchantment;

        public NBTEnchantment(String name, String enchantment) {
            super(name);
            this.enchantment = enchantment;
        }

        @Override
        public NBTParser.BaseNode findParentNode(NBTParser.BaseNode node) {
            if (NBTEditor.this.selectorId != null) {
                node = this.findCompoundTag(node, "default");
            }
            return this.findCompoundTag(node, "ench");
        }

        @Override
        public NBTParser.BaseNode createParentNodes(NBTParser.BaseNode node) {
            if (NBTEditor.this.selectorId != null) {
                node = this.findOrCreateParentTag(node, "default", "{}");
            }
            return this.findOrCreateParentTag(node, "ench", "[]");
        }

        @Override
        public String getRepresentation() {
            return "{id:" + this.enchantment + ", lvl:1s}";
        }

        @Override
        public boolean matches(NBTParser.BaseNode node) {
            if (!(node instanceof NBTParser.CompoundNode)) {
                return false;
            }
            for (NBTParser.BaseNode a : ((NBTParser.CompoundNode)node).nodes) {
                if (!a.name.equals("id") || !a.value.equals(this.enchantment)) continue;
                return true;
            }
            return false;
        }
    }

    private class NBTAttribute
    extends NBTCustomItem {
        public String attribute;
        public UUID uuid;

        public NBTAttribute(String name, String attribute, UUID uuid) {
            super(name);
            this.attribute = attribute;
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            this.uuid = uuid;
        }

        @Override
        public NBTParser.BaseNode findParentNode(NBTParser.BaseNode node) {
            if (NBTEditor.this.selectorId != null) {
                node = this.findCompoundTag(node, "default");
            }
            return this.findCompoundTag(node, "AttributeModifiers");
        }

        @Override
        public NBTParser.BaseNode createParentNodes(NBTParser.BaseNode node) {
            if (NBTEditor.this.selectorId != null) {
                node = this.findOrCreateParentTag(node, "default", "{}");
            }
            return this.findOrCreateParentTag(node, "AttributeModifiers", "[]");
        }

        @Override
        public String getRepresentation() {
            return "{AttributeName:\"" + this.attribute + "\", Amount:0, Operation:0, Name:\"" + this.attribute + "\", UUIDLeast:" + this.uuid.getLeastSignificantBits() + "L, UUIDMost:" + this.uuid.getMostSignificantBits() + "L}";
        }

        @Override
        public boolean matches(NBTParser.BaseNode node) {
            if (!(node instanceof NBTParser.CompoundNode)) {
                return false;
            }
            for (NBTParser.BaseNode a : ((NBTParser.CompoundNode)node).nodes) {
                if (!a.name.equals("AttributeName") || !a.value.equals(this.attribute) && !a.value.equals("\"" + this.attribute + "\"")) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class NBTCustomItem
    extends NBTValue {
        public NBTCustomItem(String name) {
            super(name);
            this.xOffset = 0;
        }

        @Override
        public void updateColor(NBTParser.BaseNode node) {
            if (this.findNode(node) != null) {
                this.color = -11184811;
                this.hoverColor = -12566464;
            } else {
                this.color = -8355712;
                this.hoverColor = -10461008;
            }
        }

        @Override
        public void click(boolean isRightClick, boolean doubleClicked, int mx) {
            NBTParser.BaseNode node = this.findNode(NBTEditor.this.nbtData);
            if (node != null) {
                if (node.invalid != null) {
                    NBTEditor.this.textField.setCursorPosition(isRightClick ? node.position : node.invalidPosition);
                } else if (doubleClicked) {
                    NBTEditor.this.textField.setCursorPosition(node.position + node.value.length());
                    NBTEditor.this.textField.setSelectionPosition(node.position);
                } else {
                    NBTEditor.this.textField.setCursorPosition(node.position + (isRightClick ? node.value.length() : 0));
                }
            } else if (doubleClicked) {
                node = this.createParentNodes(this.getBaseTag());
                if (node == null) {
                    new Translatable("problem.nbtinsertfailed", new Object[0]).log(null);
                    return;
                }
                String s = NBTEditor.this.textField.getText();
                NBTEditor.this.textField.setText(s.substring(0, node.position + 1) + this.getRepresentation() + "," + s.substring(node.position + 1));
                NBTEditor.this.updateNBT();
                NBTEditor.this.nbtList.updateData();
                node = this.findNode(NBTEditor.this.nbtData);
                if (node != null) {
                    NBTEditor.this.textField.setCursorPosition(node.position);
                }
            }
        }

        public abstract NBTParser.BaseNode findParentNode(NBTParser.BaseNode var1);

        public abstract boolean matches(NBTParser.BaseNode var1);

        public abstract NBTParser.BaseNode createParentNodes(NBTParser.BaseNode var1);

        public abstract String getRepresentation();

        public final NBTParser.CompoundNode findCompoundTag(NBTParser.BaseNode parent, String name) {
            if (!(parent instanceof NBTParser.CompoundNode)) {
                return null;
            }
            for (NBTParser.BaseNode n : ((NBTParser.CompoundNode)parent).nodes) {
                if (!n.name.equals(name) || !(n instanceof NBTParser.CompoundNode)) continue;
                return (NBTParser.CompoundNode)n;
            }
            return null;
        }

        public final NBTParser.CompoundNode findOrCreateParentTag(NBTParser.BaseNode node, String name, String value) {
            if (!(node instanceof NBTParser.CompoundNode)) {
                return null;
            }
            for (NBTParser.BaseNode n : ((NBTParser.CompoundNode)node).nodes) {
                if (!n.name.equals(name) || !(n instanceof NBTParser.CompoundNode)) continue;
                return (NBTParser.CompoundNode)n;
            }
            String s = NBTEditor.this.textField.getText();
            NBTEditor.this.textField.setText(s.substring(0, node.position + 1) + name + ":" + value + "," + s.substring(node.position + 1));
            return new NBTParser.CompoundNode(name, node.position + name.length() + 2, "");
        }

        private NBTParser.CompoundNode getBaseTag() {
            String s = NBTEditor.this.textField.getText();
            int t = s.indexOf("{");
            if (t < 0) {
                NBTEditor.this.textField.setText("{}");
                return new NBTParser.CompoundNode("Overview", 0, "{}");
            }
            if (NBTEditor.this.nbtData instanceof NBTParser.CompoundNode) {
                return (NBTParser.CompoundNode)NBTEditor.this.nbtData;
            }
            return null;
        }

        public final NBTParser.BaseNode findNode(NBTParser.BaseNode node) {
            if ((node = this.findParentNode(node)) == null || !(node instanceof NBTParser.CompoundNode)) {
                return null;
            }
            for (NBTParser.BaseNode e : ((NBTParser.CompoundNode)node).nodes) {
                if (!this.matches(e)) continue;
                return e;
            }
            return null;
        }
    }

    private class NBTTitleItem
    extends NBTCustomItem {
        public boolean on;
        public NBTTitleItem parent;
        public String key;
        public String value;
        private ArrayList<NBTValue> values;

        public NBTTitleItem(NBTTitleItem parent, String name, String key, String value) {
            super(name);
            this.on = false;
            this.values = new ArrayList();
            this.parent = parent;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean matches(NBTParser.BaseNode node) {
            return node.name.equals(this.key);
        }

        @Override
        public NBTParser.BaseNode findParentNode(NBTParser.BaseNode node) {
            if (this.parent != null) {
                return this.findCompoundTag(this.parent.findParentNode(node), this.parent.key);
            }
            return node;
        }

        @Override
        public NBTParser.BaseNode createParentNodes(NBTParser.BaseNode node) {
            if (this.parent != null) {
                node = this.parent.createParentNodes(node);
                return this.findOrCreateParentTag(node, this.parent.key, this.parent.value);
            }
            return node;
        }

        @Override
        public String getRepresentation() {
            return this.key + ":" + this.value;
        }

        public NBTValue add(NBTValue value) {
            value.xOffset = this.xOffset + 3;
            this.values.add(value);
            return value;
        }

        public NBTValue add(String name, String key, String value) {
            return this.add(new NestedNBTValue(this, name, key, value));
        }

        public void addToList(ArrayList<NBTValue> valueList) {
            valueList.add(this);
            if (!this.on) {
                return;
            }
            for (NBTValue n : this.values) {
                if (n instanceof NBTTitle) {
                    ((NBTTitle)n).addToList(valueList);
                    continue;
                }
                if (n instanceof NBTTitleItem) {
                    ((NBTTitleItem)n).addToList(valueList);
                    continue;
                }
                valueList.add(n);
            }
        }

        @Override
        public void click(boolean isRightClick, boolean doubleClicked, int mx) {
            boolean exists;
            boolean bl = exists = this.findNode(NBTEditor.this.nbtData) != null;
            if (mx < this.xOffset + 5 || !exists && !doubleClicked || doubleClicked && !isRightClick && exists) {
                this.on = !this.on;
                NBTEditor.this.updateNBTValues();
                if (this.on) {
                    NBTEditor.this.nbtList.ensureRangeIsVisible(((NBTEditor)NBTEditor.this).nbtList.rowClicked, ((NBTEditor)NBTEditor.this).nbtList.rowClicked + this.values.size());
                }
            } else {
                super.click(isRightClick, doubleClicked, mx);
                this.on = true;
                NBTEditor.this.updateNBTValues();
                if (this.on) {
                    NBTEditor.this.nbtList.ensureRangeIsVisible(((NBTEditor)NBTEditor.this).nbtList.rowClicked, ((NBTEditor)NBTEditor.this).nbtList.rowClicked + this.values.size());
                } else {
                    NBTEditor.this.nbtList.ensureRangeIsVisible(((NBTEditor)NBTEditor.this).nbtList.rowClicked, ((NBTEditor)NBTEditor.this).nbtList.rowClicked);
                }
            }
        }
    }

    private class NBTTitle
    extends NBTValue {
        public boolean on;
        private ArrayList<NBTValue> values;

        public NBTTitle(String name) {
            super(name);
            this.on = false;
            this.values = new ArrayList();
            this.xOffset = 0;
        }

        public NBTValue add(NBTValue value) {
            value.xOffset = this.xOffset + 3;
            this.values.add(value);
            return value;
        }

        public void addToList(ArrayList<NBTValue> valueList) {
            valueList.add(this);
            if (!this.on) {
                return;
            }
            for (NBTValue n : this.values) {
                if (n instanceof NBTTitle) {
                    ((NBTTitle)n).addToList(valueList);
                    continue;
                }
                if (n instanceof NBTTitleItem) {
                    ((NBTTitleItem)n).addToList(valueList);
                    continue;
                }
                valueList.add(n);
            }
        }

        @Override
        public void click(boolean isRightClick, boolean doubleClicked, int mx) {
            this.on = !this.on;
            NBTEditor.this.updateNBTValues();
            if (this.on) {
                NBTEditor.this.nbtList.ensureRangeIsVisible(((NBTEditor)NBTEditor.this).nbtList.rowClicked, ((NBTEditor)NBTEditor.this).nbtList.rowClicked + this.values.size());
            }
        }
    }

    private class NBTNode
    extends NBTValue {
        public boolean on;
        public ArrayList<NBTNode> values;
        private NBTParser.BaseNode node;

        public NBTNode(NBTParser.BaseNode node, int xOffset) {
            super(node.name);
            this.on = false;
            this.node = node;
            this.xOffset = xOffset;
            if (node instanceof NBTParser.CompoundNode) {
                this.values = new ArrayList();
                for (NBTParser.BaseNode n : ((NBTParser.CompoundNode)node).nodes) {
                    NBTNode value = new NBTNode(n, xOffset + 3);
                    this.values.add(value);
                }
            }
            this.tooltip = node.invalid;
        }

        public void addToList(ArrayList<NBTValue> valueList) {
            valueList.add(this);
            if (!this.on || this.values == null) {
                return;
            }
            for (NBTNode n : this.values) {
                n.addToList(valueList);
            }
        }

        public void updateFrom(NBTNode n) {
            if (n == null || n.node == null) {
                return;
            }
            if (n.node.name.equals(this.node.name)) {
                this.on = n.on;
                if (this.values != null && n.values != null) {
                    for (NBTNode a : this.values) {
                        for (NBTNode b : n.values) {
                            if (a.node == null || b.node == null || !a.node.name.equals(b.node.name)) continue;
                            a.updateFrom(b);
                        }
                    }
                }
            }
        }

        @Override
        public void updateColor(NBTParser.BaseNode n) {
            if (this.node.invalid != null) {
                this.color = -43691;
                this.hoverColor = -53200;
            } else {
                this.color = -11184811;
                this.hoverColor = -12566352;
            }
        }

        @Override
        public void click(boolean isRightClick, boolean doubleClicked, int mx) {
            int pos;
            int n = doubleClicked ? this.node.position : (pos = this.node.position + (isRightClick ? this.node.value.length() : 0));
            if (this.node.invalid != null) {
                int n2 = pos = isRightClick ? this.node.position : this.node.invalidPosition;
            }
            if (!(this.values == null || mx >= this.xOffset + 5 && (doubleClicked || this.on && NBTEditor.this.textField.getCursorPosition() != pos))) {
                this.on = !this.on;
                NBTEditor.this.updateNBTValues();
                if (this.on) {
                    NBTEditor.this.nbtList.ensureRangeIsVisible(((NBTEditor)NBTEditor.this).nbtList.rowClicked, ((NBTEditor)NBTEditor.this).nbtList.rowClicked + this.values.size());
                }
            } else if (this.node.invalid == null && doubleClicked) {
                NBTEditor.this.textField.setCursorPosition(this.node.position + this.node.value.length());
                NBTEditor.this.textField.setSelectionPosition(this.node.position);
            } else {
                NBTEditor.this.textField.setCursorPosition(pos);
            }
        }
    }

    private abstract class NBTValue {
        public String name;
        public String tooltip;
        public int xOffset = 5;
        public int color = -8947849;
        public int hoverColor = -11184811;

        public NBTValue(String name) {
            this.name = name;
            this.tooltip = null;
        }

        public NBTValue setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public void updateColor(NBTParser.BaseNode node) {
        }

        public abstract void click(boolean var1, boolean var2, int var3);
    }
}

