/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.ContainerList;
import brad16840.common.gui.RadioButtonGroup;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import brad16840.common.permissions.gui.ClientState;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class PlayerView
extends StackableContainer {
    public int selectedRow;
    public int selectedGroup;
    public int displayedGroup;
    public boolean editingOwner;
    @SideOnly(value=Side.CLIENT)
    private ContainerList list;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup moderatorTab;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup groupTab;
    public ClientState.PermissionPlayerData data;
    private int[] storedScrollPos = new int[3];
    public boolean needsUpdating = false;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/permission_player.png");

    public PlayerView(ClientState.PermissionPlayerData data) {
        super(176, 192);
        this.data = data;
        this.selectedRow = -1;
        this.displayedGroup = 0;
        this.selectedGroup = 0;
    }

    public boolean refreshData(EntityPlayer player) {
        if (!this.needsUpdating || player.field_70170_p.field_72995_K) {
            return true;
        }
        PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
        int allowState = -1;
        if (PermissionGroup.isOp(p)) {
            allowState = p.isModerator(p) ? 1 : 0;
        }
        ClientState.PermissionPlayerData playerData = new ClientState.PermissionPlayerData(allowState, new ClientState.PermissionGroupState(player.func_70005_c_(), true));
        PermissionData data = PermissionData.get(player.field_70170_p);
        data.loadAllPermissions(player.field_70170_p);
        for (PermissionGroup group : PermissionData.groups.values()) {
            if (group instanceof PermissionPlayer || group == null) continue;
            if (group.isOwner(p)) {
                playerData.owner.add(new ClientState.PermissionGroupState(group, true));
                continue;
            }
            if (group.canEdit(p)) {
                playerData.admin.add(new ClientState.PermissionGroupState(group, group.canView(p, false)));
                continue;
            }
            if (!group.canUse(p)) continue;
            playerData.member.add(new ClientState.PermissionGroupState(group, group.canView(p, false)));
        }
        Collections.sort(playerData.owner);
        Collections.sort(playerData.admin);
        Collections.sort(playerData.member);
        this.data = playerData;
        Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientPlayer(this.container.stacks[this.stackId].size() - 1, playerData));
        this.updateScreen();
        return true;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return this.refreshData(player);
    }

    public boolean viewItem(EntityPlayer player, String type, String uuid) {
        UniqueItem.ContainerItem item = UniqueItem.getContainerType(type);
        if (item instanceof UniqueItem.ViewableItem) {
            this.container.addContainer(player, null, ((UniqueItem.ViewableItem)((Object)item)).viewItem(player, uuid, 0));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void openGroup() {
        ClientState.PermissionGroupState selectedGroup = this.getSelectedGroup();
        if (selectedGroup != null && selectedGroup.canView && (selectedGroup.id.startsWith("G_") || selectedGroup.id.startsWith("I_"))) {
            UniqueItemData data;
            NBTTagCompound tag;
            if (selectedGroup.id.startsWith("I_") && !selectedGroup.id.startsWith("I_@") && (tag = (data = UniqueItemData.get((World)Minecraft.func_71410_x().field_71441_e)).getItemData(selectedGroup.name, false)) != null && tag.func_74764_b("inventory") && tag.func_74775_l("inventory").func_74764_b("container-type")) {
                String type = tag.func_74775_l("inventory").func_74779_i("container-type");
                int stackPos = this.stackId;
                if (this.viewItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, selectedGroup.name)) {
                    Common.channel.sendToServer(new PacketHandler.ViewItem(stackPos, type, selectedGroup.name));
                    return;
                }
            }
            Common.channel.sendToServer(new PacketHandler.OpenGroup(0, selectedGroup, true));
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ClientState.PermissionGroupState getSelectedGroup() {
        ClientState.PermissionGroupState selectedGroup = null;
        if (this.selectedGroup == 0) {
            if (this.selectedRow < this.data.owner.size()) {
                selectedGroup = this.data.owner.get(this.selectedRow);
            }
        } else if (this.selectedGroup == 1) {
            if (this.selectedRow < this.data.admin.size()) {
                selectedGroup = this.data.admin.get(this.selectedRow);
            }
        } else if (this.selectedRow < this.data.member.size()) {
            selectedGroup = this.data.member.get(this.selectedRow);
        }
        return selectedGroup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        int yShift = this.data.allowState < 0 ? 20 : 0;
        this.list = new ContainerList(this, 7, 38 - yShift, 161, 123 + yShift, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                if (PlayerView.this.displayedGroup == 0) {
                    return PlayerView.this.data.owner.size();
                }
                if (PlayerView.this.displayedGroup == 1) {
                    return PlayerView.this.data.admin.size();
                }
                return PlayerView.this.data.member.size();
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                ClientState.PermissionGroupState group;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean selected = PlayerView.this.displayedGroup == PlayerView.this.selectedGroup && PlayerView.this.selectedRow == row;
                int color1 = -3092272;
                int color2 = -3092416;
                int color3 = -12566352;
                if (hovered || selected) {
                    color1 = -8355712;
                    color2 = -12566320;
                }
                if (PlayerView.this.displayedGroup == 0) {
                    if (row >= PlayerView.this.data.owner.size()) {
                        return;
                    }
                    group = PlayerView.this.data.owner.get(row);
                } else if (PlayerView.this.displayedGroup == 1) {
                    if (row >= PlayerView.this.data.admin.size()) {
                        return;
                    }
                    group = PlayerView.this.data.admin.get(row);
                } else {
                    if (row >= PlayerView.this.data.member.size()) {
                        return;
                    }
                    group = PlayerView.this.data.member.get(row);
                }
                boolean isOpenable = group != null && group.canView && (group.id.startsWith("G_") || group.id.startsWith("I_"));
                String name = group.name;
                if (group.id.startsWith("I_")) {
                    if (group.id.startsWith("I_@")) {
                        int o = group.name.indexOf(";");
                        name = new Translatable("gui.permissionlist.block", group.name.substring(6, o), group.name.substring(o + 7)).translate();
                    } else {
                        name = group.name.substring(0, 13).toUpperCase();
                    }
                }
                PlayerView.this.gui.text(this.container, (isOpenable && (hovered || selected) ? "\u00a7n" : "") + name).truncateString(width).drawCenteredString(x + width / 2, y + 1, group.id.startsWith("G_") || group.id.startsWith("S_") ? -7339808 : color2);
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean selected = PlayerView.this.displayedGroup == PlayerView.this.selectedGroup && PlayerView.this.selectedRow == row;
                int height = 10;
                boolean flag = false;
                PlayerView.this.gui.drawRectangle(this.container, x, y, x + width, y + height, selected ? -14751714 : (hovered ? -8850318 : -7631989));
                if (selected) {
                    PlayerView.this.gui.drawHorizontalLine(this.container, x, x + width, y - 1, flag ? -14751714 : -14630848);
                    PlayerView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -14630848);
                } else {
                    PlayerView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -6250336);
                }
            }

            @Override
            public int getRowHeight(int slot) {
                return 11;
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (PlayerView.this.displayedGroup == PlayerView.this.selectedGroup && (doubleClicked || PlayerView.this.selectedRow == row)) {
                    PlayerView.this.openGroup();
                }
                PlayerView.this.selectedGroup = PlayerView.this.displayedGroup;
                PlayerView.this.selectedRow = row;
            }
        });
        this.list.topOffset = 17;
        this.moderatorTab = new RadioButtonGroup(66, 18, 16, new RadioButtonGroup.RadioButtons(){

            @Override
            public int size() {
                return 2;
            }

            @Override
            public int getButtonWidth(int i) {
                return 51;
            }

            @Override
            public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
                PlayerView.this.gui.text(PlayerView.this, new Translatable("button.moderator" + (button == 0 ? "on" : "off"), new Object[0]).translate()).truncateString(width).drawCenteredString(x + (width + 1) / 2, y + 5, -11184811);
            }

            @Override
            public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
                int state = PlayerView.this.data.allowState == 1 - button ? 0 : (my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
                PlayerView.this.gui.bindTexture(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                PlayerView.this.gui.drawTexture(PlayerView.this, x + 1, y + 1, width - 1, height - 1, PlayerView.this.guiWidth, state * (height - 1));
            }

            @Override
            public void buttonClicked(int i) {
                Common.channel.sendToServer(new PacketHandler.ModeratePlayer(i == 0));
            }
        });
        this.groupTab = new RadioButtonGroup(7, 38 - yShift, 17, new RadioButtonGroup.RadioButtons(){

            @Override
            public int size() {
                return 3;
            }

            @Override
            public int getButtonWidth(int i) {
                return 47;
            }

            @Override
            public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
                PlayerView.this.gui.text(PlayerView.this, new Translatable("button.show" + (button == 0 ? "owner" : (button == 1 ? "admin" : "member")), new Object[0]).translate()).truncateString(width).drawCenteredString(x + (width + 1) / 2, y + 5, -11184811);
            }

            @Override
            public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
                int state = PlayerView.this.displayedGroup == button ? 0 : (my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
                PlayerView.this.gui.bindTexture(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                PlayerView.this.gui.drawTexture(PlayerView.this, x + 1, y + 1, width - 1, height - 1, PlayerView.this.guiWidth, 45 + state * (height - 1));
            }

            @Override
            public void buttonClicked(int i) {
                PlayerView.this.setDisplayedGroup(i);
            }
        });
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 7, 165, 162, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                PlayerView.this.gui.closeContainer(PlayerView.this.stackId);
            }
        }));
        this.list.scrollPos = this.storedScrollPos[this.displayedGroup];
        this.list.addButtons();
        if (!this.needsUpdating && this.displayedGroup == this.selectedGroup) {
            this.list.scrollToVisible(this.selectedRow);
        }
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient() && this.list != null) {
            this.storedScrollPos[this.displayedGroup] = this.list.scrollPos;
        }
        this.needsUpdating = true;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, this.data.player.name).truncateString(160).drawCenteredString(86, 7, -12566352);
        this.gui.text(this, new Translatable("gui.playerpermission.moderator", new Object[0]).translate()).truncateString(160).truncateString(58).drawString(8, 23, -11184811);
        this.list.drawForeground(x, y);
        this.groupTab.drawForeground(x, y);
        if (this.data.allowState >= 0) {
            this.moderatorTab.drawForeground(x, y);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        if (this.data.allowState < 0) {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
            this.gui.drawTexture(this, 0, 18, this.guiWidth, 42, 0, 38);
        } else {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        }
        this.list.drawBackground(x, y);
        this.groupTab.drawBackground(x, y);
        if (this.data.allowState >= 0) {
            this.moderatorTab.drawBackground(x, y);
        }
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getRowSize() {
        return 0;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setDisplayedGroup(int group) {
        if (!this.isClient()) {
            this.displayedGroup = group;
            return;
        }
        this.storedScrollPos[this.displayedGroup] = this.list.scrollPos;
        this.displayedGroup = group;
        this.list.scrollPos = this.storedScrollPos[group];
        this.list.updateData();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        return this.list.mouseWheel(x, y, wheel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0) {
            if (this.list.mouseDown(x, y)) {
                return true;
            }
            if (this.groupTab.mouseDown(x, y)) {
                return true;
            }
            if (this.data.allowState >= 0 && this.moderatorTab.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        return this.list.mouseDragged(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return this.list.mouseUp(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.list.updateData();
            this.gui.func_73876_c();
        }
    }
}

