/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.gui.ContainerList;
import brad16840.common.gui.RadioButtonGroup;
import brad16840.common.gui.TitledImageButton;
import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import brad16840.common.permissions.gui.ClientState;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RuleView
extends StackableContainer {
    public int selectedRow;
    public boolean playerListSelected;
    public boolean playerListDisplayed;
    public boolean isAllowed;
    public boolean hideRuleButtons;
    public boolean editingOwner;
    @SideOnly(value=Side.CLIENT)
    public ContainerList list;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup allowedTab;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup groupTab;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton acceptButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton addButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField textbox;
    public int ruleId;
    public ClientState.PermissionGroups groups;
    private String screenTitle = new Translatable("gui.permissionrule.title.create", new Object[0]).translate();
    private int playerScrollPos = 0;
    private int groupScrollPos = 0;
    public boolean needsUpdating = false;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/permission_rule.png");
    public RuleSource source;

    public RuleView(RuleSource source, ClientState.PermissionGroups groups, int ruleId) {
        super(176, 192);
        this.source = source;
        this.groups = groups;
        this.ruleId = ruleId;
        this.selectedRow = -1;
        if (groups.defaultGroup != null) {
            if (groups.players.contains(groups.defaultGroup)) {
                this.selectedRow = groups.players.indexOf(groups.defaultGroup);
                this.playerListDisplayed = true;
                this.playerListSelected = true;
            } else if (groups.groups.contains(groups.defaultGroup)) {
                this.selectedRow = groups.groups.indexOf(groups.defaultGroup);
                this.playerListDisplayed = false;
                this.playerListSelected = false;
            }
        }
        this.hideRuleButtons = false;
        this.isAllowed = true;
        if (groups.allowState < 0) {
            this.screenTitle = new Translatable("gui.permissionrule.title.create", new Object[0]).translate();
            this.isAllowed = groups.allowState == -1;
        } else if (groups.allowState < 2) {
            this.screenTitle = new Translatable("gui.permissionrule.title.edit", new Object[0]).translate();
            this.isAllowed = groups.allowState == 1;
        } else if (groups.allowState < 4) {
            this.hideRuleButtons = true;
            this.editingOwner = groups.allowState == 2;
            this.screenTitle = new Translatable("gui.permissionrule.title.edit" + (this.editingOwner ? "owner" : "defaultto"), new Object[0]).translate();
        }
    }

    public boolean refreshData(EntityPlayer player) {
        if (!this.needsUpdating || player.field_70170_p.field_72995_K) {
            return true;
        }
        PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
        if (!this.source.stillValid(player.field_70170_p, p)) {
            Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientRule(this.container.stacks[this.stackId].size() - 1, null));
            return false;
        }
        ClientState.PermissionGroupState g = this.groups.defaultGroup;
        ClientState.PermissionGroups groups = new ClientState.PermissionGroups();
        PermissionData data = PermissionData.get(player.field_70170_p);
        data.loadAllPermissions(player.field_70170_p);
        boolean foundDefault = g == null;
        for (PermissionGroup group : PermissionData.groups.values()) {
            if (group instanceof ItemPermission) continue;
            boolean e = foundDefault;
            if (!foundDefault && group != null && group.getId().equals(g.id)) {
                foundDefault = true;
            }
            if (group instanceof PermissionPlayer) {
                groups.players.add(new ClientState.PermissionGroupState(group, false));
                continue;
            }
            if (group instanceof PermissionGroup.SpecialPermissionGroup) {
                groups.groups.add(new ClientState.PermissionGroupState(group, false));
                continue;
            }
            if (group.canView(p, false)) {
                groups.groups.add(new ClientState.PermissionGroupState(group, true));
                continue;
            }
            foundDefault = e;
        }
        if (!foundDefault) {
            if (g.id.startsWith("P_")) {
                groups.players.add(g);
            } else {
                groups.groups.add(g);
            }
        }
        Collections.sort(groups.groups);
        Collections.sort(groups.players);
        groups.player = this.groups.player;
        this.groups.groups = groups.groups;
        this.groups.players = groups.players;
        this.updateScreen();
        Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientRule(this.container.stacks[this.stackId].size() - 1, groups));
        return true;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return this.refreshData(player);
    }

    @SideOnly(value=Side.CLIENT)
    public void openGroup() {
        ClientState.PermissionGroupState selectedGroup = this.getSelectedGroup();
        if (selectedGroup != null && selectedGroup.id.equals("P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            Common.channel.sendToServer(new PacketHandler.OpenPlayer());
            return;
        }
        if (selectedGroup == null || !selectedGroup.canView || !selectedGroup.id.startsWith("G_")) {
            return;
        }
        Common.channel.sendToServer(new PacketHandler.OpenGroup(0, selectedGroup, true));
    }

    @SideOnly(value=Side.CLIENT)
    private ClientState.PermissionGroupState getSelectedGroup() {
        ClientState.PermissionGroupState selectedGroup = null;
        if (this.playerListSelected) {
            if (this.selectedRow < this.groups.players.size()) {
                selectedGroup = this.groups.players.get(this.selectedRow);
            }
        } else if (this.selectedRow < this.groups.groups.size()) {
            selectedGroup = this.groups.groups.get(this.selectedRow);
        }
        return selectedGroup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        int yShift = this.hideRuleButtons ? 20 : 0;
        this.list = new ContainerList(this, 7, 38 - yShift, 161, 123 + yShift, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                if (RuleView.this.playerListDisplayed) {
                    return RuleView.this.groups.players.size();
                }
                return RuleView.this.groups.groups.size();
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                boolean isOpenable;
                ClientState.PermissionGroupState group;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean selected = RuleView.this.playerListDisplayed == RuleView.this.playerListSelected && RuleView.this.selectedRow == row;
                int color1 = -3092272;
                int color2 = -3092416;
                int color3 = -12566352;
                if (hovered || selected) {
                    color1 = -8355712;
                    if (!selected) {
                        color2 = -8355712;
                    }
                }
                if (RuleView.this.playerListDisplayed) {
                    if (row >= RuleView.this.groups.players.size()) {
                        return;
                    }
                    group = RuleView.this.groups.players.get(row);
                } else {
                    if (row >= RuleView.this.groups.groups.size()) {
                        return;
                    }
                    group = RuleView.this.groups.groups.get(row);
                }
                boolean bl = isOpenable = group != null && group.canView && group.id.startsWith("G_");
                if (group != null && group.id.equals("P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                    isOpenable = true;
                }
                RuleView.this.gui.text(this.container, (isOpenable && (hovered || selected) ? "\u00a7n" : "") + group.name).truncateString(width).drawCenteredString(x + width / 2, y + 1, group.id.startsWith("G_") || group.id.startsWith("S_") ? -7339808 : color3);
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean selected = RuleView.this.playerListDisplayed == RuleView.this.playerListSelected && RuleView.this.selectedRow == row;
                int height = 10;
                boolean flag = false;
                RuleView.this.gui.drawRectangle(this.container, x, y, x + width, y + height, selected ? -14751714 : (hovered ? -8850318 : -7631989));
                if (selected) {
                    RuleView.this.gui.drawHorizontalLine(this.container, x, x + width, y - 1, flag ? -14751714 : -14630848);
                    RuleView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -14630848);
                } else {
                    RuleView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -6250336);
                }
            }

            @Override
            public int getRowHeight(int slot) {
                return 11;
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (RuleView.this.playerListSelected == RuleView.this.playerListDisplayed && (doubleClicked || RuleView.this.selectedRow == row)) {
                    RuleView.this.openGroup();
                }
                RuleView.this.setSelection(RuleView.this.playerListDisplayed, row);
            }
        });
        this.list.topOffset = 17;
        this.list.bottomOffset = 17;
        this.allowedTab = new RadioButtonGroup(7, 18, 16, new RadioButtonGroup.RadioButtons(){

            @Override
            public int size() {
                return 2;
            }

            @Override
            public int getButtonWidth(int i) {
                return 81 - i;
            }

            @Override
            public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
                RuleView.this.gui.text(RuleView.this, new Translatable("button." + (button == 0 ? "allow" : "deny"), new Object[0]).translate()).truncateString(width).drawCenteredString(x + 1 + width / 2, y + 5, -11184811);
            }

            @Override
            public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
                int state = RuleView.this.isAllowed == (button == 0) ? 0 : (my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
                RuleView.this.gui.bindTexture(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RuleView.this.gui.drawTexture(RuleView.this, x + 1, y + 1, width - 1, height - 1, RuleView.this.guiWidth, (button * 3 + state) * (height - 1));
            }

            @Override
            public void buttonClicked(int i) {
                RuleView.this.isAllowed = i == 0;
            }
        });
        this.groupTab = new RadioButtonGroup(7, 38 - yShift, 17, new RadioButtonGroup.RadioButtons(){

            @Override
            public int size() {
                return 2;
            }

            @Override
            public int getButtonWidth(int i) {
                return 71;
            }

            @Override
            public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
                RuleView.this.gui.text(RuleView.this, new Translatable("button." + (button == 0 ? "groups" : "players"), new Object[0]).translate()).truncateString(width).drawCenteredString(x + (width + 1) / 2, y + 5, -11184811);
            }

            @Override
            public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
                int state = RuleView.this.playerListDisplayed == (button == 1) ? 0 : (my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
                RuleView.this.gui.bindTexture(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RuleView.this.gui.drawTexture(RuleView.this, x + 1, y + 1, width - 1, height - 1, RuleView.this.guiWidth, 90 + (button * 3 + state) * (height - 1));
            }

            @Override
            public void buttonClicked(int i) {
                RuleView.this.setDisplayedList(i == 1);
                RuleView.this.setSelection(RuleView.this.playerListSelected, RuleView.this.selectedRow);
            }
        });
        this.textbox = this.gui.addTextField(5, this, 10, 148, 111, 13);
        this.textbox.setMaxStringLength(60);
        this.textbox.setText("");
        this.addButton = new TitledImageButton(this, new Translatable("button.add", new Object[0]).translate(), 3, 118, 144, 31, 18, texture, 0, this.guiHeight);
        this.gui.addButton(this.addButton);
        this.acceptButton = new StackableContainer.ContainerButton(this, 1, 7, 165, 80, 20, new Translatable("button.accept", new Object[0]).translate());
        this.gui.addButton(this.acceptButton);
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 89, 165, 80, 20, new Translatable("button.cancel", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                RuleView.this.gui.closeContainer(RuleView.this.stackId);
            }
        }));
        this.setSelection(this.playerListSelected, this.selectedRow);
        this.list.scrollPos = this.playerListDisplayed ? this.playerScrollPos : this.groupScrollPos;
        this.list.addButtons();
        if (!this.needsUpdating && this.playerListDisplayed == this.playerListSelected) {
            this.list.scrollToVisible(this.selectedRow);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == 28 && this.textbox.isFocused()) {
            this.actionPerformed(this.addButton);
            return true;
        }
        return this.textbox.keyPressed(key, keyCode);
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            if (this.list != null) {
                if (this.playerListDisplayed) {
                    this.playerScrollPos = this.list.scrollPos;
                } else {
                    this.groupScrollPos = this.list.scrollPos;
                }
            }
            Keyboard.enableRepeatEvents((boolean)false);
        }
        this.needsUpdating = true;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, ChatFormatting.DARK_GRAY + this.screenTitle).truncateString(160).drawCenteredString(86, 7, -13158601);
        this.list.drawForeground(x, y);
        this.groupTab.drawForeground(x, y);
        if (!this.hideRuleButtons) {
            this.allowedTab.drawForeground(x, y);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        if (this.hideRuleButtons) {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
            this.gui.drawTexture(this, 0, 18, this.guiWidth, 42, 0, 38);
        } else {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        }
        this.list.drawBackground(x, y);
        this.groupTab.drawBackground(x, y);
        if (!this.hideRuleButtons) {
            this.allowedTab.drawBackground(x, y);
        }
        GL11.glDisable((int)2896);
        this.textbox.drawBackground();
        if (!this.textbox.isFocused() && this.textbox.getText().isEmpty()) {
            this.gui.text(this, new Translatable("gui.permissionrule.add." + (this.playerListDisplayed ? "player" : "group"), new Object[0]).translate()).drawString(this.textbox.xPos + 1, this.textbox.yPos + 1, -2500135);
        }
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getRowSize() {
        return 0;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setDisplayedList(boolean playerList) {
        if (!this.isClient()) {
            this.playerListDisplayed = playerList;
            return;
        }
        if (this.playerListDisplayed) {
            this.playerScrollPos = this.list.scrollPos;
        } else {
            this.groupScrollPos = this.list.scrollPos;
        }
        this.playerListDisplayed = playerList;
        this.list.scrollPos = this.playerListDisplayed ? this.playerScrollPos : this.groupScrollPos;
        this.list.updateData();
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelection(boolean playerListSelected, int pos) {
        this.playerListSelected = playerListSelected;
        this.selectedRow = pos;
        this.acceptButton.field_146124_l = this.playerListDisplayed == playerListSelected && this.selectedRow >= 0 && this.selectedRow < (playerListSelected ? this.groups.players : this.groups.groups).size();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        return this.list.mouseWheel(x, y, wheel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0) {
            if (this.list.mouseDown(x, y)) {
                return true;
            }
            if (this.groupTab.mouseDown(x, y)) {
                return true;
            }
            if (!this.hideRuleButtons && this.allowedTab.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        return this.list.mouseDragged(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return this.list.mouseUp(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.addButton.field_146127_k) {
                String text = this.textbox.getText();
                if (text != null && text.length() > 0) {
                    if (this.playerListDisplayed) {
                        for (int i = 0; i < this.groups.players.size(); ++i) {
                            if (!this.groups.players.get((int)i).name.equals(text)) continue;
                            this.setSelection(true, i);
                            this.list.scrollToVisible(i);
                            return;
                        }
                        ClientState.PermissionGroupState group = new ClientState.PermissionGroupState(text, true);
                        this.groups.players.add(group);
                        Common.channel.sendToServer(new PacketHandler.CreateGroup(group, true));
                    } else {
                        for (int i = 0; i < this.groups.groups.size(); ++i) {
                            if (!this.groups.groups.get((int)i).name.equals(text)) continue;
                            this.setSelection(false, i);
                            this.list.scrollToVisible(i);
                            return;
                        }
                        ClientState.PermissionGroupState group = new ClientState.PermissionGroupState(text, false);
                        this.groups.groups.add(group);
                        Common.channel.sendToServer(new PacketHandler.CreateGroup(group, false));
                    }
                    this.gui.func_73876_c();
                }
            } else if (button.field_146127_k == this.acceptButton.field_146127_k) {
                this.source.accept((this.playerListSelected ? this.groups.players : this.groups.groups).get(this.selectedRow), this.isAllowed, this.ruleId);
                this.gui.closeContainer(this.stackId);
            }
        }
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.list.updateData();
            this.gui.func_73876_c();
        }
    }

    public static interface RuleSource {
        public void accept(ClientState.PermissionGroupState var1, boolean var2, int var3);

        public boolean stillValid(World var1, PermissionPlayer var2);
    }
}

