/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions;

import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.command.CommandTeleportJED;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.event.GamemodeTracker;
import fi.dy.masa.justenoughdimensions.network.DimensionSyncChannelHandler;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.proxy.IProxy;
import fi.dy.masa.justenoughdimensions.world.util.WorldBorderUtils;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.util.EnumMap;
import net.minecraft.command.ICommand;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="justenoughdimensions", name="Just Enough Dimensions", version="1.5.4", guiFactory="fi.dy.masa.justenoughdimensions.config.JustEnoughDimensionsGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/justenoughdimensions/master/update.json", acceptedMinecraftVersions="[1.10,1.10.2]")
public class JustEnoughDimensions {
    @Mod.Instance(value="justenoughdimensions")
    public static JustEnoughDimensions instance;
    @SidedProxy(clientSide="fi.dy.masa.justenoughdimensions.proxy.ClientProxy", serverSide="fi.dy.masa.justenoughdimensions.proxy.CommonProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        logger = event.getModLog();
        Configs.loadConfigsFromFile(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        proxy.registerEventHandlers();
        channels = NetworkRegistry.INSTANCE.newChannel("JEDChannel", new ChannelHandler[]{DimensionSyncChannelHandler.instance});
        DimensionConfig.create(new File(event.getModConfigurationDirectory(), "justenoughdimensions"));
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        File worldDir = new File(((AnvilSaveConverter)event.getServer().func_71254_M()).field_75808_a, event.getServer().func_71270_I());
        DimensionConfig.instance().readDimensionConfig(worldDir);
        DimensionConfig.instance().registerOverriddenDimensions();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandJED());
        event.registerServerCommand((ICommand)new CommandTeleportJED());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        WorldBorderUtils.removeDefaultBorderListeners();
        DimensionConfig.instance().registerNonOverrideDimensions();
        GamemodeTracker.getInstance().readFromDisk();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        DimensionConfig.instance().unregisterCustomDimensions();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.enableLoggingInfo) {
            logger.info(message, params);
        } else {
            logger.trace(message, params);
        }
    }
}

