/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.client.render;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;

public class SkyRenderer
extends IRenderHandler {
    private static final ResourceLocation END_SKY_TEXTURES = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private int skyRenderType;
    private boolean disableSun;
    private boolean disableMoon;
    private boolean disableStars;
    private boolean vboEnabled = OpenGlHelper.func_176075_f();
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;
    private final VertexFormat vertexBufferFormat = new VertexFormat();
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;

    public SkyRenderer(int skyRenderType, int disableFlags) {
        this.vertexBufferFormat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        this.skyRenderType = skyRenderType;
        this.disableSun = (disableFlags & 1) != 0;
        this.disableMoon = (disableFlags & 2) != 0;
        this.disableStars = (disableFlags & 4) != 0;
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.skyRenderType == 2) {
            this.renderSkyEnd(mc);
        } else {
            this.renderSkySurface(world, mc, partialTicks);
        }
    }

    protected void renderSkyEnd(Minecraft mc) {
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)false);
        mc.func_110434_K().func_110577_a(END_SKY_TEXTURES);
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vertexbuffer = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.func_179094_E();
            if (i == 1) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 2) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 3) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 4) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (i == 5) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexbuffer.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            vertexbuffer.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            vertexbuffer.func_181662_b(100.0, -100.0, 100.0).func_187315_a(16.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            vertexbuffer.func_181662_b(100.0, -100.0, -100.0).func_187315_a(16.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    protected void renderSkySurface(WorldClient world, Minecraft mc, float partialTicks) {
        GlStateManager.func_179090_x();
        Vec3d skyColor = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float r = (float)skyColor.field_72450_a;
        float g = (float)skyColor.field_72448_b;
        float b = (float)skyColor.field_72449_c;
        int pass = 2;
        if (pass != 2) {
            float f3 = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float f4 = (r * 30.0f + g * 70.0f) / 100.0f;
            float f5 = (r * 30.0f + b * 70.0f) / 100.0f;
            r = f3;
            g = f4;
            b = f5;
        }
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        if (this.vboEnabled) {
            this.skyVBO.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
            this.skyVBO.func_177358_a(7);
            this.skyVBO.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
        } else {
            GlStateManager.func_179148_o((int)this.glSkyList);
        }
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float rsr = afloat[0];
            float gsr = afloat[1];
            float bsr = afloat[2];
            if (pass != 2) {
                float f9 = (rsr * 30.0f + gsr * 59.0f + bsr * 11.0f) / 100.0f;
                float f10 = (rsr * 30.0f + gsr * 70.0f) / 100.0f;
                float f11 = (rsr * 30.0f + bsr * 70.0f) / 100.0f;
                rsr = f9;
                gsr = f10;
                bsr = f11;
            }
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(rsr, gsr, bsr, afloat[3]).func_181675_d();
            for (int l = 0; l <= 16; ++l) {
                float f21 = (float)l * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                vertexbuffer.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f16 = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f16);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        double d17 = 30.0;
        if (!this.disableSun) {
            mc.func_110434_K().func_110577_a(SUN_TEXTURES);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-d17, 100.0, -d17).func_187315_a(0.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(d17, 100.0, -d17).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(d17, 100.0, d17).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(-d17, 100.0, d17).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
        }
        if (!this.disableMoon) {
            d17 = 20.0;
            mc.func_110434_K().func_110577_a(MOON_PHASES_TEXTURES);
            int i = world.func_72853_d();
            int k = i % 4;
            int j = i / 4 % 2;
            double f22 = (double)(k + 0) / 4.0;
            double f23 = (double)(j + 0) / 2.0;
            double f24 = (double)(k + 1) / 4.0;
            double f14 = (double)(j + 1) / 2.0;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-d17, -100.0, d17).func_187315_a(f24, f14).func_181675_d();
            vertexbuffer.func_181662_b(d17, -100.0, d17).func_187315_a(f22, f14).func_181675_d();
            vertexbuffer.func_181662_b(d17, -100.0, -d17).func_187315_a(f22, f23).func_181675_d();
            vertexbuffer.func_181662_b(-d17, -100.0, -d17).func_187315_a(f24, f23).func_181675_d();
            tessellator.func_78381_a();
        }
        if (!this.disableStars) {
            GlStateManager.func_179090_x();
            float brightness = world.func_72880_h(partialTicks) * f16;
            if (brightness > 0.0f) {
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)brightness);
                if (this.vboEnabled) {
                    this.starVBO.func_177359_a();
                    GlStateManager.func_187410_q((int)32884);
                    GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                    this.starVBO.func_177358_a(7);
                    this.starVBO.func_177361_b();
                    GlStateManager.func_187429_p((int)32884);
                } else {
                    GlStateManager.func_179148_o((int)this.starGLCallList);
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            if (this.vboEnabled) {
                this.sky2VBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.sky2VBO.func_177358_a(7);
                this.sky2VBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.glSkyList2);
            }
            GlStateManager.func_179121_F();
            double d19 = -(d0 + 65.0);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(-1.0, d19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, d19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, d19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, d19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, d19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, d19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, d19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, d19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(r * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(b * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)this.glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vertexbuffer = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.func_177362_c();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.vboEnabled) {
            this.sky2VBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, -16.0f, true);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.sky2VBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.glSkyList2 = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList2, (int)4864);
            this.renderSky(vertexbuffer, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vertexbuffer = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.func_177362_c();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.vboEnabled) {
            this.skyVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, 16.0f, false);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.skyVBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.glSkyList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList, (int)4864);
            this.renderSky(vertexbuffer, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void renderSky(net.minecraft.client.renderer.VertexBuffer worldRendererIn, float posY, boolean reverseX) {
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                worldRendererIn.func_181662_b((double)f, (double)posY, (double)l).func_181675_d();
                worldRendererIn.func_181662_b((double)f1, (double)posY, (double)l).func_181675_d();
                worldRendererIn.func_181662_b((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                worldRendererIn.func_181662_b((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vertexbuffer = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.func_177362_c();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.func_74523_b((int)this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.vboEnabled) {
            this.starVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderStars(vertexbuffer);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.starVBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.starGLCallList, (int)4864);
            this.renderStars(vertexbuffer);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    private void renderStars(net.minecraft.client.renderer.VertexBuffer worldRendererIn) {
        Random random = new Random(10842L);
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                worldRendererIn.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }
}

