/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.command.utils;

import com.google.common.base.Predicates;
import fi.dy.masa.justenoughdimensions.command.CommandJED;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandJEDGameRule {
    public static void execute(CommandJED cmd, int dimension, String[] args, MinecraftServer server, ICommandSender sender) throws CommandException {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world != null) {
            String key;
            GameRules rules = world.func_82736_K();
            String string = key = args.length > 0 ? args[0] : "";
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(CommandBase.func_71527_a((Object[])rules.func_82763_b())));
            } else if (args.length == 1) {
                if (!rules.func_82765_e(key)) {
                    CommandJED.throwCommand("gamerule.norule", dimension, key);
                }
                String value = rules.func_82767_a(key);
                sender.func_145747_a((ITextComponent)new TextComponentString("DIM " + dimension + ": " + key + " = " + value));
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, rules.func_180263_c(key));
            } else {
                String value;
                String string2 = value = args.length > 1 ? CommandBase.func_180529_a((String[])args, (int)1) : "";
                if (rules.func_180264_a(key, GameRules.ValueType.BOOLEAN_VALUE) && !value.equals("true") && !value.equals("false")) {
                    CommandJED.throwCommand("boolean.invalid", value);
                }
                rules.func_82764_b(key, value);
                CommandJEDGameRule.notifyGameRuleChange(rules, key, (World)world);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)cmd, (String)"jed.commands.gamerule.success", (Object[])new Object[]{dimension, key, value});
            }
        } else {
            CommandJED.throwNumber("dimension.notloaded", dimension);
        }
    }

    static void notifyGameRuleChange(GameRules rules, String key, World world) {
        if (key.equals("reducedDebugInfo")) {
            byte opCode = (byte)(rules.func_82766_b(key) ? 22 : 23);
            for (EntityPlayerMP player : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((Entity)player, opCode));
            }
        }
    }
}

