/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.config.DimensionTypeEntry;
import fi.dy.masa.justenoughdimensions.network.MessageSyncDimensions;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import fi.dy.masa.justenoughdimensions.world.WorldProviderHellJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class DimensionConfig {
    private static DimensionConfig instance;
    private final File configDirConfigs;
    private final File dimensionConfigsFile;
    private final Set<Integer> registeredDimensions = new HashSet<Integer>();
    private final Map<Integer, DimensionConfigEntry> dimensions = new HashMap<Integer, DimensionConfigEntry>();
    private final Map<Integer, NBTTagCompound> customWorldInfo = new HashMap<Integer, NBTTagCompound>(8);
    private final Map<Integer, NBTTagCompound> onetimeWorldInfo = new HashMap<Integer, NBTTagCompound>(8);
    private final Map<String, Integer> worldInfoKeys = new HashMap<String, Integer>();
    private final Map<String, Integer> worldInfoKeysJED = new HashMap<String, Integer>();
    private final Map<String, Integer> worldInfoKeysListTypes = new HashMap<String, Integer>();
    private JsonObject dimBuilderData = new JsonObject();

    private DimensionConfig(File configDir) {
        instance = this;
        this.configDirConfigs = configDir;
        this.dimensionConfigsFile = new File(configDir, "dimensions.json");
        this.initWorldInfoKeys();
    }

    public static DimensionConfig create(File configDir) {
        return new DimensionConfig(configDir);
    }

    public static DimensionConfig instance() {
        return instance;
    }

    public List<DimensionConfigEntry> getRegisteredDimensions() {
        return ImmutableList.copyOf(this.dimensions.values());
    }

    @Nullable
    public DimensionConfigEntry getDimensionConfigFor(int dimension) {
        return this.dimensions.get(dimension);
    }

    private void initWorldInfoKeys() {
        this.worldInfoKeys.put("RandomSeed", 4);
        this.worldInfoKeys.put("generatorName", 8);
        this.worldInfoKeys.put("generatorVersion", 3);
        this.worldInfoKeys.put("generatorOptions", 8);
        this.worldInfoKeys.put("GameType", 3);
        this.worldInfoKeys.put("MapFeatures", 1);
        this.worldInfoKeys.put("SpawnX", 3);
        this.worldInfoKeys.put("SpawnY", 3);
        this.worldInfoKeys.put("SpawnZ", 3);
        this.worldInfoKeys.put("Time", 4);
        this.worldInfoKeys.put("DayTime", 4);
        this.worldInfoKeys.put("LastPlayed", 4);
        this.worldInfoKeys.put("SizeOnDisk", 4);
        this.worldInfoKeys.put("LevelName", 8);
        this.worldInfoKeys.put("version", 3);
        this.worldInfoKeys.put("clearWeatherTime", 3);
        this.worldInfoKeys.put("rainTime", 3);
        this.worldInfoKeys.put("raining", 1);
        this.worldInfoKeys.put("thunderTime", 3);
        this.worldInfoKeys.put("thundering", 1);
        this.worldInfoKeys.put("hardcore", 1);
        this.worldInfoKeys.put("initialized", 1);
        this.worldInfoKeys.put("allowCommands", 1);
        this.worldInfoKeys.put("Difficulty", 1);
        this.worldInfoKeys.put("DifficultyLocked", 1);
        this.worldInfoKeys.put("BorderCenterX", 6);
        this.worldInfoKeys.put("BorderCenterZ", 6);
        this.worldInfoKeys.put("BorderSize", 6);
        this.worldInfoKeys.put("BorderSizeLerpTime", 4);
        this.worldInfoKeys.put("BorderSizeLerpTarget", 6);
        this.worldInfoKeys.put("BorderSafeZone", 6);
        this.worldInfoKeys.put("BorderDamagePerBlock", 6);
        this.worldInfoKeys.put("BorderWarningBlocks", 3);
        this.worldInfoKeys.put("BorderWarningTime", 3);
        this.worldInfoKeysJED.put("ForceGameMode", 1);
        this.worldInfoKeysJED.put("CustomDayCycle", 1);
        this.worldInfoKeysJED.put("DayLength", 3);
        this.worldInfoKeysJED.put("NightLength", 3);
        this.worldInfoKeysJED.put("CloudHeight", 3);
        this.worldInfoKeysJED.put("SkyColor", 8);
        this.worldInfoKeysJED.put("CloudColor", 8);
        this.worldInfoKeysJED.put("FogColor", 8);
        this.worldInfoKeysJED.put("SkyRenderType", 1);
        this.worldInfoKeysJED.put("SkyDisableFlags", 1);
        this.worldInfoKeysJED.put("LightBrightness", 9);
        this.worldInfoKeysJED.put("CanRespawnHere", 1);
        this.worldInfoKeysJED.put("RespawnDimension", 3);
        this.worldInfoKeysListTypes.put("LightBrightness", 5);
    }

    public boolean useCustomWorldInfoFor(int dimension) {
        return this.customWorldInfo.containsKey(dimension) || this.onetimeWorldInfo.containsKey(dimension);
    }

    @Nullable
    public String getBiomeFor(int dimension) {
        DimensionConfigEntry entry = this.dimensions.get(dimension);
        return entry != null ? entry.getBiome() : null;
    }

    public void setWorldInfoValues(int dimension, NBTTagCompound tagIn, WorldInfoType type) {
        Map<Integer, NBTTagCompound> map = type == WorldInfoType.ONE_TIME ? this.onetimeWorldInfo : this.customWorldInfo;
        NBTTagCompound dimNBT = map.get(dimension);
        if (dimNBT != null) {
            tagIn.func_179237_a(dimNBT);
        }
    }

    private File getConfigFile(File worldDir) {
        File file = null;
        if (worldDir != null) {
            file = new File(new File(worldDir, "justenoughdimensions"), "dimensions.json");
        }
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            file = this.dimensionConfigsFile;
        }
        return file;
    }

    public void readDimensionConfig() {
        this.readDimensionConfig(DimensionManager.getCurrentSaveRootDirectory());
    }

    public void readDimensionConfig(File worldDir) {
        block6: {
            this.customWorldInfo.clear();
            this.onetimeWorldInfo.clear();
            this.dimensions.clear();
            File file = this.getConfigFile(worldDir);
            if (file.exists() && file.isFile() && file.canRead()) {
                try {
                    JsonParser parser = new JsonParser();
                    JsonElement rootElement = parser.parse((Reader)new FileReader(file));
                    if (rootElement != null) {
                        this.parseDimensionConfig(rootElement);
                        break block6;
                    }
                    JustEnoughDimensions.logger.warn("The dimensions.json config was empty");
                }
                catch (Exception e) {
                    JustEnoughDimensions.logger.error("Failed to parse the config file '{}'", new Object[]{file.getName(), e});
                }
            } else if (!this.configDirConfigs.isDirectory()) {
                this.configDirConfigs.mkdirs();
            }
        }
        this.restoreMissingVanillaDimensions();
    }

    private void restoreMissingVanillaDimensions() {
        for (int dim = -1; dim < 2; ++dim) {
            if (this.dimensions.containsKey(dim) || DimensionManager.isDimensionRegistered((int)dim)) continue;
            JustEnoughDimensions.logInfo("Dimension {} was not registered, and not found in the current JED config. Registering the normal vanilla dimension for it.", dim);
            DimensionManager.registerDimension((int)dim, (DimensionType)this.getVanillaDimensionType(dim));
        }
    }

    private DimensionType getVanillaDimensionType(int dim) {
        switch (dim) {
            case 1: {
                return DimensionType.THE_END;
            }
            case -1: {
                return DimensionType.NETHER;
            }
        }
        return DimensionType.OVERWORLD;
    }

    public void registerDimensions() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            this.registerDimension(entry.getId(), entry);
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
    }

    public void registerNonOverrideDimensions() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            if (Configs.enableReplacingRegisteredDimensions && entry.getOverride()) continue;
            this.registerDimension(entry.getId(), entry);
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
    }

    public void registerOverriddenDimensions() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            if (Configs.enableUnregisteringDimensions && entry.getUnregister() && DimensionManager.isDimensionRegistered((int)entry.getId())) {
                JustEnoughDimensions.logInfo("Unregistering dimension {}...", entry.getId());
                DimensionManager.unregisterDimension((int)entry.getId());
                continue;
            }
            if (!entry.getOverride() || !Configs.enableReplacingRegisteredDimensions && DimensionManager.isDimensionRegistered((int)entry.getId())) continue;
            this.registerDimension(entry.getId(), entry);
        }
    }

    private boolean registerDimension(int dimension, DimensionConfigEntry entry) {
        if (entry.getUnregister() || !entry.hasDimensionTypeEntry()) {
            return false;
        }
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            JustEnoughDimensions.logInfo("Registering a dimension with ID {}...", dimension);
            DimensionManager.registerDimension((int)dimension, (DimensionType)entry.getDimensionTypeEntry().registerDimensionType());
            this.registeredDimensions.add(dimension);
            return true;
        }
        if (Configs.enableReplacingRegisteredDimensions && entry.getOverride()) {
            if (DimensionManager.getWorld((int)dimension) == null) {
                JustEnoughDimensions.logInfo("Overriding dimension {}...", dimension);
                DimensionManager.unregisterDimension((int)dimension);
                DimensionManager.registerDimension((int)dimension, (DimensionType)entry.getDimensionTypeEntry().registerDimensionType());
                this.registeredDimensions.add(dimension);
                return true;
            }
            JustEnoughDimensions.logger.warn("Dimension {} is already registered and currently loaded, can't override it...", new Object[]{dimension});
        } else {
            JustEnoughDimensions.logger.warn("Dimension {} is already registered, skipping it...", new Object[]{dimension});
        }
        return false;
    }

    public String registerDimensionFromConfig(int dimension) throws CommandException {
        DimensionConfigEntry entry = this.dimensions.get(dimension);
        if (entry != null) {
            if (entry.getUnregister()) {
                CommandJED.throwNumber("register.from.config.unregister.set", dimension);
            }
            if (this.registerDimension(dimension, entry)) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
                return entry.getDescription();
            }
            CommandJED.throwNumber("register.from.config", dimension);
        }
        CommandJED.throwNumber("register.not.in.config", dimension);
        return "";
    }

    public String registerNewDimension(int dimension) throws CommandException {
        DimensionConfigEntry entry = new DimensionConfigEntry(dimension);
        entry.setDimensionTypeEntry(this.createDefaultDimensionTypeEntry(dimension));
        return this.registerNewDimension(dimension, entry);
    }

    private String registerNewDimension(int dimension, DimensionConfigEntry entry) throws CommandException {
        boolean success = this.registerDimension(dimension, entry);
        if (!success) {
            CommandJED.throwNumber("dimension.already.registered", dimension);
        }
        this.dimensions.put(dimension, entry);
        this.saveConfig();
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
        return entry.getDescription();
    }

    public String registerNewDimension(int dimension, String name, String suffix, boolean keepLoaded, String providerClassName, boolean override) throws CommandException {
        Class<? extends WorldProvider> providerClass = DimensionTypeEntry.getProviderClass(providerClassName);
        if (providerClass == null) {
            CommandJED.throwCommand("invalid.worldprovider.name", providerClassName);
        }
        DimensionConfigEntry entry = new DimensionConfigEntry(dimension);
        entry.setDimensionTypeEntry(new DimensionTypeEntry(dimension, name, suffix, keepLoaded, providerClass));
        entry.setOverride(override);
        return this.registerNewDimension(dimension, entry);
    }

    public void unregisterCustomDimensions() {
        HashSet<Integer> toRemove = new HashSet<Integer>();
        for (int dimension : this.registeredDimensions) {
            if (dimension == 0 || !DimensionManager.isDimensionRegistered((int)dimension) || DimensionManager.getWorld((int)dimension) != null) continue;
            JustEnoughDimensions.logInfo("Unregistering dimension {}...", dimension);
            DimensionManager.unregisterDimension((int)dimension);
            toRemove.add(dimension);
        }
        this.registeredDimensions.removeAll(toRemove);
    }

    public void removeDimensionAndSaveConfig(int dimension) {
        this.removeDimension(dimension);
        this.saveConfig();
    }

    private void removeDimension(int dimension) {
        this.dimensions.remove(dimension);
        this.customWorldInfo.remove(dimension);
        this.onetimeWorldInfo.remove(dimension);
    }

    private void saveConfig() {
        ArrayList<DimensionConfigEntry> dims = new ArrayList<DimensionConfigEntry>();
        dims.addAll(this.getRegisteredDimensions());
        Collections.sort(dims);
        JsonObject root = new JsonObject();
        JsonArray array = new JsonArray();
        for (DimensionConfigEntry dimEntry : dims) {
            array.add((JsonElement)dimEntry.toJson());
        }
        root.add("dimensions", (JsonElement)array);
        try {
            FileWriter writer = new FileWriter(this.getConfigFile(DimensionManager.getCurrentSaveRootDirectory()));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)root));
            writer.close();
        }
        catch (IOException e) {
            JustEnoughDimensions.logger.warn("Failed to write dimensions.json");
            e.printStackTrace();
        }
    }

    private void parseDimensionConfig(JsonElement rootElement) throws IllegalStateException {
        JustEnoughDimensions.logInfo("Reading the dimensions.json config...", new Object[0]);
        if (!(rootElement != null && rootElement.isJsonObject() && rootElement.getAsJsonObject().has("dimensions") && rootElement.getAsJsonObject().get("dimensions").isJsonArray())) {
            JustEnoughDimensions.logger.warn("The dimensions.json config is missing some of the top level elements...");
            return;
        }
        JsonArray array = rootElement.getAsJsonObject().get("dimensions").getAsJsonArray();
        int count = 0;
        for (JsonElement el : array) {
            JsonObject object = el.getAsJsonObject();
            if (!object.has("dim") || !object.get("dim").isJsonPrimitive()) continue;
            this.parseDimensionConfigEntry(object.get("dim").getAsInt(), object);
            ++count;
        }
        JustEnoughDimensions.logInfo("Read {} dimension entries from the config", count);
    }

    private void parseDimensionConfigEntry(int dimension, JsonObject object) {
        JsonObject obj;
        DimensionConfigEntry configEntry = new DimensionConfigEntry(dimension);
        boolean override = object.has("override") && object.get("override").isJsonPrimitive() && object.get("override").getAsBoolean();
        boolean unregister = object.has("unregister") && object.get("unregister").isJsonPrimitive() && object.get("unregister").getAsBoolean();
        boolean disableTeleportingFrom = object.has("disableteleportingfrom") && object.get("disableteleportingfrom").isJsonPrimitive() && object.get("disableteleportingfrom").getAsBoolean();
        boolean disableTeleportingTo = object.has("disableteleportingto") && object.get("disableteleportingto").isJsonPrimitive() && object.get("disableteleportingto").getAsBoolean();
        String biome = object.has("biome") && object.get("biome").isJsonPrimitive() ? object.get("biome").getAsString() : null;
        configEntry.setOverride(override);
        configEntry.setUnregister(unregister);
        configEntry.setDisableTeleportingFrom(disableTeleportingFrom);
        configEntry.setDisableTeleportingTo(disableTeleportingTo);
        configEntry.setBiome(biome);
        if (object.has("colors") && object.get("colors").isJsonObject()) {
            configEntry.setColorJson(object.getAsJsonObject("colors"));
        }
        if (object.has("worldinfo") && object.get("worldinfo").isJsonObject()) {
            obj = object.get("worldinfo").getAsJsonObject();
            configEntry.setWorldInfoJson(obj);
            this.customWorldInfo.put(dimension, this.parseAndGetCustomWorldInfoValues(dimension, obj));
        }
        if (object.has("worldinfo_onetime") && object.get("worldinfo_onetime").isJsonObject()) {
            obj = object.get("worldinfo_onetime").getAsJsonObject();
            configEntry.setOneTimeWorldInfoJson(obj);
            this.onetimeWorldInfo.put(dimension, this.parseAndGetCustomWorldInfoValues(dimension, obj));
        }
        if (object.has("dimensiontype") && object.get("dimensiontype").isJsonObject()) {
            obj = object.get("dimensiontype").getAsJsonObject();
            configEntry.setDimensionTypeEntry(this.parseDimensionTypeEntry(dimension, obj));
        }
        this.dimensions.put(dimension, configEntry);
    }

    private DimensionTypeEntry createDefaultDimensionTypeEntry(int dimension) {
        DimensionTypeEntry dte = new DimensionTypeEntry(dimension, "DIM" + dimension, "dim_" + dimension, false, WorldProviderSurfaceJED.class);
        JustEnoughDimensions.logInfo("Created a default DimensionTypeEntry for dimension {}: {}", dimension, dte.getDescription());
        return dte;
    }

    public void dimbuilderClear() {
        this.dimBuilderData = new JsonObject();
    }

    public void dimbuilderDimtype(int id, String name, String suffix, String keepLoaded, String worldProvider) {
        JsonObject dimType = JEDJsonUtils.getOrCreateNestedObject(this.dimBuilderData, "dimensiontype");
        dimType.add("id", (JsonElement)new JsonPrimitive((Number)id));
        dimType.add("name", (JsonElement)new JsonPrimitive(name));
        dimType.add("suffix", (JsonElement)new JsonPrimitive(suffix));
        dimType.add("keeploaded", (JsonElement)new JsonPrimitive(keepLoaded));
        dimType.add("worldprovider", (JsonElement)new JsonPrimitive(worldProvider));
    }

    public void dimbuilderSet(String key, String value, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if (key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("disableteleportingfrom") || key.equals("disableteleportingto")) {
            obj.add(key, (JsonElement)new JsonPrimitive(value));
        } else if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("vanilladimensiontype")) {
            JEDJsonUtils.getOrCreateNestedObject(obj, "dimensiontype").add(key, (JsonElement)new JsonPrimitive(value));
        } else if (key.equals("worldinfo") || key.equals("worldinfo_onetime")) {
            JEDJsonUtils.getOrCreateNestedObject(obj, type.getKeyName());
        } else {
            obj = JEDJsonUtils.getOrCreateNestedObject(obj, type.getKeyName());
            if (this.isJEDProperty(key)) {
                obj = JEDJsonUtils.getOrCreateNestedObject(obj, "JED");
            } else if (this.worldInfoKeys.get(key) == null) {
                obj = JEDJsonUtils.getOrCreateNestedObject(obj, "GameRules");
            }
            obj.add(key, (JsonElement)new JsonPrimitive(value));
        }
    }

    public boolean dimbuilderRemove(String key, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if (key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("colors") || key.equals("disableteleportingfrom") || key.equals("disableteleportingto")) {
            return obj.remove(key) != null;
        }
        if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("vanilladimensiontype")) {
            return (obj = JEDJsonUtils.getNestedObject(obj, "dimensiontype", false)) != null ? obj.remove(key) != null : false;
        }
        if (key.equals("worldinfo") || key.equals("worldinfo_onetime")) {
            obj.remove(type.getKeyName());
            return true;
        }
        if ((obj = JEDJsonUtils.getNestedObject(obj, type.getKeyName(), false)) != null) {
            if (obj.has(key)) {
                return obj.remove(key) != null;
            }
            String tagName = this.isJEDProperty(key) ? "JED" : "GameRules";
            return (obj = JEDJsonUtils.getNestedObject(obj, tagName, false)) != null ? obj.remove(key) != null : false;
        }
        return false;
    }

    public void dimbuilderList(@Nullable String key, WorldInfoType type, ICommandSender sender) throws CommandException {
        if (key != null) {
            JsonPrimitive prim = this.getDimbuilderPrimitive(key, type);
            if (prim != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(key + " = " + prim.getAsString()));
            } else {
                CommandJED.throwCommand("dimbuilder.list", key);
            }
        } else {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JustEnoughDimensions.logger.info("==== Dim Builder list start ====");
            JustEnoughDimensions.logger.info("\n" + gson.toJson((JsonElement)this.dimBuilderData));
            JustEnoughDimensions.logger.info("==== Dim Builder list end ====");
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.output.printed.to.console", new Object[0]));
        }
    }

    public boolean dimbuilderReadFrom(int dimension) {
        DimensionConfigEntry entry = this.dimensions.get(dimension);
        if (entry != null) {
            this.dimBuilderData = entry.toJson();
            this.dimBuilderData.remove("dim");
            return true;
        }
        return false;
    }

    public void dimbuilderSaveAs(int dimension) {
        this.removeDimension(dimension);
        this.parseDimensionConfigEntry(dimension, this.dimBuilderData);
        this.saveConfig();
    }

    public void dimbuilderCreateAs(int dimension) throws CommandException {
        this.dimbuilderSaveAs(dimension);
        this.registerDimensionFromConfig(dimension);
    }

    @Nullable
    private JsonPrimitive getDimbuilderPrimitive(String key, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if ((key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("disableteleportingfrom") || key.equals("disableteleportingto")) && obj.has(key) && obj.get(key).isJsonPrimitive()) {
            return obj.get(key).getAsJsonPrimitive();
        }
        if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("vanilladimensiontype")) {
            if (obj.has("dimensiontype") && obj.get("dimensiontype").isJsonObject()) {
                return (obj = obj.get("dimensiontype").getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive() ? obj.get(key).getAsJsonPrimitive() : null;
            }
            return null;
        }
        if (obj.has(type.getKeyName()) && obj.get(type.getKeyName()).isJsonObject()) {
            String tagName;
            if ((obj = obj.get(type.getKeyName()).getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive()) {
                return obj.get(key).getAsJsonPrimitive();
            }
            String string = tagName = this.isJEDProperty(key) ? "JED" : "GameRules";
            if (obj.has(tagName) && obj.get(tagName).isJsonObject()) {
                return (obj = obj.get(tagName).getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive() ? obj.get(key).getAsJsonPrimitive() : null;
            }
        }
        return null;
    }

    @Nullable
    public static Map<ResourceLocation, Integer> getColorMap(@Nullable JsonObject obj, ColorType type) {
        String key = type.getKeyName();
        if (obj != null && obj.has(key) && obj.get(key).isJsonArray()) {
            HashMap<ResourceLocation, Integer> colors = new HashMap<ResourceLocation, Integer>();
            JsonArray arr = obj.getAsJsonArray(key);
            for (JsonElement el : arr) {
                JsonObject o;
                if (!el.isJsonObject() || !(o = el.getAsJsonObject()).has("color")) continue;
                String strColor = o.get("color").getAsString();
                if (o.has("biome")) {
                    colors.put(new ResourceLocation(o.get("biome").getAsString()), JEDStringUtils.hexStringToInt(strColor));
                    continue;
                }
                if (!o.has("biome_regex")) continue;
                DimensionConfig.addColorForBiomeRegex(o.get("biome_regex").getAsString(), JEDStringUtils.hexStringToInt(strColor), colors);
            }
            return colors;
        }
        return null;
    }

    private static void addColorForBiomeRegex(String regex, int color, Map<ResourceLocation, Integer> colors) {
        try {
            Pattern pattern = Pattern.compile(regex);
            for (ResourceLocation rl : Biome.field_185377_q.func_148742_b()) {
                if (!pattern.matcher(rl.toString()).matches()) continue;
                colors.put(rl, color);
            }
        }
        catch (PatternSyntaxException e) {
            JustEnoughDimensions.logger.warn("DimensionConfig.addColorForBiomeRegex(): Invalid regular expression", (Throwable)e);
        }
    }

    private NBTTagCompound parseAndGetCustomWorldInfoValues(int dimension, JsonObject object) throws IllegalStateException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry entry : object.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            String key = (String)entry.getKey();
            NBTBase tag = this.getTagForValue(key, element);
            if (tag == null) continue;
            nbt.func_74782_a(key, tag);
        }
        return nbt;
    }

    private boolean isJEDProperty(String key) {
        return this.worldInfoKeysJED.get(key) != null;
    }

    @Nullable
    private NBTBase getTagForValue(String key, JsonElement element) {
        if (key.equals("RandomSeed")) {
            String seedStr = element.getAsString();
            try {
                long seed = Long.parseLong(seedStr);
                return new NBTTagLong(seed);
            }
            catch (NumberFormatException e) {
                return new NBTTagLong((long)seedStr.hashCode());
            }
        }
        if (element.isJsonObject()) {
            NBTTagCompound tag = new NBTTagCompound();
            JsonObject obj = element.getAsJsonObject();
            if (key.equals("GameRules")) {
                for (Map.Entry entry : obj.entrySet()) {
                    tag.func_74778_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            } else if (key.equals("JED")) {
                for (Map.Entry entry : obj.entrySet()) {
                    NBTBase tagTmp = this.getTagForValue((String)entry.getKey(), (JsonElement)entry.getValue());
                    if (tagTmp == null) continue;
                    tag.func_74782_a((String)entry.getKey(), tagTmp);
                }
            }
            return tag;
        }
        Integer type = this.worldInfoKeys.get(key);
        if (type != null) {
            return this.getTagForType(key, type, element);
        }
        type = this.worldInfoKeysJED.get(key);
        if (type != null) {
            return this.getTagForType(key, type, element);
        }
        JustEnoughDimensions.logger.warn("Unrecognized option in worldinfo.values: '{} = {}'", new Object[]{key, element.getAsString()});
        return null;
    }

    @Nullable
    private NBTBase getTagForType(String key, int type, JsonElement element) {
        switch (type) {
            case 1: {
                try {
                    String str = element.getAsString();
                    if (str != null && (str.equals("true") || str.equals("false"))) {
                        return new NBTTagByte(element.getAsBoolean() ? (byte)1 : 0);
                    }
                }
                catch (Exception str) {
                    // empty catch block
                }
                return new NBTTagByte(element.getAsByte());
            }
            case 2: {
                return new NBTTagShort(element.getAsShort());
            }
            case 3: {
                return new NBTTagInt(element.getAsInt());
            }
            case 4: {
                return new NBTTagLong(element.getAsLong());
            }
            case 5: {
                return new NBTTagFloat(element.getAsFloat());
            }
            case 6: {
                return new NBTTagDouble(element.getAsDouble());
            }
            case 8: {
                return new NBTTagString(element.getAsString());
            }
            case 9: {
                if (!element.isJsonArray() || !this.worldInfoKeysListTypes.containsKey(key)) break;
                JsonArray arr = element.getAsJsonArray();
                NBTTagList list = new NBTTagList();
                int listType = this.worldInfoKeysListTypes.get(key);
                for (JsonElement el : arr) {
                    NBTBase tag = this.getTagForType("", listType, el);
                    if (tag == null) continue;
                    list.func_74742_a(tag);
                }
                return list;
            }
        }
        return null;
    }

    private DimensionTypeEntry parseDimensionTypeEntry(int dimension, JsonObject dimType) {
        String name;
        int dimTypeId;
        int n = dimTypeId = dimType.has("id") && dimType.get("id").isJsonPrimitive() ? dimType.get("id").getAsInt() : dimension;
        if (dimType.has("vanilladimensiontype") && dimType.get("vanilladimensiontype").isJsonPrimitive()) {
            String typeName = dimType.get("vanilladimensiontype").getAsString();
            JustEnoughDimensions.logInfo("Using a vanilla DimensionType (or some other existing one) '{}' for dimension {}", typeName, dimension);
            return new DimensionTypeEntry(dimTypeId, typeName);
        }
        String string = name = dimType.has("name") && dimType.get("name").isJsonPrimitive() ? dimType.get("name").getAsString() : "DIM" + dimension;
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "DIM" + dimension;
        }
        String suffix = dimType.has("suffix") && dimType.get("suffix").isJsonPrimitive() ? dimType.get("suffix").getAsString() : "_dim" + dimension;
        boolean keepLoaded = dimType.has("keeploaded") && dimType.get("keeploaded").isJsonPrimitive() && dimType.get("keeploaded").getAsBoolean();
        Class<WorldProviderSurfaceJED> providerClass = WorldProviderSurfaceJED.class;
        String providerName = "";
        if (dimType.has("worldprovider") && dimType.get("worldprovider").isJsonPrimitive()) {
            providerName = dimType.get("worldprovider").getAsString();
            if (dimension == 1) {
                if (providerName.equals("WorldProviderSurface") || providerName.equals("net.minecraft.world.WorldProviderSurface")) {
                    providerName = WorldProviderSurfaceJED.class.getSimpleName();
                    JustEnoughDimensions.logger.warn("Changing the provider for DIM1 to {} to prevent a vanilla crash", new Object[]{providerName});
                } else if (providerName.equals("WorldProviderHell") || providerName.equals("net.minecraft.world.WorldProviderHell")) {
                    providerName = WorldProviderHellJED.class.getSimpleName();
                    JustEnoughDimensions.logger.warn("Changing the provider for DIM1 to {} to prevent a vanilla crash", new Object[]{providerName});
                }
            }
            providerClass = DimensionTypeEntry.getProviderClass(providerName);
        }
        if (providerClass == null) {
            providerClass = WorldProviderSurfaceJED.class;
            JustEnoughDimensions.logger.warn("Failed to get a WorldProvider for name '{}', using {} as a fall-back", new Object[]{providerName, DimensionTypeEntry.getNameForWorldProvider(providerClass)});
        }
        JustEnoughDimensions.logInfo("Creating a customized DimensionType for dimension {}", dimension);
        return new DimensionTypeEntry(dimension, name, suffix, keepLoaded, providerClass);
    }

    public static enum ColorType {
        FOLIAGE("FoliageColors"),
        GRASS("GrassColors"),
        WATER("WaterColors");

        private final String keyName;

        private ColorType(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    public static enum WorldInfoType {
        REGULAR("worldinfo"),
        ONE_TIME("worldinfo_onetime");

        private final String keyName;

        private WorldInfoType(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }
}

