/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GamemodeTracker {
    private static GamemodeTracker instance;
    private Map<UUID, GameType> gameModes = new HashMap<UUID, GameType>();
    private boolean dirty = false;

    public static GamemodeTracker getInstance() {
        if (instance == null) {
            instance = new GamemodeTracker();
        }
        return instance;
    }

    public void playerChangedDimension(EntityPlayerMP player, int dimFrom, int dimTo) {
        boolean forcedFrom = this.dimensionHasForcedGamemode(dimFrom);
        boolean forcedTo = this.dimensionHasForcedGamemode(dimTo);
        if (forcedTo) {
            if (!forcedFrom) {
                this.storeNonForcedGamemode(player);
            }
            this.setPlayerGamemode(player, player.func_130014_f_().func_72912_H().func_76077_q());
        } else if (this.gameModes.containsKey(player.func_110124_au())) {
            this.restoreStoredGamemode(player);
        }
    }

    private boolean dimensionHasForcedGamemode(int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        return world != null && world.func_72912_H() instanceof WorldInfoJED && ((WorldInfoJED)world.func_72912_H()).getForceGamemode();
    }

    private void storeNonForcedGamemode(EntityPlayerMP player) {
        this.gameModes.put(player.func_110124_au(), player.field_71134_c.func_73081_b());
        this.dirty = true;
    }

    private void restoreStoredGamemode(EntityPlayerMP player) {
        this.setPlayerGamemode(player, this.gameModes.get(player.func_110124_au()));
        this.gameModes.remove(player.func_110124_au());
        this.dirty = true;
    }

    private void setPlayerGamemode(EntityPlayerMP player, GameType type) {
        player.func_71033_a(type);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("jed.info.gamemode.changed", new Object[]{type.toString()}));
    }

    public void readFromDisk() {
        this.gameModes.clear();
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            File file = new File(new File(saveDir, "justenoughdimensions"), "gamemodetracker.dat");
            if (file.exists() && file.isFile()) {
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
            }
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Failed to read GamemodeTracker data from file");
        }
    }

    public void writeToDisk() {
        if (!this.dirty) {
            return;
        }
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            if (!(saveDir = new File(saveDir, "justenoughdimensions")).exists() && !saveDir.mkdirs()) {
                JustEnoughDimensions.logger.warn("Failed to create the save directory '{}'", new Object[]{saveDir.toString()});
                return;
            }
            File fileTmp = new File(saveDir, "gamemodetracker.dat.tmp");
            File fileReal = new File(saveDir, "gamemodetracker.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(new NBTTagCompound()), (OutputStream)new FileOutputStream(fileTmp));
            if (fileReal.exists()) {
                fileReal.delete();
            }
            fileTmp.renameTo(fileReal);
            this.dirty = false;
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Failed to write GamemodeTracker data to file", (Throwable)e);
        }
    }

    private void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("GamemodeTracker", 9)) {
            return;
        }
        NBTTagList tagList = nbt.func_150295_c("GamemodeTracker", 10);
        int count = tagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            GameType type;
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (!tag.func_150297_b("UUIDM", 4) || !tag.func_150297_b("UUIDL", 4) || !tag.func_150297_b("GameMode", 1) || (type = GameType.func_77146_a((int)tag.func_74771_c("GameMode"))) == GameType.NOT_SET) continue;
            this.gameModes.put(new UUID(tag.func_74763_f("UUIDM"), tag.func_74763_f("UUIDL")), type);
        }
    }

    private NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, GameType> entry : this.gameModes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("UUIDM", entry.getKey().getMostSignificantBits());
            tag.func_74772_a("UUIDL", entry.getKey().getLeastSignificantBits());
            tag.func_74774_a("GameMode", (byte)entry.getValue().func_77148_a());
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("GamemodeTracker", (NBTBase)tagList);
        return nbt;
    }
}

