/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.event.GamemodeTracker;
import fi.dy.masa.justenoughdimensions.event.JEDBorderListener;
import fi.dy.masa.justenoughdimensions.network.DimensionSyncPacket;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import fi.dy.masa.justenoughdimensions.world.util.WorldBorderUtils;
import fi.dy.masa.justenoughdimensions.world.util.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.world.util.WorldUtils;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class JEDEventHandler {
    private static final JEDEventHandler INSTANCE = new JEDEventHandler();

    public static JEDEventHandler instance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        DimensionSyncPacket packet = new DimensionSyncPacket();
        packet.addDimensionData(DimensionConfig.instance().getRegisteredDimensions());
        FMLEmbeddedChannel channel = JustEnoughDimensions.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(event.getManager().channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        channel.writeOutbound(new Object[]{packet});
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            JustEnoughDimensions.logInfo("WorldEvent.Load - DIM: {}", world.field_73011_w.getDimension());
            JEDEventHandler.overrideWorldInfoAndBiomeProviderAndFindSpawn(world, true);
            if (Configs.enableSeparateWorldBorders) {
                WorldBorderUtils.removeOverworldBorderListener(world);
                world.func_175723_af().func_177737_a((IBorderListener)new JEDBorderListener(world.field_73011_w.getDimension()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onWorldCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        JustEnoughDimensions.logInfo("WorldEvent.CreateSpawnPosition - DIM: {}", world.field_73011_w.getDimension());
        JEDEventHandler.overrideWorldInfoAndBiomeProviderAndFindSpawn(world, false);
        if (world.field_73011_w.getDimension() == 0) {
            WorldUtils.findAndSetWorldSpawn(world, false);
            event.setCanceled(true);
        }
    }

    private static void overrideWorldInfoAndBiomeProviderAndFindSpawn(World world, boolean tryFindSpawn) {
        if (Configs.enableSeparateWorldInfo) {
            WorldInfoUtils.loadAndSetCustomWorldInfo(world);
        }
        if (Configs.enableOverrideBiomeProvider) {
            WorldUtils.overrideBiomeProvider(world);
        }
        if (Configs.enableSeparateWorldInfo && tryFindSpawn) {
            WorldUtils.findAndSetWorldSpawn(world);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        WorldInfoUtils.saveCustomWorldInfoToFile(event.getWorld());
        if (Configs.enableForcedGamemodes && event.getWorld().field_73011_w.getDimension() == 0) {
            GamemodeTracker.getInstance().writeToDisk();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerLoggedInEvent - DIM: {}", event.player.func_130014_f_().field_73011_w.getDimension());
        WorldBorderUtils.sendWorldBorder(event.player);
        WorldUtils.syncWorldProviderProperties(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerRespawnEvent - DIM: {}", event.player.func_130014_f_().field_73011_w.getDimension());
        WorldBorderUtils.sendWorldBorder(event.player);
        WorldUtils.syncWorldProviderProperties(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerChangedDimensionEvent - DIM: {}", event.player.func_130014_f_().field_73011_w.getDimension());
        WorldBorderUtils.sendWorldBorder(event.player);
        WorldUtils.syncWorldProviderProperties(event.player);
        if (Configs.enableForcedGamemodes && event.player instanceof EntityPlayerMP) {
            GamemodeTracker.getInstance().playerChangedDimension((EntityPlayerMP)event.player, event.fromDim, event.toDim);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (!DimensionManager.isDimensionRegistered((int)event.getDimension())) {
            event.setCanceled(true);
            return;
        }
        DimensionConfigEntry entryFrom = DimensionConfig.instance().getDimensionConfigFor(event.getEntity().func_130014_f_().field_73011_w.getDimension());
        if (entryFrom != null && entryFrom.getDisableTeleportingFrom()) {
            event.setCanceled(true);
            return;
        }
        DimensionConfigEntry entryTo = DimensionConfig.instance().getDimensionConfigFor(event.getDimension());
        if (entryTo != null && entryTo.getDisableTeleportingTo()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerLoadingEvent(PlayerEvent.LoadFromFile event) {
        if (Configs.enableInitialSpawnDimensionOverride && !new File(event.getPlayerDirectory(), event.getPlayerUUID() + ".dat").exists()) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(Configs.initialSpawnDimensionId);
            if (world != null) {
                EntityPlayer player = event.getEntityPlayer();
                player.field_71093_bK = Configs.initialSpawnDimensionId;
                BlockPos pos = world.func_72912_H() instanceof WorldInfoJED ? world.func_175694_M() : WorldUtils.findSuitableSpawnpoint((World)world);
                JustEnoughDimensions.logInfo("Player {} joined for the first time, moving them to dimension {}, at {}", player.func_70005_c_(), Configs.initialSpawnDimensionId, pos);
                player.func_174828_a(pos, 0.0f, 0.0f);
            } else {
                JustEnoughDimensions.logger.warn("Player {} joined for the first time, but the currently set initial spawn dimension {} didn't exist", new Object[]{event.getEntityPlayer().func_70005_c_(), Configs.initialSpawnDimensionId});
            }
        }
    }
}

