/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class JEDEventHandlerClient {
    private static final Map<ResourceLocation, Integer> FOLIAGE_COLORS = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> GRASS_COLORS = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> WATER_COLORS = new HashMap<ResourceLocation, Integer>();
    private static boolean hasFoliageColors;
    private static boolean hasGrassColors;
    private static boolean hasWaterColors;

    @SubscribeEvent
    public static void onGetFoliageColor(BiomeEvent.GetFoliageColor event) {
        event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.FOLIAGE, event.getBiome(), event.getOriginalColor()));
    }

    @SubscribeEvent
    public static void onGetGrassColor(BiomeEvent.GetGrassColor event) {
        event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.GRASS, event.getBiome(), event.getOriginalColor()));
    }

    @SubscribeEvent
    public static void onGetWaterColor(BiomeEvent.GetWaterColor event) {
        event.setNewColor(JEDEventHandlerClient.getColor(DimensionConfig.ColorType.WATER, event.getBiome(), event.getOriginalColor()));
    }

    public static void setColors(DimensionConfig.ColorType type, @Nullable Map<ResourceLocation, Integer> colorsIn) {
        Map<ResourceLocation, Integer> colors = JEDEventHandlerClient.getColorMap(type);
        colors.clear();
        if (colorsIn != null) {
            colors.putAll(colorsIn);
        }
        JEDEventHandlerClient.setFlag(type, !colors.isEmpty());
    }

    private static int getColor(DimensionConfig.ColorType type, Biome biome, int defaultColor) {
        if (JEDEventHandlerClient.getFlag(type)) {
            Integer color = JEDEventHandlerClient.getColorMap(type).get(biome.getRegistryName());
            return color != null ? color : defaultColor;
        }
        return defaultColor;
    }

    private static Map<ResourceLocation, Integer> getColorMap(DimensionConfig.ColorType type) {
        switch (type) {
            case FOLIAGE: {
                return FOLIAGE_COLORS;
            }
            case GRASS: {
                return GRASS_COLORS;
            }
            case WATER: {
                return WATER_COLORS;
            }
        }
        return FOLIAGE_COLORS;
    }

    private static boolean getFlag(DimensionConfig.ColorType type) {
        switch (type) {
            case FOLIAGE: {
                return hasFoliageColors;
            }
            case GRASS: {
                return hasGrassColors;
            }
            case WATER: {
                return hasWaterColors;
            }
        }
        return false;
    }

    private static void setFlag(DimensionConfig.ColorType type, boolean value) {
        switch (type) {
            case FOLIAGE: {
                hasFoliageColors = value;
                break;
            }
            case GRASS: {
                hasGrassColors = value;
                break;
            }
            case WATER: {
                hasWaterColors = value;
                break;
            }
        }
    }
}

