/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JEDJsonUtils {
    @Nullable
    public static JsonObject getOrCreateNestedObject(JsonObject parent, String key) {
        return JEDJsonUtils.getNestedObject(parent, key, true);
    }

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    public static void copyJsonObject(JsonObject parent, String name, @Nullable JsonObject obj) {
        if (obj != null) {
            try {
                JsonElement root = JEDJsonUtils.deserialize(JEDJsonUtils.serialize((JsonElement)obj));
                if (root != null && root.isJsonObject()) {
                    parent.add(name, (JsonElement)root.getAsJsonObject());
                } else {
                    JustEnoughDimensions.logger.error("Failed to convert a DimensionEntry into a JsonObject");
                }
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("Failed to convert a DimensionEntry into a JsonObject", (Throwable)e);
            }
        }
    }

    public static String serialize(@Nonnull JsonElement element) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(element);
    }

    @Nullable
    public static JsonElement deserialize(String input) throws JsonParseException, JsonSyntaxException {
        JsonParser parser = new JsonParser();
        return parser.parse(input);
    }
}

