/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world;

import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.storage.WorldInfo;

public class WorldInfoJED
extends WorldInfo {
    private NBTTagCompound fullJEDTag;
    private boolean forceGameMode;
    private boolean useCustomDayCycle;
    private int dayLength = 12000;
    private int nightLength = 12000;
    private int cloudHeight = 128;
    private int skyRenderType;
    private int skyDisableFlags;
    private Vec3d skyColor = null;
    private Vec3d cloudColor = null;
    private Vec3d fogColor = null;
    private float[] customLightBrightnessTable = null;
    protected Boolean canRespawnHere = null;
    protected Integer respawnDimension = null;

    public WorldInfoJED(NBTTagCompound nbt) {
        super(nbt);
        if (nbt.func_150297_b("JED", 10)) {
            NBTTagList list;
            NBTTagCompound tag;
            this.fullJEDTag = tag = nbt.func_74775_l("JED");
            if (tag.func_150297_b("ForceGameMode", 1)) {
                this.forceGameMode = tag.func_74767_n("ForceGameMode");
            }
            if (tag.func_150297_b("CustomDayCycle", 1)) {
                this.useCustomDayCycle = tag.func_74767_n("CustomDayCycle");
            }
            if (tag.func_150297_b("DayLength", 3)) {
                this.dayLength = tag.func_74762_e("DayLength");
            }
            if (tag.func_150297_b("NightLength", 3)) {
                this.nightLength = tag.func_74762_e("NightLength");
            }
            if (tag.func_150297_b("CloudHeight", 3)) {
                this.cloudHeight = tag.func_74762_e("CloudHeight");
            }
            if (tag.func_150297_b("SkyRenderType", 1)) {
                this.skyRenderType = tag.func_74771_c("SkyRenderType");
            }
            if (tag.func_150297_b("SkyDisableFlags", 1)) {
                this.skyDisableFlags = tag.func_74771_c("SkyDisableFlags");
            }
            if (tag.func_150297_b("SkyColor", 8)) {
                this.skyColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("SkyColor"));
            }
            if (tag.func_150297_b("CloudColor", 8)) {
                this.cloudColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("CloudColor"));
            }
            if (tag.func_150297_b("FogColor", 8)) {
                this.fogColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("FogColor"));
            }
            if (tag.func_150297_b("LightBrightness", 9) && (list = tag.func_150295_c("LightBrightness", 5)).func_74745_c() == 16) {
                this.customLightBrightnessTable = new float[16];
                for (int i = 0; i < 16; ++i) {
                    this.customLightBrightnessTable[i] = list.func_150308_e(i);
                }
            }
            if (tag.func_150297_b("CanRespawnHere", 1)) {
                this.canRespawnHere = tag.func_74767_n("CanRespawnHere");
            }
            if (tag.func_150297_b("RespawnDimension", 3)) {
                this.respawnDimension = tag.func_74762_e("RespawnDimension");
            }
        }
        if (this.dayLength <= 0) {
            this.dayLength = 1;
        }
        if (this.nightLength <= 0) {
            this.nightLength = 1;
        }
    }

    public NBTTagCompound getJEDTagForClientSync() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("DayLength", this.dayLength);
        tag.func_74768_a("NightLength", this.nightLength);
        tag.func_74768_a("CloudHeight", this.cloudHeight);
        tag.func_74774_a("SkyRenderType", (byte)this.skyRenderType);
        tag.func_74774_a("SkyDisableFlags", (byte)this.skyDisableFlags);
        if (this.useCustomDayCycle) {
            tag.func_74757_a("CustomDayCycle", this.useCustomDayCycle);
        }
        if (this.skyColor != null) {
            tag.func_74778_a("SkyColor", JEDStringUtils.colorToHexString(this.skyColor));
        }
        if (this.cloudColor != null) {
            tag.func_74778_a("CloudColor", JEDStringUtils.colorToHexString(this.cloudColor));
        }
        if (this.fogColor != null) {
            tag.func_74778_a("FogColor", JEDStringUtils.colorToHexString(this.fogColor));
        }
        if (this.customLightBrightnessTable != null) {
            tag.func_74782_a("LightBrightness", (NBTBase)WorldInfoJED.writeFloats(this.customLightBrightnessTable));
        }
        return tag;
    }

    public NBTTagCompound getFullJEDTag() {
        return this.fullJEDTag;
    }

    @Nonnull
    private static NBTTagList writeFloats(float ... values) {
        NBTTagList tagList = new NBTTagList();
        for (float f : values) {
            tagList.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        return tagList;
    }

    public void func_176144_a(EnumDifficulty newDifficulty) {
    }

    public void func_76060_a(GameType type) {
    }

    public void setDifficultyJED(EnumDifficulty newDifficulty) {
        super.func_176144_a(newDifficulty);
    }

    public void setGameTypeJED(GameType type) {
        super.func_76060_a(type);
    }

    public boolean getForceGamemode() {
        return this.forceGameMode;
    }

    public boolean getUseCustomDayCycle() {
        return this.useCustomDayCycle;
    }

    public int getDayLength() {
        return this.dayLength;
    }

    public int getNightLength() {
        return this.nightLength;
    }

    public float[] getCustomLightBrightnessTable() {
        return this.customLightBrightnessTable;
    }

    @Nullable
    public Boolean canRespawnHere() {
        return this.canRespawnHere;
    }

    @Nullable
    public Integer getRespawnDimension() {
        return this.respawnDimension;
    }
}

