/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world;

import fi.dy.masa.justenoughdimensions.client.render.SkyRenderer;
import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import fi.dy.masa.justenoughdimensions.world.util.WorldInfoUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderEndJED
extends WorldProviderEnd
implements IWorldProviderJED {
    private int skyRenderType = 0;
    private int skyDisableFlags = 0;
    protected Vec3d skyColor = null;
    protected Vec3d fogColor = null;
    protected Boolean canRespawnHere = null;
    protected Integer respawnDimension = null;
    protected float[] customLightBrightnessTable;

    public void setDimension(int dim) {
        super.setDimension(dim);
        if (this.field_76579_a != null) {
            WorldInfoUtils.loadAndSetCustomWorldInfo(this.field_76579_a);
        }
    }

    public DimensionType func_186058_p() {
        DimensionType type = null;
        try {
            type = DimensionManager.getProviderType((int)this.getDimension());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type != null ? type : super.func_186058_p();
    }

    @Override
    public void setJEDPropertiesFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            NBTTagList list;
            if (tag.func_150297_b("SkyColor", 8)) {
                this.skyColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("SkyColor"));
            }
            if (tag.func_150297_b("FogColor", 8)) {
                this.fogColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("FogColor"));
            }
            if (tag.func_150297_b("SkyRenderType", 1)) {
                this.skyRenderType = tag.func_74771_c("SkyRenderType");
            }
            if (tag.func_150297_b("SkyDisableFlags", 1)) {
                this.skyDisableFlags = tag.func_74771_c("SkyDisableFlags");
            }
            if (this.skyRenderType != 0) {
                this.setSkyRenderer(new SkyRenderer(this.skyRenderType, this.skyDisableFlags));
            } else {
                this.setSkyRenderer(null);
            }
            if (tag.func_150297_b("LightBrightness", 9) && (list = tag.func_150295_c("LightBrightness", 5)).func_74745_c() == 16) {
                this.customLightBrightnessTable = new float[16];
                for (int i = 0; i < 16; ++i) {
                    this.customLightBrightnessTable[i] = list.func_150308_e(i);
                }
            }
        }
    }

    @Override
    public void setJEDPropertiesFromWorldInfo(WorldInfoJED worldInfo) {
        this.customLightBrightnessTable = worldInfo.getCustomLightBrightnessTable();
        this.canRespawnHere = worldInfo.canRespawnHere();
        this.respawnDimension = worldInfo.getRespawnDimension();
    }

    public boolean func_76567_e() {
        return this.canRespawnHere != null ? this.canRespawnHere : false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        if (this.respawnDimension != null) {
            return this.respawnDimension;
        }
        return this.func_76567_e() ? this.getDimension() : 0;
    }

    public float[] func_177497_p() {
        if (this.customLightBrightnessTable != null) {
            return this.customLightBrightnessTable;
        }
        return super.func_177497_p();
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        super.setAllowedSpawnTypes(this.field_76579_a.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL, allowPeaceful);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return this.skyColor != null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity entity, float partialTicks) {
        Vec3d skyColor = this.skyColor;
        if (skyColor == null) {
            return super.getSkyColor(entity, partialTicks);
        }
        float f1 = MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(x, y, z);
        int blendColour = ForgeHooksClient.getSkyBlendColour((World)this.field_76579_a, (BlockPos)blockpos);
        float r = (float)((double)((float)(blendColour >> 16 & 0xFF) / 255.0f) * skyColor.field_72450_a);
        float g = (float)((double)((float)(blendColour >> 8 & 0xFF) / 255.0f) * skyColor.field_72448_b);
        float b = (float)((double)((float)(blendColour & 0xFF) / 255.0f) * skyColor.field_72449_c);
        return new Vec3d((double)(r *= f1), (double)(g *= f1), (double)(b *= f1));
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Vec3d fogColor = this.fogColor;
        if (fogColor == null) {
            return super.func_76562_b(celestialAngle, partialTicks);
        }
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float r = (float)fogColor.field_72450_a;
        float g = (float)fogColor.field_72448_b;
        float b = (float)fogColor.field_72449_c;
        return new Vec3d((double)(r *= f * 0.94f + 0.06f), (double)(g *= f * 0.94f + 0.06f), (double)(b *= f * 0.91f + 0.09f));
    }
}

