/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world;

import fi.dy.masa.justenoughdimensions.client.render.SkyRenderer;
import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import fi.dy.masa.justenoughdimensions.world.util.WorldInfoUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderJED
extends WorldProvider
implements IWorldProviderJED {
    protected int dayLength = 12000;
    protected int nightLength = 12000;
    protected int cloudHeight = 128;
    private int skyRenderType = 0;
    private int skyDisableFlags = 0;
    private boolean useCustomDayCycle;
    protected Vec3d skyColor = null;
    protected Vec3d cloudColor = null;
    protected Vec3d fogColor = null;
    protected float[] customLightBrightnessTable;
    protected Boolean canRespawnHere = null;
    protected Integer respawnDimension = null;

    public void setDimension(int dim) {
        super.setDimension(dim);
        if (this.field_76579_a != null) {
            WorldInfoUtils.loadAndSetCustomWorldInfo(this.field_76579_a);
        }
    }

    public DimensionType func_186058_p() {
        DimensionType type = null;
        try {
            type = DimensionManager.getProviderType((int)this.getDimension());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type != null ? type : DimensionType.OVERWORLD;
    }

    public boolean func_76567_e() {
        return this.canRespawnHere != null ? this.canRespawnHere : true;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        if (this.respawnDimension != null) {
            return this.respawnDimension;
        }
        return this.func_76567_e() ? this.getDimension() : 0;
    }

    public BlockPos func_177496_h() {
        return this.field_76579_a.func_175694_M();
    }

    public boolean func_186056_c(int x, int z) {
        return !this.field_76579_a.func_72916_c(x, z) || !this.func_186058_p().shouldLoadSpawn();
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        super.setAllowedSpawnTypes(this.field_76579_a.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL, allowPeaceful);
    }

    @Override
    public void setJEDPropertiesFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            NBTTagList list;
            this.useCustomDayCycle = tag.func_74767_n("CustomDayCycle");
            if (tag.func_150297_b("DayLength", 3)) {
                this.dayLength = tag.func_74762_e("DayLength");
            }
            if (tag.func_150297_b("NightLength", 3)) {
                this.nightLength = tag.func_74762_e("NightLength");
            }
            if (tag.func_150297_b("CloudHeight", 3)) {
                this.cloudHeight = tag.func_74762_e("CloudHeight");
            }
            if (tag.func_150297_b("SkyRenderType", 1)) {
                this.skyRenderType = tag.func_74771_c("SkyRenderType");
            }
            if (tag.func_150297_b("SkyDisableFlags", 1)) {
                this.skyDisableFlags = tag.func_74771_c("SkyDisableFlags");
            }
            if (tag.func_150297_b("SkyColor", 8)) {
                this.skyColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("SkyColor"));
            }
            if (tag.func_150297_b("CloudColor", 8)) {
                this.cloudColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("CloudColor"));
            }
            if (tag.func_150297_b("FogColor", 8)) {
                this.fogColor = JEDStringUtils.hexStringToColor(tag.func_74779_i("FogColor"));
            }
            if (tag.func_150297_b("LightBrightness", 9) && (list = tag.func_150295_c("LightBrightness", 5)).func_74745_c() == 16) {
                this.customLightBrightnessTable = new float[16];
                for (int i = 0; i < 16; ++i) {
                    this.customLightBrightnessTable[i] = list.func_150308_e(i);
                }
            }
        }
        if (this.dayLength <= 0) {
            this.dayLength = 1;
        }
        if (this.nightLength <= 0) {
            this.nightLength = 1;
        }
        if (this.skyRenderType != 0) {
            this.setSkyRenderer(new SkyRenderer(this.skyRenderType, this.skyDisableFlags));
        } else {
            this.setSkyRenderer(null);
        }
    }

    @Override
    public void setJEDPropertiesFromWorldInfo(WorldInfoJED worldInfo) {
        this.useCustomDayCycle = worldInfo.getUseCustomDayCycle();
        this.dayLength = worldInfo.getDayLength();
        this.nightLength = worldInfo.getNightLength();
        this.customLightBrightnessTable = worldInfo.getCustomLightBrightnessTable();
        this.canRespawnHere = worldInfo.canRespawnHere();
        this.respawnDimension = worldInfo.getRespawnDimension();
        if (this.dayLength <= 0) {
            this.dayLength = 1;
        }
        if (this.nightLength <= 0) {
            this.nightLength = 1;
        }
    }

    public float[] func_177497_p() {
        if (this.customLightBrightnessTable != null) {
            return this.customLightBrightnessTable;
        }
        return super.func_177497_p();
    }

    public int getDayCycleLength() {
        return this.dayLength + this.nightLength;
    }

    public int func_76559_b(long worldTime) {
        long cycleLength = this.getDayCycleLength();
        return (int)(worldTime / cycleLength % 8L + 8L) % 8;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        float angle;
        if (!this.useCustomDayCycle) {
            return super.func_76563_a(worldTime, partialTicks);
        }
        int cycleLength = this.getDayCycleLength();
        int dayTicks = (int)(worldTime % (long)cycleLength);
        int duskOrDawnLength = (int)(0.075f * (float)cycleLength);
        if (!this.field_76579_a.func_82736_K().func_82766_b("doDaylightCycle")) {
            partialTicks = 0.0f;
        }
        if (dayTicks > cycleLength - duskOrDawnLength || dayTicks < this.dayLength - duskOrDawnLength) {
            dayTicks = dayTicks > this.dayLength ? (dayTicks -= cycleLength - duskOrDawnLength) : (dayTicks += duskOrDawnLength);
            angle = ((float)dayTicks + partialTicks) / (float)this.dayLength * 0.65f + 0.675f;
        } else {
            angle = ((float)(dayTicks -= this.dayLength - duskOrDawnLength) + partialTicks) / (float)this.nightLength * 0.35f + 0.325f;
        }
        if (angle > 1.0f) {
            angle -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
        angle += (f1 - angle) / 3.0f;
        return angle;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity entity, float partialTicks) {
        float thunder;
        Vec3d skyColor = this.skyColor;
        if (skyColor == null) {
            return super.getSkyColor(entity, partialTicks);
        }
        float f1 = MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(x, y, z);
        int blendColour = ForgeHooksClient.getSkyBlendColour((World)this.field_76579_a, (BlockPos)blockpos);
        float r = (float)((double)((float)(blendColour >> 16 & 0xFF) / 255.0f) * skyColor.field_72450_a);
        float g = (float)((double)((float)(blendColour >> 8 & 0xFF) / 255.0f) * skyColor.field_72448_b);
        float b = (float)((double)((float)(blendColour & 0xFF) / 255.0f) * skyColor.field_72449_c);
        r *= f1;
        g *= f1;
        b *= f1;
        float rain = this.field_76579_a.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f7 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f8 = 1.0f - rain * 0.75f;
            r = r * f8 + f7 * (1.0f - f8);
            g = g * f8 + f7 * (1.0f - f8);
            b = b * f8 + f7 * (1.0f - f8);
        }
        if ((thunder = this.field_76579_a.func_72819_i(partialTicks)) > 0.0f) {
            float f11 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float f9 = 1.0f - thunder * 0.75f;
            r = r * f9 + f11 * (1.0f - f9);
            g = g * f9 + f11 * (1.0f - f9);
            b = b * f9 + f11 * (1.0f - f9);
        }
        if (this.field_76579_a.func_175658_ac() > 0) {
            float f12 = (float)this.field_76579_a.func_175658_ac() - partialTicks;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            r = r * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            g = g * (1.0f - f12) + 0.8f * f12;
            b = b * (1.0f - f12) + 1.0f * f12;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        Vec3d cloudColor = this.cloudColor;
        if (cloudColor == null) {
            return super.getCloudColor(partialTicks);
        }
        float f1 = MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        float r = (float)cloudColor.field_72450_a;
        float g = (float)cloudColor.field_72448_b;
        float b = (float)cloudColor.field_72449_c;
        float rain = this.field_76579_a.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f6 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f7 = 1.0f - rain * 0.95f;
            r = r * f7 + f6 * (1.0f - f7);
            g = g * f7 + f6 * (1.0f - f7);
            b = b * f7 + f6 * (1.0f - f7);
        }
        r *= f1 * 0.9f + 0.1f;
        g *= f1 * 0.9f + 0.1f;
        b *= f1 * 0.85f + 0.15f;
        float thunder = this.field_76579_a.func_72819_i(partialTicks);
        if (thunder > 0.0f) {
            float f10 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float f8 = 1.0f - thunder * 0.95f;
            r = r * f8 + f10 * (1.0f - f8);
            g = g * f8 + f10 * (1.0f - f8);
            b = b * f8 + f10 * (1.0f - f8);
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return this.cloudHeight;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Vec3d fogColor = this.fogColor;
        if (fogColor == null) {
            return super.func_76562_b(celestialAngle, partialTicks);
        }
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float r = (float)fogColor.field_72450_a;
        float g = (float)fogColor.field_72448_b;
        float b = (float)fogColor.field_72449_c;
        return new Vec3d((double)(r *= f * 0.94f + 0.06f), (double)(g *= f * 0.94f + 0.06f), (double)(b *= f * 0.91f + 0.09f));
    }
}

