/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.util;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataDump {
    public static final String EMPTY_STRING = "";
    protected final int columns;
    protected Alignment[] alignment;
    protected Row title;
    protected List<Row> headers = new ArrayList<Row>();
    protected List<Row> footers = new ArrayList<Row>();
    protected List<Row> lines = new ArrayList<Row>();
    protected int[] widths;
    protected int totalWidth;
    protected String formatStringColumns;
    protected String formatStringSingleCenter;
    protected String formatStringSingleLeft;
    protected String lineSeparator;
    protected boolean useColumnSeparator = false;
    protected boolean centerTitle = false;
    protected boolean repeatTitleAtBottom = true;
    private boolean sort = true;

    protected DataDump(int columns) {
        this.columns = columns;
        this.alignment = new Alignment[this.columns];
        this.widths = new int[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            this.alignment[i] = Alignment.LEFT;
        }
    }

    protected DataDump setColumnAlignment(int columnId, Alignment align) {
        if (columnId >= this.columns) {
            throw new IllegalArgumentException("Invalid column id '" + columnId + "', max is " + (this.columns - 1));
        }
        this.alignment[columnId] = align;
        return this;
    }

    protected void setSort(boolean sort) {
        this.sort = sort;
    }

    protected void setCenterTitle(boolean center) {
        this.centerTitle = center;
    }

    protected void setRepeatTitleAtBottom(boolean repeat) {
        this.repeatTitleAtBottom = repeat;
    }

    protected void setUseColumnSeparator(boolean value) {
        this.useColumnSeparator = value;
    }

    public void addTitle(String ... data) {
        this.checkHeaderData(data);
        this.title = new Row(data);
    }

    public void addHeader(String ... data) {
        this.checkHeaderData(data);
        this.headers.add(new Row(data));
    }

    public void addFooter(String ... data) {
        this.checkHeaderData(data);
        this.footers.add(new Row(data));
    }

    public void addData(String ... data) {
        this.checkData(data);
        this.lines.add(new Row(data));
    }

    protected void checkHeaderData(String ... data) {
        if (data.length != 1 || this.columns == 1) {
            this.checkData(data);
        }
    }

    protected void checkAllHeaders() {
        if (this.columns != 1) {
            int i;
            this.checkHeaderLength(this.title);
            int size = this.headers.size();
            for (i = 0; i < size; ++i) {
                this.checkHeaderLength(this.headers.get(i));
            }
            size = this.footers.size();
            for (i = 0; i < size; ++i) {
                this.checkHeaderLength(this.footers.get(i));
            }
        }
    }

    private void checkHeaderLength(Row row) {
        Object[] values = row.getValues();
        if (values.length == 1) {
            this.checkHeaderLength(String.valueOf(values[0]));
        }
    }

    private void checkHeaderLength(String header) {
        int columns;
        int space;
        int len = header.length();
        if (len > (space = this.totalWidth + Math.max((columns = this.widths.length) - 1, 0) * 3)) {
            int diff = len - space;
            int n = this.widths.length - 1;
            this.widths[n] = this.widths[n] + diff;
            this.totalWidth += diff;
        }
    }

    protected void checkData(String ... data) {
        if (data.length != this.columns) {
            throw new IllegalArgumentException("Invalid number of columns, you must add exactly " + this.columns + " columns for this type of DataDump");
        }
        int total = 0;
        for (int i = 0; i < data.length; ++i) {
            int width;
            int len = data[i].length();
            if (len > (width = this.widths[i])) {
                this.widths[i] = len;
            }
            total += this.widths[i];
        }
        this.totalWidth = total;
    }

    protected void generateFormatStrings() {
        this.checkAllHeaders();
        String colSep = this.useColumnSeparator ? "|" : " ";
        String lineColSep = this.useColumnSeparator ? "+" : "-";
        StringBuilder sbFmt = new StringBuilder(128);
        StringBuilder sbSep = new StringBuilder(256);
        sbFmt.append(colSep);
        sbSep.append(lineColSep);
        for (int i = 0; i < this.columns; ++i) {
            int width = this.widths[i];
            if (this.alignment[i] == Alignment.LEFT) {
                sbFmt.append(String.format(" %%-%ds %s", width, colSep));
            } else {
                sbFmt.append(String.format(" %%%ds %s", width, colSep));
            }
            for (int j = 0; j < width + 2; ++j) {
                sbSep.append("-");
            }
            sbSep.append(lineColSep);
        }
        this.formatStringColumns = sbFmt.toString();
        this.lineSeparator = sbSep.toString();
        this.formatStringSingleCenter = colSep + " %%%ds%%s%%%ds " + colSep;
        this.formatStringSingleLeft = colSep + " %%-%ds " + colSep;
    }

    protected String getFormattedLine(Row row) {
        Object[] values = row.getValues();
        if (values.length == 1 && this.columns > 1) {
            int space = this.totalWidth + Math.max(this.columns - 1, 0) * 3;
            String fmt = null;
            boolean isCenter = false;
            if (this.centerTitle) {
                String str = String.valueOf(values[0]);
                int len = str.length();
                int start = (space - len) / 2;
                if (start > 0) {
                    fmt = String.format(this.formatStringSingleCenter, start, space - len - start);
                    isCenter = true;
                } else {
                    fmt = String.format(this.formatStringSingleLeft, space);
                }
            } else {
                fmt = String.format(this.formatStringSingleLeft, space);
            }
            return isCenter ? String.format(fmt, " ", values[0], " ") : String.format(fmt, values[0]);
        }
        return String.format(this.formatStringColumns, values);
    }

    protected List<String> getFormattedData(List<String> lines) {
        int i;
        if (this.sort) {
            Collections.sort(this.lines);
        }
        lines.add(this.lineSeparator);
        int len = this.headers.size();
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                lines.add(this.getFormattedLine(this.headers.get(i)));
            }
            lines.add(this.lineSeparator);
        }
        lines.add(this.getFormattedLine(this.title));
        lines.add(this.lineSeparator);
        len = this.lines.size();
        for (i = 0; i < len; ++i) {
            lines.add(this.getFormattedLine(this.lines.get(i)));
        }
        lines.add(this.lineSeparator);
        len = this.footers.size();
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                lines.add(this.getFormattedLine(this.footers.get(i)));
            }
            lines.add(this.lineSeparator);
        }
        if (this.repeatTitleAtBottom) {
            lines.add(this.getFormattedLine(this.title));
            lines.add(this.lineSeparator);
        }
        return lines;
    }

    protected List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.generateFormatStrings();
        this.getFormattedData(lines);
        return lines;
    }

    public static void printDataToLogger(List<String> lines) {
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            JustEnoughDimensions.logger.info(lines.get(i));
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }

    public static class Row
    implements Comparable<Row> {
        private String[] strings;

        public Row(String[] strings) {
            this.strings = strings;
        }

        public Object[] getValues() {
            return this.strings;
        }

        @Override
        public int compareTo(Row other) {
            for (int i = 0; i < this.strings.length; ++i) {
                int res = this.strings[i].compareTo(other.strings[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }
}

