/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.util;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.event.JEDBorderListener;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WorldBorderUtils {
    private static Field field_WorldBorder_listeners = null;
    private static Field field_WorldServerMulti_borderListener = null;

    public static void sendWorldBorder(EntityPlayer player) {
        if (Configs.enableSeparateWorldBorders && !player.func_130014_f_().field_72995_K && player instanceof EntityPlayerMP) {
            JustEnoughDimensions.logInfo("WorldBorderUtils.sendWorldBorder(): Sending the border to player '{}'", player.func_70005_c_());
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketWorldBorder(player.func_130014_f_().func_175723_af(), SPacketWorldBorder.Action.INITIALIZE));
        }
    }

    public static void removeDefaultBorderListeners() {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (Configs.enableSeparateWorldBorders && overworld != null) {
            JustEnoughDimensions.logInfo("WorldBorderUtils.removeDefaultBorderListeners()", new Object[0]);
            try {
                List listeners = (List)field_WorldBorder_listeners.get(overworld.func_175723_af());
                if (listeners != null) {
                    listeners.clear();
                    overworld.func_175723_af().func_177737_a((IBorderListener)new JEDBorderListener(0));
                }
            }
            catch (IllegalArgumentException e) {
                JustEnoughDimensions.logger.warn("Failed to clear default WorldBorder listeners");
            }
            catch (IllegalAccessException e) {
                JustEnoughDimensions.logger.warn("Failed to clear default WorldBorder listeners");
            }
        }
    }

    public static void removeOverworldBorderListener(World world) {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (Configs.enableSeparateWorldBorders && overworld != null && world instanceof WorldServerMulti) {
            JustEnoughDimensions.logInfo("WorldBorderUtils.removeOverworldBorderListener() in dimension {}", world.field_73011_w.getDimension());
            try {
                List overworldListeners = (List)field_WorldBorder_listeners.get(overworld.func_175723_af());
                IBorderListener listener = (IBorderListener)field_WorldServerMulti_borderListener.get(world);
                if (overworldListeners != null) {
                    overworldListeners.remove(listener);
                }
            }
            catch (IllegalArgumentException e) {
                JustEnoughDimensions.logger.warn("Failed to clear default WorldBorder listeners");
            }
            catch (IllegalAccessException e) {
                JustEnoughDimensions.logger.warn("Failed to clear default WorldBorder listeners");
            }
        }
    }

    public static void setWorldBorderValues(World world) {
        WorldBorder border = world.func_175723_af();
        WorldInfo info = world.func_72912_H();
        border.func_177739_c(info.func_176120_C(), info.func_176126_D());
        border.func_177744_c(info.func_176140_I());
        border.func_177724_b(info.func_176138_H());
        border.func_177747_c(info.func_176131_J());
        border.func_177723_b(info.func_176139_K());
        if (info.func_176134_F() > 0L) {
            border.func_177738_a(info.func_176137_E(), info.func_176132_G(), info.func_176134_F());
        } else {
            border.func_177750_a(info.func_176137_E());
        }
    }

    static {
        try {
            field_WorldBorder_listeners = ReflectionHelper.findField(WorldBorder.class, (String[])new String[]{"field_177758_a", "listeners"});
            field_WorldServerMulti_borderListener = ReflectionHelper.findField(WorldServerMulti.class, (String[])new String[]{"borderListener"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            JustEnoughDimensions.logger.error("WorldBorderUtils: Reflection failed!!", (Throwable)e);
        }
    }
}

