/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.util;

import java.io.File;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldFileUtils {
    public static File getWorldDirectory(World world) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (chunkProvider instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)chunkProvider;
            IChunkLoader chunkLoader = chunkProviderServer.field_73247_e;
            if (chunkLoader instanceof AnvilChunkLoader) {
                return ((AnvilChunkLoader)chunkLoader).field_75825_d;
            }
            return null;
        }
        File mainWorldDir = world.func_72860_G().func_75765_b();
        String dimensionDir = world.field_73011_w.getSaveFolder();
        if (dimensionDir != null) {
            mainWorldDir = new File(mainWorldDir, dimensionDir);
            mainWorldDir.mkdirs();
        }
        return mainWorldDir;
    }

    public static boolean levelFileExists(World world) {
        File worldDir = WorldFileUtils.getWorldDirectory(world);
        if (worldDir == null) {
            return false;
        }
        File levelFile = new File(worldDir, "level.dat");
        return levelFile.exists();
    }
}

