/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.util;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import fi.dy.masa.justenoughdimensions.world.util.WorldBorderUtils;
import fi.dy.masa.justenoughdimensions.world.util.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.world.util.WorldUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WorldInfoUtils {
    private static Field field_worldInfo = null;

    public static void loadAndSetCustomWorldInfo(World world) {
        int dimension = world.field_73011_w.getDimension();
        if (!(world.func_72912_H() instanceof WorldInfoJED) && DimensionConfig.instance().useCustomWorldInfoFor(dimension)) {
            JustEnoughDimensions.logInfo("WorldInfoUtils.loadAndSetCustomWorldInfo(): Overriding the existing WorldInfo with WorldInfoJED for dimension {}", dimension);
            WorldInfoUtils.setWorldInfo(world, WorldInfoUtils.createCustomWorldInfoFor(world, dimension));
        }
    }

    private static WorldInfoJED createCustomWorldInfoFor(World world, int dimension) {
        NBTTagCompound nbt = WorldInfoUtils.loadWorldInfoFromFile(world, WorldFileUtils.getWorldDirectory(world));
        NBTTagCompound playerNBT = world.func_72912_H().func_76072_h();
        boolean isDimensionInit = false;
        if (nbt == null) {
            nbt = world.func_72912_H().func_76082_a(playerNBT);
            isDimensionInit = true;
        }
        DimensionConfig.instance().setWorldInfoValues(dimension, nbt, DimensionConfig.WorldInfoType.REGULAR);
        if (isDimensionInit) {
            DimensionConfig.instance().setWorldInfoValues(dimension, nbt, DimensionConfig.WorldInfoType.ONE_TIME);
        }
        return new WorldInfoJED(nbt);
    }

    public static void saveCustomWorldInfoToFile(World world) {
        int dimension = world.field_73011_w.getDimension();
        if (Configs.enableSeparateWorldInfo && !world.field_72995_K && dimension != 0 && DimensionConfig.instance().useCustomWorldInfoFor(dimension)) {
            WorldInfoUtils.saveWorldInfoToFile(world, WorldFileUtils.getWorldDirectory(world));
        }
    }

    private static NBTTagCompound loadWorldInfoFromFile(World world, @Nullable File worldDir) {
        if (worldDir == null) {
            JustEnoughDimensions.logInfo("WorldInfoUtils.loadWorldInfoFromFile(): null worldDir", new Object[0]);
            return null;
        }
        File levelFile = new File(worldDir, "level.dat");
        if (levelFile.exists()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(levelFile));
                nbt = world.func_73046_m().func_184110_aI().func_188257_a((IFixType)FixTypes.LEVEL, nbt.func_74775_l("Data"));
                JustEnoughDimensions.logInfo("WorldInfoUtils.loadWorldInfoFromFile(): Read world info from file '{}'", levelFile.getPath());
                return nbt;
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Exception reading " + levelFile.getPath(), (Throwable)e);
                return null;
            }
        }
        JustEnoughDimensions.logInfo("WorldInfoUtils.loadWorldInfoFromFile(): level.dat didn't exist for dimension {}", world.field_73011_w.getDimension());
        return null;
    }

    private static void setWorldInfo(World world, WorldInfoJED info) {
        if (field_worldInfo != null) {
            try {
                field_worldInfo.set(world, (Object)info);
                if (world.field_73011_w instanceof IWorldProviderJED) {
                    JustEnoughDimensions.logInfo("Setting JED properties in the WorldProvider for dimension {}", world.field_73011_w.getDimension());
                    ((IWorldProviderJED)world.field_73011_w).setJEDPropertiesFromWorldInfo(info);
                    world.field_73011_w.func_76558_a(world);
                }
                WorldBorderUtils.setWorldBorderValues(world);
                if (!(world.field_73011_w instanceof IWorldProviderJED)) {
                    WorldUtils.reCreateChunkProvider(world);
                }
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("WorldInfoUtils.setWorldInfo(): Failed to override WorldInfo for dimension {}", new Object[]{world.field_73011_w.getDimension()});
            }
        }
    }

    private static void saveWorldInfoToFile(World world, @Nullable File worldDir) {
        if (worldDir == null) {
            JustEnoughDimensions.logger.warn("WorldInfoUtils.saveWorldInfoToFile(): No worldDir found");
            return;
        }
        WorldInfo info = world.func_72912_H();
        info.func_176145_a(world.func_175723_af().func_177741_h());
        info.func_176124_d(world.func_175723_af().func_177731_f());
        info.func_176141_c(world.func_175723_af().func_177721_g());
        info.func_176129_e(world.func_175723_af().func_177742_m());
        info.func_176125_f(world.func_175723_af().func_177727_n());
        info.func_176122_j(world.func_175723_af().func_177748_q());
        info.func_176136_k(world.func_175723_af().func_177740_p());
        info.func_176118_b(world.func_175723_af().func_177751_j());
        info.func_176135_e(world.func_175723_af().func_177732_i());
        NBTTagCompound rootTag = new NBTTagCompound();
        NBTTagCompound playerNBT = world.func_73046_m().func_184103_al().func_72378_q();
        rootTag.func_74782_a("Data", (NBTBase)info.func_76082_a(playerNBT));
        if (world.func_72860_G() instanceof SaveHandler) {
            FMLCommonHandler.instance().handleWorldDataSave((SaveHandler)world.func_72860_G(), info, rootTag);
        }
        try {
            File fileNew = new File(worldDir, "level.dat_new");
            File fileOld = new File(worldDir, "level.dat_old");
            File fileCurrent = new File(worldDir, "level.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)rootTag, (OutputStream)new FileOutputStream(fileNew));
            if (fileOld.exists()) {
                fileOld.delete();
            }
            fileCurrent.renameTo(fileOld);
            if (fileCurrent.exists()) {
                JustEnoughDimensions.logger.error("Failed to rename {} to {}", new Object[]{fileCurrent.getPath(), fileOld.getPath()});
                return;
            }
            fileNew.renameTo(fileCurrent);
            if (fileNew.exists()) {
                JustEnoughDimensions.logger.error("Failed to rename {} to {}", new Object[]{fileNew.getPath(), fileCurrent.getPath()});
                return;
            }
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.error("WorldInfoUtils.saveWorldInfoToFile(): Failed to save world info to file for dimension {}", new Object[]{world.field_73011_w.getDimension(), e});
        }
    }

    static {
        try {
            field_worldInfo = ReflectionHelper.findField(World.class, (String[])new String[]{"field_72986_A", "worldInfo"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            JustEnoughDimensions.logger.error("WorldInfoUtils: Reflection failed!!", (Throwable)e);
        }
    }
}

