/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.util;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.client.render.SkyRenderer;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.network.MessageSyncWorldProperties;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import fi.dy.masa.justenoughdimensions.world.WorldProviderHellJED;
import fi.dy.masa.justenoughdimensions.world.util.WorldFileUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WorldUtils {
    private static Field field_WorldProvider_terrainType;
    private static Field field_WorldProvider_generatorSettings;
    private static Field field_WorldProvider_biomeProvider;
    private static Field field_ChunkProviderServer_chunkGenerator;

    public static int getLoadedChunkCount(WorldServer world) {
        return world.func_72863_F().func_73152_e();
    }

    public static int unloadEmptyDimensions(boolean tryUnloadChunks) {
        int count = 0;
        Integer[] dims = DimensionManager.getIDs();
        JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload empty dimensions, tryUnloadChunks = {}", tryUnloadChunks);
        Integer[] integerArray = dims;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload dimension {}", dim);
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            ChunkProviderServer chunkProviderServer = world.func_72863_F();
            if (tryUnloadChunks && chunkProviderServer.func_73152_e() > 0) {
                JustEnoughDimensions.logInfo("WorldUtils.unloadEmptyDimensions(): Trying to unload chunks for dimension {}", dim);
                boolean disable = world.field_73058_d;
                world.field_73058_d = false;
                try {
                    world.func_73044_a(true, (IProgressUpdate)null);
                }
                catch (MinecraftException e) {
                    JustEnoughDimensions.logger.warn("WorldUtils.unloadEmptyDimensions(): Exception while trying to save chunks for dimension {}", new Object[]{world.field_73011_w.getDimension(), e});
                }
                world.field_73058_d = disable;
                chunkProviderServer.func_73156_b();
                if (chunkProviderServer.func_73152_e() != 0) continue;
                ++count;
                continue;
            }
            if (chunkProviderServer.func_73152_e() != 0 || world.field_73011_w.func_186058_p().shouldLoadSpawn() || ForgeChunkManager.getPersistentChunksFor((World)world).size() != 0) continue;
            DimensionManager.unloadWorld((int)world.field_73011_w.getDimension());
            ++count;
        }
        return count;
    }

    public static void syncWorldProviderProperties(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncWorldProperties(player.func_130014_f_()), (EntityPlayerMP)player);
        }
    }

    public static boolean setRenderersOnNonJEDWorld(World world, NBTTagCompound tag) {
        byte skyRenderType = 0;
        byte skyDisableFlags = 0;
        if (tag.func_150297_b("SkyRenderType", 1)) {
            skyRenderType = tag.func_74771_c("SkyRenderType");
        }
        if (tag.func_150297_b("SkyDisableFlags", 1)) {
            skyDisableFlags = tag.func_74771_c("SkyDisableFlags");
        }
        if (skyRenderType != 0) {
            world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyRenderer(skyRenderType, skyDisableFlags));
            return true;
        }
        return false;
    }

    public static void findAndSetWorldSpawn(World world) {
        int dimension = world.field_73011_w.getDimension();
        if (DimensionConfig.instance().useCustomWorldInfoFor(dimension)) {
            boolean isDimensionInit;
            boolean bl = isDimensionInit = !WorldFileUtils.levelFileExists(world);
            if (isDimensionInit) {
                WorldUtils.findAndSetWorldSpawn(world, true);
            }
        }
    }

    public static void overrideWorldProviderSettings(World world, WorldProvider provider) {
        WorldInfo info = world.func_72912_H();
        if (info instanceof WorldInfoJED) {
            try {
                JustEnoughDimensions.logInfo("WorldUtils.overrideWorldProviderSettings(): Trying to override the WorldType and generatorSettings for dimension {}", provider.getDimension());
                field_WorldProvider_terrainType.set(provider, info.func_76067_t());
                field_WorldProvider_generatorSettings.set(provider, info.func_82571_y());
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("WorldUtils.overrideWorldProviderSettings(): Failed to override WorldProvider settings for dimension {}", new Object[]{provider.getDimension()});
            }
        }
    }

    public static void overrideBiomeProvider(World world) {
        Biome biome;
        int dimension = world.field_73011_w.getDimension();
        String biomeName = DimensionConfig.instance().getBiomeFor(dimension);
        Biome biome2 = biome = biomeName != null ? (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName)) : null;
        if (!(biome == null || world.field_73011_w.func_177499_m() instanceof BiomeProviderSingle && world.field_73011_w.func_177499_m().func_180631_a(BlockPos.field_177992_a) == biome)) {
            BiomeProviderSingle biomeProvider = new BiomeProviderSingle(biome);
            JustEnoughDimensions.logInfo("Overriding the BiomeProvider for dimension {} with {} using the biome '{}' ('{}')", dimension, biomeProvider.getClass().getName(), biomeName, biome.func_185359_l());
            try {
                field_WorldProvider_biomeProvider.set(world.field_73011_w, biomeProvider);
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("Failed to override the BiomeProvider of dimension {}", new Object[]{dimension});
            }
        }
    }

    public static void reCreateChunkProvider(World world) {
        if (world instanceof WorldServer && world.func_72863_F() instanceof ChunkProviderServer) {
            int dimension = world.field_73011_w.getDimension();
            WorldInfo info = world.func_72912_H();
            WorldInfo infoOverWorld = world.func_73046_m().func_71218_a(0).func_72912_H();
            if (infoOverWorld.func_76067_t() == info.func_76067_t() && infoOverWorld.func_82571_y().equals(info.func_82571_y())) {
                JustEnoughDimensions.logInfo("No need to re-create the ChunkProvider in dimension {}", dimension);
                return;
            }
            world.field_73011_w.func_76558_a(world);
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
            IChunkGenerator newChunkProvider = world.field_73011_w.func_186060_c();
            if (newChunkProvider == null) {
                JustEnoughDimensions.logger.warn("Failed to re-create the ChunkProvider for dimension {}", new Object[]{dimension});
                return;
            }
            JustEnoughDimensions.logInfo("Attempting to override/re-create the ChunkProvider (of type {}) in dimension {} with {}", chunkProviderServer.field_186029_c.getClass().getName(), dimension, newChunkProvider.getClass().getName());
            try {
                field_ChunkProviderServer_chunkGenerator.set(chunkProviderServer, newChunkProvider);
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to re-create the ChunkProvider for dimension {} with {}", new Object[]{dimension, newChunkProvider.getClass().getName(), e});
            }
        }
    }

    public static void findAndSetWorldSpawn(World world, boolean fireEvent) {
        WorldSettings worldSettings = new WorldSettings(world.func_72912_H());
        WorldProvider provider = world.field_73011_w;
        JustEnoughDimensions.logInfo("Trying to find a world spawn for dimension {}...", provider.getDimension());
        if (fireEvent && ForgeEventFactory.onCreateWorldSpawn((World)world, (WorldSettings)worldSettings)) {
            JustEnoughDimensions.logInfo("Exiting due to a canceled WorldEvent.CreateSpawnPosition event!", new Object[0]);
            return;
        }
        BlockPos pos = WorldUtils.findSuitableSpawnpoint(world);
        world.func_72912_H().func_176143_a(pos);
        JustEnoughDimensions.logInfo("Set the world spawnpoint of dimension {} to {}", provider.getDimension(), pos);
        WorldBorder border = world.func_175723_af();
        if (!border.func_177746_a(pos)) {
            border.func_177739_c((double)pos.func_177958_n(), (double)pos.func_177952_p());
            JustEnoughDimensions.logInfo("Moved the WorldBorder of dimension {} to the world's spawn, because the spawn was outside the border", provider.getDimension());
        }
    }

    @Nonnull
    public static BlockPos findSuitableSpawnpoint(World world) {
        BlockPos pos;
        WorldProvider provider = world.field_73011_w;
        if (provider.func_186058_p() == DimensionType.THE_END || provider instanceof WorldProviderEnd) {
            pos = provider.func_177496_h();
            if (pos == null) {
                pos = WorldUtils.getSuitableSpawnBlockInColumn(world, BlockPos.field_177992_a);
            }
        } else {
            pos = provider.func_186058_p() == DimensionType.NETHER || provider instanceof WorldProviderHell || provider instanceof WorldProviderHellJED ? WorldUtils.findNetherSpawnpoint(world) : (world.func_72912_H().func_76067_t() == WorldType.field_180272_g ? BlockPos.field_177992_a.func_177981_b(64) : WorldUtils.findOverworldSpawnpoint(world));
        }
        return pos;
    }

    @Nonnull
    private static BlockPos findNetherSpawnpoint(World world) {
        Random random = new Random(world.func_72905_C());
        int x = 0;
        int z = 0;
        BlockPos pos = new BlockPos(x, 120, z);
        for (int iterations = 0; iterations < 100; ++iterations) {
            while (pos.func_177956_o() >= 30) {
                if (world.func_175623_d(pos) && world.func_175623_d(pos.func_177979_c(1)) && world.func_180495_p(pos.func_177979_c(2)).func_185904_a().func_76230_c()) {
                    return pos.func_177977_b();
                }
                pos = pos.func_177977_b();
            }
            pos = new BlockPos(x += random.nextInt(32) - random.nextInt(32), 120, z += random.nextInt(32) - random.nextInt(32));
        }
        JustEnoughDimensions.logger.warn("Unable to find a nether spawn point for dimension {}", new Object[]{world.field_73011_w.getDimension()});
        return new BlockPos(0, 70, 0);
    }

    @Nonnull
    private static BlockPos findOverworldSpawnpoint(World world) {
        WorldProvider provider = world.field_73011_w;
        BiomeProvider biomeProvider = provider.func_177499_m();
        List list = biomeProvider.func_76932_a();
        Random random = new Random(world.func_72905_C());
        int x = 8;
        int z = 8;
        BlockPos pos = biomeProvider.func_180630_a(0, 0, 512, list, random);
        if (pos != null) {
            x = pos.func_177958_n();
            z = pos.func_177952_p();
        } else {
            JustEnoughDimensions.logger.warn("Unable to find spawn biome for dimension {}", new Object[]{provider.getDimension()});
        }
        for (int iterations = 0; iterations < 1000; ++iterations) {
            Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
            pos = new BlockPos(x, chunk.func_76625_h() + 15, z);
            while (pos.func_177956_o() >= 0) {
                if (WorldUtils.isSuitableSpawnBlock(world, pos)) {
                    return pos.func_177984_a();
                }
                pos = pos.func_177977_b();
            }
            x += random.nextInt(32) - random.nextInt(32);
            z += random.nextInt(32) - random.nextInt(32);
        }
        return WorldUtils.getSuitableSpawnBlockInColumn(world, new BlockPos(x, 70, z)).func_177984_a();
    }

    @Nonnull
    private static BlockPos getSuitableSpawnBlockInColumn(World world, BlockPos posIn) {
        Chunk chunk = world.func_175726_f(posIn);
        BlockPos pos = new BlockPos(posIn.func_177958_n(), chunk.func_76625_h() + 15, posIn.func_177952_p());
        while (pos.func_177956_o() >= 0) {
            if (WorldUtils.isSuitableSpawnBlock(world, pos)) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return posIn;
    }

    private static boolean isSuitableSpawnBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Material materialUp1 = world.func_180495_p(pos.func_177981_b(1)).func_185904_a();
        Material materialUp2 = world.func_180495_p(pos.func_177981_b(2)).func_185904_a();
        return state.func_185904_a().func_76230_c() && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) && !state.func_177230_c().isFoliage((IBlockAccess)world, pos) && !materialUp1.func_76230_c() && !materialUp1.func_76224_d() && !materialUp2.func_76230_c() && !materialUp2.func_76224_d();
    }

    static {
        field_WorldProvider_biomeProvider = null;
        field_ChunkProviderServer_chunkGenerator = null;
        try {
            field_WorldProvider_terrainType = ReflectionHelper.findField(WorldProvider.class, (String[])new String[]{"field_76577_b", "terrainType"});
            field_WorldProvider_generatorSettings = ReflectionHelper.findField(WorldProvider.class, (String[])new String[]{"field_82913_c", "generatorSettings"});
            field_WorldProvider_biomeProvider = ReflectionHelper.findField(WorldProvider.class, (String[])new String[]{"field_76578_c", "biomeProvider"});
            field_ChunkProviderServer_chunkGenerator = ReflectionHelper.findField(ChunkProviderServer.class, (String[])new String[]{"field_186029_c", "chunkGenerator"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            JustEnoughDimensions.logger.error("WorldUtils: Reflection failed!!", (Throwable)e);
        }
    }
}

