/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseTileBlock;
import appeng.tile.networking.TileController;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockController
extends AEBaseTileBlock {
    public static final PropertyEnum<ControllerBlockState> CONTROLLER_STATE = PropertyEnum.func_177709_a((String)"state", ControllerBlockState.class);
    public static final PropertyEnum<ControllerRenderType> CONTROLLER_TYPE = PropertyEnum.func_177709_a((String)"type", ControllerRenderType.class);

    public BlockController() {
        super(Material.field_151573_f);
        this.setTileEntity(TileController.class);
        this.func_149711_c(6.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(CONTROLLER_STATE, (Comparable)((Object)ControllerBlockState.offline)).func_177226_a(CONTROLLER_TYPE, (Comparable)((Object)ControllerRenderType.block)));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{CONTROLLER_STATE, CONTROLLER_TYPE};
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, this.getAEStates());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean zz;
        int z;
        int y;
        ControllerRenderType type = ControllerRenderType.block;
        int x = pos.func_177958_n();
        boolean xx = this.getTileEntity(world, x - 1, y = pos.func_177956_o(), z = pos.func_177952_p()) instanceof TileController && this.getTileEntity(world, x + 1, y, z) instanceof TileController;
        boolean yy = this.getTileEntity(world, x, y - 1, z) instanceof TileController && this.getTileEntity(world, x, y + 1, z) instanceof TileController;
        boolean bl = zz = this.getTileEntity(world, x, y, z - 1) instanceof TileController && this.getTileEntity(world, x, y, z + 1) instanceof TileController;
        if (xx && !yy && !zz) {
            type = ControllerRenderType.column_x;
        } else if (!xx && yy && !zz) {
            type = ControllerRenderType.column_y;
        } else if (!xx && !yy && zz) {
            type = ControllerRenderType.column_z;
        } else if ((xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) >= 2) {
            int v = (Math.abs(x) + Math.abs(y) + Math.abs(z)) % 2;
            type = v == 0 ? ControllerRenderType.inside_a : ControllerRenderType.inside_b;
        }
        return state.func_177226_a(CONTROLLER_TYPE, (Comparable)((Object)type));
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((ControllerBlockState)((Object)state.func_177229_b(CONTROLLER_STATE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        ControllerBlockState state = ControllerBlockState.values()[meta];
        return this.func_176223_P().func_177226_a(CONTROLLER_STATE, (Comparable)((Object)state));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World w, BlockPos pos, Block neighborBlock) {
        TileController tc = (TileController)this.getTileEntity((IBlockAccess)w, pos);
        if (tc != null) {
            tc.onNeighborChange(false);
        }
    }

    public static enum ControllerRenderType implements IStringSerializable
    {
        block,
        column_x,
        column_y,
        column_z,
        inside_a,
        inside_b;


        public String func_176610_l() {
            return this.name();
        }
    }

    public static enum ControllerBlockState implements IStringSerializable
    {
        offline,
        online,
        conflicted;


        public String func_176610_l() {
            return this.name();
        }
    }
}

