/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.paint;

import appeng.block.paint.BlockPaint;
import appeng.block.paint.PaintSplotches;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.helpers.Splotch;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

class PaintBakedModel
implements IBakedModel {
    private static final ResourceLocation TEXTURE_PAINT1 = new ResourceLocation("appliedenergistics2", "blocks/paint1");
    private static final ResourceLocation TEXTURE_PAINT2 = new ResourceLocation("appliedenergistics2", "blocks/paint2");
    private static final ResourceLocation TEXTURE_PAINT3 = new ResourceLocation("appliedenergistics2", "blocks/paint3");
    private final VertexFormat vertexFormat;
    private final TextureAtlasSprite[] textures;

    PaintBakedModel(VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.vertexFormat = vertexFormat;
        this.textures = new TextureAtlasSprite[]{(TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_PAINT1), (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_PAINT2), (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_PAINT3)};
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (!(state instanceof IExtendedBlockState)) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(1);
            CubeBuilder builder = new CubeBuilder(this.vertexFormat, quads);
            builder.setTexture(this.textures[0]);
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            return quads;
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        PaintSplotches splotchesState = (PaintSplotches)extendedBlockState.getValue((IUnlistedProperty)BlockPaint.SPLOTCHES);
        if (splotchesState == null) {
            return Collections.emptyList();
        }
        List<Splotch> splotches = splotchesState.getSplotches();
        CubeBuilder builder = new CubeBuilder(this.vertexFormat);
        float offsetConstant = 0.001f;
        for (Splotch s : splotches) {
            if (s.isLumen()) {
                builder.setColorRGB(s.getColor().whiteVariant);
                builder.setRenderFullBright(true);
            } else {
                builder.setColorRGB(s.getColor().mediumVariant);
                builder.setRenderFullBright(false);
            }
            float offset = offsetConstant;
            offsetConstant += 0.001f;
            float buffer = 0.1f;
            float pos_x = s.x();
            float pos_y = s.y();
            pos_x = Math.max(0.1f, Math.min(0.9f, pos_x));
            pos_y = Math.max(0.1f, Math.min(0.9f, pos_y));
            TextureAtlasSprite ico = this.textures[s.getSeed() % this.textures.length];
            builder.setTexture(ico);
            builder.setCustomUv(s.getSide().func_176734_d(), 0.0f, 0.0f, 16.0f, 16.0f);
            switch (s.getSide()) {
                case UP: {
                    offset = 1.0f - offset;
                    builder.addQuad(EnumFacing.DOWN, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case DOWN: {
                    builder.addQuad(EnumFacing.UP, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case EAST: {
                    offset = 1.0f - offset;
                    builder.addQuad(EnumFacing.WEST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case WEST: {
                    builder.addQuad(EnumFacing.EAST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case SOUTH: {
                    offset = 1.0f - offset;
                    builder.addQuad(EnumFacing.NORTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
                case NORTH: {
                    builder.addQuad(EnumFacing.SOUTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
            }
        }
        return builder.getOutput();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.textures[0];
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static List<ResourceLocation> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_PAINT1, (Object)TEXTURE_PAINT2, (Object)TEXTURE_PAINT3);
    }
}

