/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BeehiveWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!HarvestCraft.config.enableBeehiveGeneration) {
            return;
        }
        Biome biome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return;
        }
        BeehiveWorldGen.tryGenerateBeehives(world, random, chunkX * 16, chunkZ * 16);
    }

    private static void tryGenerateBeehives(World world, Random random, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos variableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < HarvestCraft.config.beehiveRarity; ++i) {
            int newY;
            int x = chunkX + random.nextInt(16);
            int y = random.nextInt(128) - 1;
            int z = chunkZ + random.nextInt(16);
            variableBlockPos.func_181079_c(x, y, z);
            if (!BeehiveWorldGen.isBlockLeaves(world, (BlockPos)variableBlockPos) || (newY = BeehiveWorldGen.getHeightBelowLeaves(world, x, y, z)) < 0) continue;
            variableBlockPos.func_185336_p(newY);
            world.func_175656_a((BlockPos)variableBlockPos, BlockRegistry.beehive.func_176223_P());
        }
    }

    private static boolean isBlockLeaves(World world, BlockPos blockPos) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        return block == Blocks.field_150362_t || block == Blocks.field_150361_u;
    }

    private static int getHeightBelowLeaves(World world, int posX, int posY, int posZ) {
        BlockPos.MutableBlockPos variableBlockPos = new BlockPos.MutableBlockPos();
        variableBlockPos.func_181079_c(posX, posY, posZ);
        int sealevel = world.func_181545_F();
        for (int y = posY; y >= sealevel; --y) {
            variableBlockPos.func_185336_p(y);
            Block block = world.func_180495_p((BlockPos)variableBlockPos).func_177230_c();
            if (block == Blocks.field_150362_t || block == Blocks.field_150361_u) continue;
            if (world.func_175623_d((BlockPos)variableBlockPos)) {
                return y;
            }
            return -1;
        }
        return -1;
    }
}

