/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleAttack
extends Particle {
    public static final VertexFormat VERTEX_FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    protected TextureManager textureManager;
    protected int life;
    protected int lifeTime;
    protected float size;
    protected double field_187135_o;
    protected int animPhases;
    protected int animPerRow;

    public ParticleAttack(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, TextureManager textureManager) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.textureManager = textureManager;
        this.life = 0;
        this.init();
    }

    protected void init() {
        this.lifeTime = 4;
        this.size = 1.0f;
        this.field_187135_o = 1.0;
        this.animPerRow = 4;
        this.animPhases = 8;
    }

    protected abstract ResourceLocation getTexture();

    protected VertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float progress = ((float)this.life + partialTicks) / (float)this.lifeTime;
        int i = (int)(progress * (float)this.animPhases);
        int rows = MathHelper.func_76123_f((float)((float)this.animPhases / (float)this.animPerRow));
        if (i < this.animPhases) {
            this.textureManager.func_110577_a(this.getTexture());
            float f = (float)(i % this.animPerRow) / (float)this.animPerRow;
            float f1 = f + 1.0f / (float)this.animPerRow - 0.005f;
            float f2 = (float)(i / this.animPerRow) / (float)rows;
            float f3 = f2 + 1.0f / (float)rows - 0.005f;
            float f4 = 0.5f * this.size;
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            if (Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.LEFT) {
                float t = f;
                f = f1;
                f1 = t;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            worldRendererIn.func_181668_a(7, this.getVertexFormat());
            worldRendererIn.func_181662_b((double)(f5 - rotationX * f4 - rotationXY * f4), (double)f6 - (double)(rotationZ * f4) * this.field_187135_o, (double)(f7 - rotationYZ * f4 - rotationXZ * f4)).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            worldRendererIn.func_181662_b((double)(f5 - rotationX * f4 + rotationXY * f4), (double)f6 + (double)(rotationZ * f4) * this.field_187135_o, (double)(f7 - rotationYZ * f4 + rotationXZ * f4)).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            worldRendererIn.func_181662_b((double)(f5 + rotationX * f4 + rotationXY * f4), (double)f6 + (double)(rotationZ * f4) * this.field_187135_o, (double)(f7 + rotationYZ * f4 + rotationXZ * f4)).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            worldRendererIn.func_181662_b((double)(f5 + rotationX * f4 - rotationXY * f4), (double)f6 - (double)(rotationZ * f4) * this.field_187135_o, (double)(f7 + rotationYZ * f4 - rotationXZ * f4)).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179145_e();
        }
    }

    public int func_189214_a(float p_189214_1_) {
        return 61680;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        ++this.life;
        if (this.life == this.lifeTime) {
            this.func_187112_i();
        }
    }

    public int func_70537_b() {
        return 3;
    }
}

