/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public abstract class MaterialEvent
extends TinkerEvent {
    public final Material material;

    public MaterialEvent(Material material) {
        this.material = material;
    }

    @Cancelable
    public static class IntegrationEvent
    extends MaterialEvent {
        public final MaterialIntegration materialIntegration;

        public IntegrationEvent(Material material, MaterialIntegration materialIntegration) {
            super(material);
            this.materialIntegration = materialIntegration;
        }
    }

    @Cancelable
    public static class TraitRegisterEvent<T extends ITrait>
    extends MaterialEvent {
        public final T trait;

        public TraitRegisterEvent(Material material, T trait) {
            super(material);
            this.trait = trait;
        }
    }

    @Event.HasResult
    public static class StatRegisterEvent<T extends IMaterialStats>
    extends MaterialEvent {
        public final T stats;
        public T newStats;

        public StatRegisterEvent(Material material, T stats) {
            super(material);
            this.stats = stats;
        }

        public void overrideResult(T newStats) {
            if (!this.stats.getIdentifier().equals(newStats.getIdentifier())) {
                TinkerRegistry.log.error("StatRegisterEvent: New stats don't match old stats type. New is {}, old was {}", new Object[]{newStats.getIdentifier(), this.stats.getIdentifier()});
                return;
            }
            this.newStats = newStats;
            this.setResult(Event.Result.ALLOW);
        }
    }

    @Cancelable
    public static class MaterialRegisterEvent
    extends MaterialEvent {
        public MaterialRegisterEvent(Material material) {
            super(material);
        }
    }
}

