/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.chameleon.block.ChamLockableTileEntity;
import com.jaquadro.minecraft.chameleon.block.tiledata.CustomNameData;
import com.jaquadro.minecraft.chameleon.block.tiledata.LockableData;
import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroupInteractive;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IQuantifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.storage.IUpgradeProvider;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityDrawers
extends ChamLockableTileEntity
implements IDrawerGroupInteractive,
IUpgradeProvider,
IItemLockable,
ISealable,
IProtectable,
IQuantifiable {
    private LockableData lockData = new LockableData();
    private CustomNameData customNameData = new CustomNameData("storageDrawers.container.drawers");
    public final ControllerData controllerData = new ControllerData();
    private IDrawer[] drawers;
    private int direction;
    private String material;
    private int drawerCapacity = 1;
    private boolean shrouded = false;
    private boolean quantified = false;
    private boolean taped = false;
    private boolean hideUpgrade = false;
    private UUID owner;
    private String securityKey;
    private EnumSet<LockAttribute> lockAttributes = null;
    private ItemStack[] upgrades = new ItemStack[5];
    private long lastClickTime;
    private UUID lastClickUUID;
    private ItemStack materialSide;
    private ItemStack materialFront;
    private ItemStack materialTrim;
    private IItemHandler itemHandler;

    protected TileEntityDrawers(int drawerCount) {
        this.injectData((TileDataShim)this.lockData);
        this.injectData((TileDataShim)this.customNameData);
        this.injectData(this.controllerData);
        this.initWithDrawerCount(drawerCount);
    }

    protected abstract IDrawer createDrawer(int var1);

    protected void initWithDrawerCount(int drawerCount) {
        this.drawers = new IDrawer[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.drawers[i] = this.createDrawer(i);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getMaterialOrDefault() {
        String mat = this.getMaterial();
        return mat != null ? mat : "oak";
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public int getMaxStorageLevel() {
        int maxLevel = 1;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgradeStorage) continue;
            maxLevel = Math.max(maxLevel, upgrade.func_77952_i());
        }
        return maxLevel;
    }

    public int getEffectiveStorageLevel() {
        int level = 0;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgradeStorage) continue;
            level += upgrade.func_77952_i();
        }
        return Math.max(level, 1);
    }

    public int getEffectiveStorageMultiplier() {
        ConfigManager config = StorageDrawers.config;
        int multiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeStorage) continue;
            int level = EnumUpgradeStorage.byMetadata(stack.func_77952_i()).getLevel();
            multiplier += config.getStorageUpgradeMultiplier(level);
        }
        if (multiplier == 0) {
            multiplier = config.getStorageUpgradeMultiplier(1);
        }
        return multiplier;
    }

    public int getEffectiveStatusLevel() {
        int maxLevel = -1;
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgradeStatus) continue;
            maxLevel = upgrade.func_77952_i();
        }
        if (maxLevel == -1) {
            return 0;
        }
        return EnumUpgradeStatus.byMetadata(maxLevel).getLevel();
    }

    public int getUpgradeSlotCount() {
        return 5;
    }

    public ItemStack getUpgrade(int slot) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)4);
        return this.upgrades[slot];
    }

    public boolean addUpgrade(ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public void setUpgrade(int slot, ItemStack upgrade) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)4);
        if (upgrade != null) {
            upgrade = upgrade.func_77946_l();
            upgrade.field_77994_a = 1;
        }
        this.upgrades[slot] = upgrade;
        if (this.func_145831_w() != null) {
            if (!this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.func_145831_w().func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q());
        }
        this.attributeChanged();
    }

    public boolean canAddUpgrade(ItemStack upgrade) {
        if (upgrade == null) {
            return false;
        }
        if (!(upgrade.func_77973_b() instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)upgrade.func_77973_b();
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            ItemUpgrade reference;
            if (stack == null || !(stack.func_77973_b() instanceof ItemUpgrade) || candidate != (reference = (ItemUpgrade)stack.func_77973_b())) continue;
            return false;
        }
        return true;
    }

    public int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int getDrawerCapacity() {
        return this.drawerCapacity;
    }

    @Deprecated
    public void setDrawerCapacity(int stackCount) {
        this.drawerCapacity = stackCount;
        this.attributeChanged();
    }

    public boolean canAddOneStackUpgrade() {
        if (this.getEffectiveDrawerCapacity() == 1) {
            return false;
        }
        int storageMult = this.getEffectiveStorageMultiplier();
        int lostStackCapacity = storageMult * (this.getEffectiveDrawerCapacity() - 1);
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawerIfEnabled(i);
            if (drawer == null || drawer.isEmpty()) continue;
            int lostItemCapacity = lostStackCapacity * drawer.getStoredItemStackSize();
            if (drawer.getMaxCapacity() - lostItemCapacity >= drawer.getStoredItemCount()) continue;
            return false;
        }
        return true;
    }

    public int getEffectiveDrawerCapacity() {
        for (ItemStack upgrade : this.upgrades) {
            if (upgrade == null || upgrade.func_77973_b() != ModItems.upgradeOneStack) continue;
            return 1;
        }
        return this.getDrawerCapacity();
    }

    protected void attributeChanged() {
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (drawer == null) continue;
            drawer.attributeChanged();
        }
    }

    @Override
    public boolean isItemLocked(LockAttribute attr) {
        if (!StorageDrawers.config.cache.enableLockUpgrades || this.lockAttributes == null) {
            return false;
        }
        return this.lockAttributes.contains((Object)attr);
    }

    @Override
    public boolean canItemLock(LockAttribute attr) {
        return StorageDrawers.config.cache.enableLockUpgrades;
    }

    @Override
    public void setItemLocked(LockAttribute attr, boolean isLocked) {
        if (!StorageDrawers.config.cache.enableLockUpgrades) {
            return;
        }
        if (isLocked && (this.lockAttributes == null || !this.lockAttributes.contains((Object)attr))) {
            if (this.lockAttributes == null) {
                this.lockAttributes = EnumSet.of(attr);
            } else {
                this.lockAttributes.add(attr);
            }
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        } else if (!isLocked && this.lockAttributes != null && this.lockAttributes.contains((Object)attr)) {
            this.lockAttributes.remove((Object)attr);
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
    }

    @Override
    public boolean isShrouded() {
        if (!StorageDrawers.config.cache.enableShroudUpgrades) {
            return false;
        }
        return this.shrouded;
    }

    public void setIsShrouded(boolean shrouded) {
        if (this.shrouded != shrouded) {
            this.shrouded = shrouded;
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
    }

    @Override
    public boolean isShowingQuantity() {
        if (!StorageDrawers.config.cache.enableQuantifiableUpgrades) {
            return false;
        }
        return this.quantified;
    }

    @Override
    public boolean setIsShowingQuantity(boolean quantified) {
        if (!StorageDrawers.config.cache.enableQuantifiableUpgrades) {
            return false;
        }
        if (this.quantified != quantified) {
            this.quantified = quantified;
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            }
        }
        return true;
    }

    @Override
    public UUID getOwner() {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return StorageDrawers.securityRegistry.getProvider(this.securityKey);
    }

    @Override
    public ILockableContainer getLockableContainer() {
        return this;
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    public boolean shouldHideUpgrades() {
        return this.hideUpgrade;
    }

    public void setShouldHideUpgrades(boolean hide) {
        this.hideUpgrade = hide;
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.func_70296_d();
            this.markBlockForUpdate();
        }
    }

    @Override
    public boolean isSealed() {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        return this.taped;
    }

    @Override
    public boolean setIsSealed(boolean sealed) {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        if (this.taped != sealed) {
            this.taped = sealed;
            this.attributeChanged();
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public boolean isVoid() {
        if (!StorageDrawers.config.cache.enableVoidUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeVoid) continue;
            return true;
        }
        return false;
    }

    public boolean isUnlimited() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeCreative) continue;
            return true;
        }
        return false;
    }

    public boolean isVending() {
        if (!StorageDrawers.config.cache.enableCreativeUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeCreative || stack.func_77952_i() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isRedstone() {
        if (!StorageDrawers.config.cache.enableRedstoneUpgrades) {
            return false;
        }
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeRedstone) continue;
            return true;
        }
        return false;
    }

    public int getRedstoneLevel() {
        int redstoneType = -1;
        for (ItemStack stack : this.upgrades) {
            if (stack == null || stack.func_77973_b() != ModItems.upgradeRedstone) continue;
            redstoneType = stack.func_77952_i();
            break;
        }
        switch (redstoneType) {
            case 0: {
                return this.getCombinedRedstoneLevel();
            }
            case 1: {
                return this.getMaxRedstoneLevel();
            }
            case 2: {
                return this.getMinRedstoneLevel();
            }
        }
        return 0;
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawerIfEnabled(i);
            if (drawer == null) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawerIfEnabled(i);
            if (drawer == null) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawerIfEnabled(i);
            if (drawer == null || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @Override
    public boolean isSorting() {
        return false;
    }

    public ItemStack getMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getMaterialFront() {
        return this.materialFront;
    }

    public ItemStack getMaterialTrim() {
        return this.materialTrim;
    }

    public ItemStack getEffectiveMaterialSide() {
        return this.materialSide;
    }

    public ItemStack getEffectiveMaterialFront() {
        return this.materialFront != null ? this.materialFront : this.materialSide;
    }

    public ItemStack getEffectiveMaterialTrim() {
        return this.materialTrim != null ? this.materialTrim : this.materialSide;
    }

    public void setMaterialSide(ItemStack material) {
        this.materialSide = material;
    }

    public void setMaterialFront(ItemStack material) {
        this.materialFront = material;
    }

    public void setMaterialTrim(ItemStack material) {
        this.materialTrim = material;
    }

    @Override
    public ItemStack takeItemsFromSlot(int slot, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return null;
        }
        ItemStack stack = this.getItemsFromSlot(slot, count);
        if (stack == null) {
            return null;
        }
        IDrawer drawer = this.drawers[slot];
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.field_77994_a);
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.func_145831_w().func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q());
        }
        return stack;
    }

    protected ItemStack getItemsFromSlot(int slot, int count) {
        if (this.drawers[slot].isEmpty()) {
            return null;
        }
        ItemStack stack = this.drawers[slot].getStoredItemCopy();
        stack.field_77994_a = Math.min(stack.func_77976_d(), count);
        stack.field_77994_a = Math.min(stack.field_77994_a, this.drawers[slot].getStoredItemCount());
        return stack;
    }

    @Override
    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return 0;
        }
        IDrawer drawer = this.drawers[slot];
        if (drawer.isEmpty()) {
            drawer.setStoredItem(stack, 0);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.field_77994_a);
        if (!this.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.field_77994_a -= countAdded;
        return countAdded;
    }

    @Override
    public int interactPutCurrentItemIntoSlot(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.field_71071_by.func_70448_g();
        if (playerStack != null) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.field_77994_a);
        }
        return count;
    }

    @Override
    public int interactPutCurrentInventoryIntoSlot(int slot, EntityPlayer player) {
        if (slot < 0 || slot >= this.getDrawerCount()) {
            return 0;
        }
        int count = 0;
        if (!this.drawers[slot].isEmpty()) {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack == null) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.field_77994_a);
                if (subCount > 0 && subStack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(i, null);
                }
                count += subCount;
            }
        }
        if (count > 0) {
            StorageDrawers.proxy.updatePlayerInventory(player);
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, EntityPlayer player) {
        int count = 0;
        count = this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    private void readLegacyUpgradeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Lev") && tag.func_74771_c("Lev") > 1) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeStorage, 1, EnumUpgradeStorage.byLevel(tag.func_74771_c("Lev")).getMetadata()));
        }
        if (tag.func_74764_b("Stat")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeStatus, 1, EnumUpgradeStatus.byLevel(tag.func_74771_c("Stat")).getMetadata()));
        }
        if (tag.func_74764_b("Void")) {
            this.addUpgrade(new ItemStack((Item)ModItems.upgradeVoid));
        }
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
        super.readFromFixedNBT(tag);
        this.setDirection(tag.func_74771_c("Dir"));
        this.taped = false;
        if (tag.func_74764_b("Tape")) {
            this.taped = tag.func_74767_n("Tape");
        }
    }

    protected NBTTagCompound writeToFixedNBT(NBTTagCompound tag) {
        tag = super.writeToFixedNBT(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
        if (this.taped) {
            tag.func_74757_a("Tape", this.taped);
        }
        return tag;
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
        int i;
        super.readFromPortableNBT(tag);
        this.upgrades = new ItemStack[this.upgrades.length];
        this.material = null;
        if (tag.func_74764_b("Mat")) {
            this.material = tag.func_74779_i("Mat");
        }
        this.drawerCapacity = tag.func_74762_e("Cap");
        if (!tag.func_74764_b("Upgrades")) {
            this.readLegacyUpgradeNBT(tag);
        } else {
            NBTTagList upgradeList = tag.func_150295_c("Upgrades", 10);
            for (i = 0; i < upgradeList.func_74745_c(); ++i) {
                NBTTagCompound upgradeTag = upgradeList.func_150305_b(i);
                byte slot = upgradeTag.func_74771_c("Slot");
                this.setUpgrade(slot, ItemStack.func_77949_a((NBTTagCompound)upgradeTag));
            }
        }
        this.lockAttributes = null;
        if (tag.func_74764_b("Lock")) {
            this.lockAttributes = LockAttribute.getEnumSet(tag.func_74771_c("Lock"));
        }
        this.shrouded = false;
        if (tag.func_74764_b("Shr")) {
            this.shrouded = tag.func_74767_n("Shr");
        }
        this.quantified = false;
        if (tag.func_74764_b("Qua")) {
            this.quantified = tag.func_74767_n("Qua");
        }
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        this.securityKey = null;
        if (tag.func_74764_b("Sec")) {
            this.securityKey = tag.func_74779_i("Sec");
        }
        this.hideUpgrade = false;
        if (tag.func_74764_b("HideUp")) {
            this.hideUpgrade = tag.func_74767_n("HideUp");
        }
        NBTTagList slots = tag.func_150295_c("Slots", 10);
        this.drawers = new IDrawer[slots.func_74745_c()];
        int n = this.drawers.length;
        for (i = 0; i < n; ++i) {
            NBTTagCompound slot = slots.func_150305_b(i);
            this.drawers[i] = this.createDrawer(i);
            this.drawers[i].readFromNBT(slot);
        }
        this.materialSide = null;
        if (tag.func_74764_b("MatS")) {
            this.materialSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
        }
        this.materialFront = null;
        if (tag.func_74764_b("MatF")) {
            this.materialFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
        }
        this.materialTrim = null;
        if (tag.func_74764_b("MatT")) {
            this.materialTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
        }
        this.attributeChanged();
    }

    public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
        NBTTagCompound itag;
        tag = super.writeToPortableNBT(tag);
        tag.func_74768_a("Cap", this.getDrawerCapacity());
        if (this.material != null) {
            tag.func_74778_a("Mat", this.material);
        }
        NBTTagList upgradeList = new NBTTagList();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null) continue;
            IDrawer[] upgradeTag = this.upgrades[i].func_77955_b(new NBTTagCompound());
            upgradeTag.func_74774_a("Slot", (byte)i);
            upgradeList.func_74742_a((NBTBase)upgradeTag);
        }
        if (upgradeList.func_74745_c() > 0) {
            tag.func_74782_a("Upgrades", (NBTBase)upgradeList);
        }
        if (this.lockAttributes != null) {
            tag.func_74774_a("Lock", (byte)LockAttribute.getBitfield(this.lockAttributes));
        }
        if (this.shrouded) {
            tag.func_74757_a("Shr", this.shrouded);
        }
        if (this.quantified) {
            tag.func_74757_a("Qua", true);
        }
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.func_74778_a("Sec", this.securityKey);
        }
        if (this.hideUpgrade) {
            tag.func_74757_a("HideUp", this.hideUpgrade);
        }
        NBTTagList slots = new NBTTagList();
        for (IDrawer drawer : this.drawers) {
            NBTTagCompound slot = new NBTTagCompound();
            drawer.writeToNBT(slot);
            slots.func_74742_a((NBTBase)slot);
        }
        tag.func_74782_a("Slots", (NBTBase)slots);
        if (this.materialSide != null) {
            itag = new NBTTagCompound();
            this.materialSide.func_77955_b(itag);
            tag.func_74782_a("MatS", (NBTBase)itag);
        }
        if (this.materialFront != null) {
            itag = new NBTTagCompound();
            this.materialFront.func_77955_b(itag);
            tag.func_74782_a("MatF", (NBTBase)itag);
        }
        if (this.materialTrim != null) {
            itag = new NBTTagCompound();
            this.materialTrim.func_77955_b(itag);
            tag.func_74782_a("MatT", (NBTBase)itag);
        }
        return tag;
    }

    public void func_70296_d() {
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.func_145831_w().func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q());
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        super.func_70296_d();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdateCount(final int slot, final int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                TileEntityDrawers.this.clientUpdateCountAsync(slot, count);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawerIfEnabled(slot);
        if (drawer != null && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public int getDrawerCount() {
        return this.drawers.length;
    }

    @Override
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.drawers.length) {
            return null;
        }
        return this.drawers[slot];
    }

    @Override
    public IDrawer getDrawerIfEnabled(int slot) {
        if (slot < 0 || slot >= this.drawers.length) {
            return null;
        }
        if (this.isSealed()) {
            return null;
        }
        if (this.func_145838_q() instanceof BlockDrawersCustom && this.materialSide == null) {
            return null;
        }
        return this.drawers[slot];
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        return this.getDrawerIfEnabled(slot) != null;
    }

    protected IItemHandler createUnSidedHandler() {
        return new DrawerItemHandler(this);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

