/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.chameleon.block.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerItemHandler;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySlave
extends ChamTileEntity
implements IDrawerGroup,
IPriorityGroup,
ISmartGroup {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    private DrawerItemHandler itemHandler = new DrawerItemHandler(this);

    public TileEntitySlave() {
        this.injectData(this.controllerData);
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.func_70296_d();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public TileEntityController getController() {
        return this.controllerData.getController((TileEntity)this);
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return null;
        }
        return controller.getDrawer(slot);
    }

    @Override
    public IDrawer getDrawerIfEnabled(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return null;
        }
        return controller.getDrawerIfEnabled(slot);
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return false;
        }
        return controller.isDrawerEnabled(slot);
    }

    public void func_70296_d() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.func_174877_v())) {
            controller.func_70296_d();
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.func_174877_v())) {
            return controller.markDirtyIfNeeded();
        }
        return false;
    }

    @Override
    public Iterable<Integer> enumerateDrawersForInsertion(ItemStack stack, boolean strict) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return new ArrayList<Integer>();
        }
        return controller.enumerateDrawersForInsertion(stack, strict);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForExtraction(ItemStack stack, boolean strict) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.func_174877_v())) {
            return new ArrayList<Integer>();
        }
        return controller.enumerateDrawersForExtraction(stack, strict);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

