/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Schematic {
    public static final int buildSize = 10000;
    public String name;
    public short width;
    public short height;
    public short length;
    private BlockPos offset = BlockPos.field_177992_a;
    private BlockPos start = BlockPos.field_177992_a;
    private Map<ChunkPos, NBTTagCompound>[] tileEntities;
    private NBTTagList entityList;
    public NBTTagList tileList;
    public short[] blockArray;
    public byte[] blockDataArray;
    private World world;
    public boolean isBuilding = false;
    public boolean firstLayer = true;
    public int buildPos;
    public int size;
    private int rotation = 0;

    public Schematic(String name) {
        this.name = name;
    }

    public void load(NBTTagCompound compound) {
        this.width = compound.func_74765_d("Width");
        this.height = compound.func_74765_d("Height");
        this.length = compound.func_74765_d("Length");
        this.size = this.width * this.height * this.length;
        byte[] addId = compound.func_74764_b("AddBlocks") ? compound.func_74770_j("AddBlocks") : new byte[]{};
        this.setBlockBytes(compound.func_74770_j("Blocks"), addId);
        this.blockDataArray = compound.func_74770_j("Data");
        this.entityList = compound.func_150295_c("Entities", 10);
        this.tileEntities = new Map[this.height];
        this.tileList = compound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < this.tileList.func_74745_c(); ++i) {
            NBTTagCompound teTag = this.tileList.func_150305_b(i);
            int x = teTag.func_74762_e("x");
            int y = teTag.func_74762_e("y");
            int z = teTag.func_74762_e("z");
            Map<ChunkPos, NBTTagCompound> map = this.tileEntities[y];
            if (map == null) {
                this.tileEntities[y] = map = new HashMap<ChunkPos, NBTTagCompound>();
            }
            map.put(new ChunkPos(x, z), teTag);
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Width", this.width);
        compound.func_74777_a("Height", this.height);
        compound.func_74777_a("Length", this.length);
        byte[][] arr = this.getBlockBytes();
        compound.func_74773_a("Blocks", arr[0]);
        if (arr.length > 1) {
            compound.func_74773_a("AddBlocks", arr[1]);
        }
        compound.func_74773_a("Data", this.blockDataArray);
        compound.func_74782_a("TileEntities", (NBTBase)this.tileList);
        return compound;
    }

    public void setBlockBytes(byte[] blockId, byte[] addId) {
        this.blockArray = new short[blockId.length];
        for (int index = 0; index < blockId.length; ++index) {
            short id = (short)(blockId[index] & 0xFF);
            if (index >> 1 < addId.length) {
                id = (index & 1) == 0 ? (short)(id + (short)((addId[index >> 1] & 0xF) << 8)) : (short)(id + (short)((addId[index >> 1] & 0xF0) << 4));
            }
            this.blockArray[index] = id;
        }
    }

    public byte[][] getBlockBytes() {
        byte[] blocks = new byte[this.blockArray.length];
        byte[] addBlocks = null;
        for (int i = 0; i < blocks.length; ++i) {
            short id = this.blockArray[i];
            if (id > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[i >> 1] = (i & 1) == 0 ? (byte)(addBlocks[i >> 1] & 0xF0 | id >> 8 & 0xF) : (byte)(addBlocks[i >> 1] & 0xF | (id >> 8 & 0xF) << 4);
            }
            blocks[i] = (byte)id;
        }
        if (addBlocks == null) {
            return new byte[][]{blocks};
        }
        return new byte[][]{blocks, addBlocks};
    }

    public NBTTagCompound getNBTSmall() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Width", this.width);
        compound.func_74777_a("Height", this.height);
        compound.func_74777_a("Length", this.length);
        compound.func_74778_a("SchematicName", this.name);
        if (this.size < 125000) {
            byte[][] arr = this.getBlockBytes();
            compound.func_74773_a("Blocks", arr[0]);
            if (arr.length > 1) {
                compound.func_74773_a("AddBlocks", arr[1]);
            }
            compound.func_74773_a("Data", this.blockDataArray);
        }
        return compound;
    }

    public void offset(int x, int y, int z) {
        this.offset = new BlockPos(x, y, z);
    }

    public void init(BlockPos pos, World world, int rotation) {
        this.start = pos;
        this.world = world;
        this.rotation = rotation;
    }

    public void build() {
        if (this.world == null || !this.isBuilding) {
            return;
        }
        long endPos = this.buildPos + 10000;
        if (endPos > (long)this.size) {
            endPos = this.size;
        }
        while ((long)this.buildPos < endPos) {
            int x = this.buildPos % this.width;
            int z = (this.buildPos - x) / this.width % this.length;
            int y = ((this.buildPos - x) / this.width - z) / this.length;
            if (this.firstLayer) {
                this.place(x, y, z, 1);
            } else {
                this.place(x, y, z, 2);
            }
            ++this.buildPos;
        }
        if (this.buildPos >= this.size) {
            if (this.firstLayer) {
                this.firstLayer = false;
                this.buildPos = 0;
            } else {
                this.isBuilding = false;
            }
        }
    }

    public void place(int x, int y, int z, int flag) {
        NBTTagCompound comp;
        TileEntity tile;
        int i = this.xyzToIndex(x, y, z);
        Block b = Block.func_149729_e((int)this.blockArray[i]);
        if (b == null || flag == 1 && !b.func_176223_P().func_185913_b() && b != Blocks.field_150350_a || flag == 2 && (b.func_176223_P().func_185913_b() || b == Blocks.field_150350_a)) {
            return;
        }
        int rotation = this.rotation / 90;
        BlockPos pos = this.start.func_177971_a((Vec3i)this.rotatePos(x, y, z, rotation));
        IBlockState state = b.func_176203_a((int)this.blockDataArray[i]);
        state = this.rotationState(state, rotation);
        this.world.func_180501_a(pos, state, 2);
        if (state.func_177230_c() instanceof ITileEntityProvider && (tile = this.world.func_175625_s(pos)) != null && (comp = this.getTileEntity(x, y, z, pos)) != null) {
            tile.func_145839_a(comp);
        }
    }

    public IBlockState rotationState(IBlockState state, int rotation) {
        if (rotation == 0) {
            return state;
        }
        ImmutableSet set = state.func_177228_b().keySet();
        for (IProperty prop : set) {
            EnumFacing direction;
            if (!(prop instanceof PropertyDirection) || (direction = (EnumFacing)state.func_177229_b(prop)) == EnumFacing.UP || direction == EnumFacing.DOWN) continue;
            for (int i = 0; i < rotation; ++i) {
                direction = direction.func_176746_e();
            }
            return state.func_177226_a(prop, (Comparable)direction);
        }
        return state;
    }

    public BlockPos rotatePos(int x, int y, int z, int rotation) {
        if (rotation == 1) {
            return new BlockPos(this.length - z - 1, y, x);
        }
        if (rotation == 2) {
            return new BlockPos(this.width - x - 1, y, this.length - z - 1);
        }
        if (rotation == 3) {
            return new BlockPos(z, y, this.width - x - 1);
        }
        return new BlockPos(x, y, z);
    }

    public NBTTagCompound getTileEntity(int x, int y, int z, BlockPos pos) {
        if (y >= this.tileEntities.length || this.tileEntities[y] == null) {
            return null;
        }
        NBTTagCompound compound = this.tileEntities[y].get(new ChunkPos(x, z));
        if (compound == null) {
            return null;
        }
        compound = compound.func_74737_b();
        compound.func_74768_a("x", pos.func_177958_n());
        compound.func_74768_a("y", pos.func_177956_o());
        compound.func_74768_a("z", pos.func_177952_p());
        return compound;
    }

    public int getPercentage() {
        double l = this.buildPos + (this.firstLayer ? 0 : this.size);
        return (int)(l / (double)this.size * 50.0);
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }
}

