/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.controllers.ServerCloneController;

public class EntityWrapper<T extends Entity>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private WorldWrapper worldWrapper;
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            EntityWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return EntityWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            EntityWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return EntityWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.tempData.clear();
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            NBTTagCompound compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            this.saveStoredCompound(compound);
        }

        @Override
        public Object get(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            if (!compound.func_74764_b(key)) {
                return null;
            }
            NBTBase base = compound.func_74781_a(key);
            if (base instanceof NBTPrimitive) {
                return ((NBTPrimitive)base).func_150286_g();
            }
            return ((NBTTagString)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            compound.func_82580_o(key);
            this.saveStoredCompound(compound);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().func_74764_b(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.entity.getEntityData().func_82580_o("CNPCStoredData");
        }

        private NBTTagCompound getStoredCompound() {
            NBTTagCompound compound = EntityWrapper.this.entity.getEntityData().func_74775_l("CNPCStoredData");
            if (compound == null) {
                compound = new NBTTagCompound();
                EntityWrapper.this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
            }
            return compound;
        }

        private void saveStoredCompound(NBTTagCompound compound) {
            EntityWrapper.this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
        }
    };

    public EntityWrapper(T entity) {
        this.entity = entity;
        this.worldWrapper = new WorldWrapper(((Entity)entity).field_70170_p);
    }

    @Override
    public double getX() {
        return ((Entity)this.entity).field_70165_t;
    }

    @Override
    public void setX(double x) {
        ((Entity)this.entity).field_70165_t = x;
    }

    @Override
    public double getY() {
        return ((Entity)this.entity).field_70163_u;
    }

    @Override
    public void setY(double y) {
        ((Entity)this.entity).field_70163_u = y;
    }

    @Override
    public double getZ() {
        return ((Entity)this.entity).field_70161_v;
    }

    @Override
    public void setZ(double z) {
        ((Entity)this.entity).field_70161_v = z;
    }

    @Override
    public int getBlockX() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70165_t);
    }

    @Override
    public int getBlockY() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70163_u);
    }

    @Override
    public int getBlockZ() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70161_v);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    @Override
    public IWorld getWorld() {
        if (((Entity)this.entity).field_70170_p != this.worldWrapper.world) {
            this.worldWrapper = new WorldWrapper(((Entity)this.entity).field_70170_p);
        }
        return this.worldWrapper;
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public void despawn() {
        ((Entity)this.entity).field_70128_L = true;
    }

    @Override
    public void spawn() {
        if (this.worldWrapper.world.func_175733_a(this.entity.func_110124_au()) != null) {
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((Entity)this.entity).field_70128_L = false;
        this.worldWrapper.world.func_72838_d(this.entity);
    }

    @Override
    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    @Override
    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    @Override
    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public String getTypeName() {
        return EntityList.func_75621_b(this.entity);
    }

    @Override
    public void dropItem(IItemStack item) {
        this.entity.func_70099_a(item.getMCItemStack(), 0.0f);
    }

    @Override
    public IEntity[] getRiders() {
        List list = this.entity.func_184188_bt();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public IEntity[] getAllRiders() {
        ArrayList list = new ArrayList(this.entity.func_184182_bu());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().func_184205_a(this.entity, true);
        }
    }

    @Override
    public void clearRiders() {
        this.entity.func_184226_ay();
    }

    @Override
    public IEntity getMount() {
        return NpcAPI.Instance().getIEntity(this.entity.func_184187_bx());
    }

    @Override
    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.func_184210_p();
        } else {
            this.entity.func_184205_a(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setRotation(float rotation) {
        ((Entity)this.entity).field_70177_z = rotation;
    }

    @Override
    public float getRotation() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public void setPitch(float rotation) {
        ((Entity)this.entity).field_70125_A = rotation;
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(MathHelper.func_76134_b((float)v) * (float)power));
        ((Entity)this.entity).field_70159_w *= 0.6;
        ((Entity)this.entity).field_70179_y *= 0.6;
        this.entity.func_70097_a(DamageSource.field_76380_i, 1.0E-4f);
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 0;
    }

    @Override
    public String getUUID() {
        return this.entity.func_110124_au().toString();
    }

    @Override
    public void storeAsClone(int tab, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        if (!this.entity.func_70039_c(compound)) {
            throw new CustomNPCsException("Cannot store dead or mounted entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }
}

