/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockScripted
extends BlockContainer
implements IPermission {
    public static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.001f, (double)0.001f, (double)0.001f, (double)0.998f, (double)0.998f, (double)0.998f);
    public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockScripted() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScripted();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile != null && tile.isPassible) {
            return AABB_EMPTY;
        }
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        return !EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            TileScripted tile = (TileScripted)world.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (EventHooks.onScriptBlockHarvest(tile, player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileScripted tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockExploded(tile = (TileScripted)world.func_175625_s(pos))) {
            return;
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockNeighborChanged(tile);
        int power = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            int p = world.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.func_176211_b(state, worldIn, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).activePowering;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isLadder;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isPassible;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return super.getEnchantPowerBonus(world, pos);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).blockHardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).blockResistance;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.SaveTileEntity || e == EnumPacketServer.ScriptBlockDataSave;
    }
}

