/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.client.handler;

import com.forgeessentials.commons.network.Packet3PlayerPermissions;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;

public class PermissionOverlay
extends Gui
implements IMessageHandler<Packet3PlayerPermissions, IMessage> {
    protected ResourceLocation deniedPlaceTexture;
    protected ResourceLocation deniedBreakTexture;
    protected Packet3PlayerPermissions permissions = new Packet3PlayerPermissions();

    public PermissionOverlay() {
        this.deniedPlaceTexture = new ResourceLocation("forgeessentialsclient".toLowerCase(), "textures/gui/denied_place.png");
        this.deniedBreakTexture = new ResourceLocation("forgeessentialsclient".toLowerCase(), "textures/gui/denied_break.png");
        this.field_73735_i = 100.0f;
    }

    public IMessage onMessage(Packet3PlayerPermissions message, MessageContext ctx) {
        if (message.reset) {
            this.permissions = message;
        } else {
            this.permissions.placeIds.addAll(message.placeIds);
            this.permissions.breakIds.addAll(message.breakIds);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.func_184614_ca();
            if (stack != null) {
                int itemId = GameData.getItemRegistry().getId((IForgeRegistryEntry)stack.func_77973_b());
                for (int id : message.placeIds) {
                    if (itemId != id) continue;
                    player.func_184597_cx();
                    break;
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent event) {
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.deniedPlaceTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            for (int i = 0; i < 9; ++i) {
                int id;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a[i];
                if (stack == null || !this.permissions.placeIds.contains(id = GameData.getItemRegistry().getId((IForgeRegistryEntry)stack.func_77973_b()))) continue;
                int x = width / 2 - 90 + i * 20 + 2;
                int y = height - 16 - 3;
                this.drawTexturedRect(x + 8, y + 1, 8.0, 8.0);
            }
        } else if (event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState block = Minecraft.func_71410_x().field_71441_e.func_180495_p(mop.func_178782_a());
                int blockId = GameData.getBlockRegistry().getId((IForgeRegistryEntry)block.func_177230_c());
                if (this.permissions.breakIds.contains(blockId)) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(this.deniedBreakTexture);
                    this.drawTexturedRect(width / 2 - 5, height / 2 - 5, 10.0, 10.0);
                    event.setCanceled(true);
                }
            }
        }
    }

    public void drawTexturedRect(double xPos, double yPos, double width, double height) {
        VertexBuffer wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(xPos, yPos + height, (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(xPos + width, yPos + height, (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(xPos + width, yPos, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(xPos, yPos, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

