/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Point {
    protected BlockPos blockPos;
    protected int x;
    protected int y;
    protected int z;
    private static final Pattern pattern = Pattern.compile("\\s*\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*\\]\\s*");

    public Point(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(double x, double y, double z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
    }

    public Point(Entity entity) {
        this.x = (int)Math.floor(entity.field_70165_t);
        this.y = (int)Math.floor(entity.field_70163_u);
        this.z = (int)Math.floor(entity.field_70161_v);
    }

    public Point(Vec3d vector) {
        this((int)vector.field_72450_a, (int)vector.field_72448_b, (int)vector.field_72449_c);
    }

    public Point(Point other) {
        this(other.x, other.y, other.z);
    }

    public BlockPos getBlockPos() {
        if (this.blockPos == null) {
            this.blockPos = new BlockPos(this.x, this.y, this.z);
        }
        return this.blockPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Point setX(int x) {
        this.x = x;
        this.blockPos = null;
        return this;
    }

    public Point setY(int y) {
        this.y = y;
        this.blockPos = null;
        return this;
    }

    public Point setZ(int z) {
        this.z = z;
        this.blockPos = null;
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double distance(Point v) {
        return Math.sqrt((this.x - v.x) * (this.x - v.x) + (this.y - v.y) * (this.y - v.y) + (this.z - v.z) * (this.z - v.z));
    }

    public void add(Point v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.blockPos = null;
    }

    public void subtract(Point v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.blockPos = null;
    }

    public boolean alignsWith(Point point) {
        return this.x == point.x || this.y == point.y || this.z == point.z;
    }

    public boolean isGreaterEqualThan(Point p) {
        return this.x >= p.x && this.y >= p.y && this.z >= p.z;
    }

    public boolean isLessEqualThan(Point p) {
        return this.x <= p.x && this.y <= p.y && this.z <= p.z;
    }

    public void validatePositiveY() {
        if (this.y < 0) {
            this.y = 0;
        }
        this.blockPos = null;
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public static Point fromString(String value) {
        Matcher match = pattern.matcher(value);
        if (!match.matches()) {
            return null;
        }
        return new Point(Integer.parseInt(match.group(1)), Integer.parseInt(match.group(2)), Integer.parseInt(match.group(3)));
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point p = (Point)object;
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }
        return false;
    }

    public int hashCode() {
        int h = 1 + this.x;
        h = h * 31 + this.y;
        h = h * 31 + this.z;
        return h;
    }
}

