/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldPoint;
import com.google.gson.annotations.Expose;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WarpPoint {
    protected int dim;
    protected float pitch;
    protected float yaw;
    protected double xd;
    protected double yd;
    protected double zd;
    @Expose(serialize=false)
    protected WorldServer world;
    private static final Pattern fromStringPattern = Pattern.compile("\\[(-?[\\d.]+),(-?[\\d.]+),(-?[\\d.]+),dim=(-?\\d+),pitch=(-?[\\d.]+),yaw=(-?[\\d.]+)\\]");

    public WarpPoint(int dimension, double x, double y, double z, float playerPitch, float playerYaw) {
        this.dim = dimension;
        this.xd = x;
        this.yd = y;
        this.zd = z;
        this.pitch = playerPitch;
        this.yaw = playerYaw;
    }

    public WarpPoint(WorldServer world, double x, double y, double z, float playerPitch, float playerYaw) {
        this.world = world;
        this.dim = world.field_73011_w.getDimension();
        this.xd = x;
        this.yd = y;
        this.zd = z;
        this.pitch = playerPitch;
        this.yaw = playerYaw;
    }

    public WarpPoint(int dimension, BlockPos location, float pitch, float yaw) {
        this(dimension, (double)location.func_177958_n() + 0.5, (double)location.func_177956_o(), (double)location.func_177952_p() + 0.5, pitch, yaw);
    }

    public WarpPoint(Point point, int dimension, float pitch, float yaw) {
        this(dimension, (double)point.getX(), (double)point.getY(), (double)point.getZ(), pitch, yaw);
    }

    public WarpPoint(WorldPoint point, float pitch, float yaw) {
        this(point.getDimension(), (double)point.getX() + 0.5, (double)point.getY(), (double)point.getZ() + 0.5, pitch, yaw);
    }

    public WarpPoint(WorldPoint point) {
        this(point, 0.0f, 0.0f);
    }

    public WarpPoint(Entity entity) {
        this(entity.field_70170_p instanceof WorldServer ? (WorldServer)entity.field_70170_p : null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70125_A, entity.field_70177_z);
    }

    public WarpPoint(WarpPoint point) {
        this(point.dim, point.xd, point.yd, point.zd, point.pitch, point.yaw);
    }

    public int getDimension() {
        return this.dim;
    }

    public double getX() {
        return this.xd;
    }

    public double getY() {
        return this.yd;
    }

    public double getZ() {
        return this.zd;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    public int getBlockX() {
        return (int)Math.floor(this.xd);
    }

    public int getBlockY() {
        return (int)Math.floor(this.yd);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.zd);
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void set(int dim, double xd, double yd, double zd, float pitch, float yaw) {
        this.dim = dim;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void setDimension(int dim) {
        this.dim = dim;
    }

    public WorldServer getWorld() {
        if (this.world == null || this.world.field_73011_w.getDimension() != this.dim) {
            this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim);
        }
        return this.world;
    }

    public void setX(double value) {
        this.xd = value;
    }

    public void setY(double value) {
        this.yd = value;
    }

    public void setZ(double value) {
        this.zd = value;
    }

    public void setPitch(float value) {
        this.pitch = value;
    }

    public void setYaw(float value) {
        this.yaw = value;
    }

    public double length() {
        return Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
    }

    public double distance(WarpPoint v) {
        return Math.sqrt((this.xd - v.xd) * (this.xd - v.xd) + (this.yd - v.yd) * (this.yd - v.yd) + (this.zd - v.zd) * (this.zd - v.zd));
    }

    public double distance(Entity e) {
        return Math.sqrt((this.xd - e.field_70165_t) * (this.xd - e.field_70165_t) + (this.yd - e.field_70163_u) * (this.yd - e.field_70163_u) + (this.zd - e.field_70161_v) * (this.zd - e.field_70161_v));
    }

    public void validatePositiveY() {
        if (this.yd < 0.0) {
            this.yd = 0.0;
        }
    }

    public Vec3d toVec3() {
        return new Vec3d(this.xd, this.yd, this.zd);
    }

    public WorldPoint toWorldPoint() {
        return new WorldPoint(this);
    }

    public String toString() {
        return "[" + this.xd + "," + this.yd + "," + this.zd + ",dim=" + this.dim + ",pitch=" + this.pitch + ",yaw=" + this.yaw + "]";
    }

    public String toReadableString() {
        return String.format("%.0f %.0f %.0f dim=%d", this.xd, this.yd, this.zd, this.dim);
    }

    public boolean equals(Object object) {
        if (object instanceof WarpPoint) {
            WarpPoint p = (WarpPoint)object;
            return this.xd == p.xd && this.yd == p.yd && this.zd == p.zd;
        }
        if (object instanceof Point) {
            Point p = (Point)object;
            return (int)this.xd == p.getX() && (int)this.yd == p.getY() && (int)this.zd == p.getZ();
        }
        if (object instanceof WorldPoint) {
            WorldPoint p = (WorldPoint)object;
            return this.dim == p.getDimension() && (int)this.xd == p.getX() && (int)this.yd == p.getY() && (int)this.zd == p.getZ();
        }
        return false;
    }

    public int hashCode() {
        int h = 1 + Double.valueOf(this.xd).hashCode();
        h = h * 31 + Double.valueOf(this.yd).hashCode();
        h = h * 31 + Double.valueOf(this.zd).hashCode();
        h = h * 31 + Double.valueOf(this.pitch).hashCode();
        h = h * 31 + Double.valueOf(this.yaw).hashCode();
        h = h * 31 + this.dim;
        return h;
    }

    public static WarpPoint fromString(String value) {
        Matcher m = fromStringPattern.matcher(value = value.replaceAll("\\s ", ""));
        if (m.matches()) {
            try {
                return new WarpPoint(Integer.parseInt(m.group(4)), Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)), Double.parseDouble(m.group(3)), Float.parseFloat(m.group(5)), Float.parseFloat(m.group(6)));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        WorldPoint worldPoint = WorldPoint.fromString(value);
        if (worldPoint == null) {
            return null;
        }
        return new WarpPoint(worldPoint);
    }
}

