/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldPoint;
import net.minecraft.world.World;

public class WorldArea
extends AreaBase {
    protected int dim;

    public WorldArea(World world, Point start, Point end) {
        super(start, end);
        this.dim = world.field_73011_w.getDimension();
    }

    public WorldArea(int dim, Point start, Point end) {
        super(start, end);
        this.dim = dim;
    }

    public WorldArea(int dim, AreaBase area) {
        super(area.getHighPoint(), area.getLowPoint());
        this.dim = dim;
    }

    public WorldArea(World world, AreaBase area) {
        super(area.getHighPoint(), area.getLowPoint());
        this.dim = world.field_73011_w.getDimension();
    }

    public int getDimension() {
        return this.dim;
    }

    public void setDimension(int dimensionId) {
        this.dim = dimensionId;
    }

    @Override
    public WorldPoint getCenter() {
        return new WorldPoint(this.dim, (this.high.x + this.low.x) / 2, (this.high.y + this.low.y) / 2, (this.high.z + this.low.z) / 2);
    }

    public boolean contains(WorldPoint point) {
        if (point.dim == this.dim) {
            return super.contains(point);
        }
        return false;
    }

    public boolean contains(WorldArea area) {
        if (area.dim == this.dim) {
            return super.contains(area);
        }
        return false;
    }

    public boolean intersectsWith(WorldArea area) {
        if (area.dim == this.dim) {
            return super.intersectsWith(area);
        }
        return false;
    }

    public AreaBase getIntersection(WorldArea area) {
        if (area.dim == this.dim) {
            return super.getIntersection(area);
        }
        return null;
    }

    public boolean makesCuboidWith(WorldArea area) {
        if (area.dim == this.dim) {
            return super.makesCuboidWith(area);
        }
        return false;
    }

    @Override
    public String toString() {
        return " { " + this.dim + " , " + this.getHighPoint().toString() + " , " + this.getLowPoint().toString() + " }";
    }
}

